/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SchemaOptionsTestCase
extends AbstractSchemaTestCase {
    private static final int TEST_OPTION_DEFAULT_VALUE = 42;
    private static final Option<Integer> TEST_OPTION = Option.of(Integer.class, (Object)42);

    @DataProvider
    private Object[][] defaultSchemaOptions() {
        return new Object[][]{{SchemaOptions.ALLOW_MALFORMED_CERTIFICATES}, {SchemaOptions.ALLOW_MALFORMED_JPEG_PHOTOS}, {SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS}, {SchemaOptions.ALLOW_NON_STANDARD_TELEPHONE_NUMBERS}, {SchemaOptions.ALLOW_ZERO_LENGTH_DIRECTORY_STRINGS}, {SchemaOptions.STRICT_FORMAT_FOR_COUNTRY_STRINGS}, {SchemaOptions.STRIP_UPPER_BOUND_FOR_ATTRIBUTE_TYPE}};
    }

    @Test(dataProvider="defaultSchemaOptions")
    public void testDefaultSchemaOptions(Option<?> option) {
        Options defaultOptions = Options.defaultOptions();
        Assertions.assertThat((Object)new SchemaBuilder().getOptions().get(option)).isEqualTo(defaultOptions.get(option));
    }

    @Test
    public void testAddSchemaOption() {
        Assertions.assertThat((Integer)((Integer)this.newSchemaBuilder().getOptions().get(TEST_OPTION))).isEqualTo(42);
    }

    @Test
    public void testSetSchemaOption() {
        Assertions.assertThat((Integer)((Integer)this.newSchemaBuilder().setOption(TEST_OPTION, (Object)0).getOptions().get(TEST_OPTION))).isEqualTo(0);
    }

    @Test
    public void testSchemaOptionsCopy() {
        Options copiedOptions = Options.copyOf((Options)this.newSchemaBuilder().getOptions());
        Assertions.assertThat((Integer)((Integer)copiedOptions.get(TEST_OPTION))).isEqualTo(42);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testAsReadOnlyOptions() {
        Options.unmodifiableCopyOf((Options)new SchemaBuilder().getOptions()).set(SchemaOptions.ALLOW_MALFORMED_CERTIFICATES, (Object)false);
    }

    private SchemaBuilder newSchemaBuilder() {
        return new SchemaBuilder().setOption(TEST_OPTION, (Object)42);
    }
}

