/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SchemaCompatTest
extends AbstractSchemaTestCase {
    private static final Syntax ATD_SYNTAX = CoreSchema.getAttributeTypeDescriptionSyntax();
    private static final Syntax OCD_SYNTAX = CoreSchema.getObjectClassDescriptionSyntax();

    @DataProvider
    public Object[][] validAttributeDescriptions() {
        return new Object[][]{{"cn", false}, {"cn-xxx", false}, {"cn", true}, {"cn-xxx", true}, {"cn_xxx", true}, {"cn.xxx", true}, {"cn;xxx", false}, {"cn;xxx-yyy", false}, {"cn;xxx", true}, {"cn;xxx-yyy", true}, {"cn;xxx_yyy", true}, {"cn;xxx.yyy", true}};
    }

    @Test(dataProvider="validAttributeDescriptions")
    public void testValidAttributeDescriptions(String atd, boolean allowIllegalCharacters) {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema()).setOption(SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS, (Object)allowIllegalCharacters);
        AttributeDescription.valueOf((String)atd, (Schema)builder.toSchema().asNonStrictSchema());
    }

    @DataProvider
    public Object[][] invalidAttributeDescriptions() {
        return new Object[][]{{"cn+xxx", false}, {"cn_xxx", false}, {"cn.xxx", false}, {"cn+xxx", true}, {"cn;xxx+yyy", false}, {"cn;xxx_yyy", false}, {"cn;xxx.yyy", false}, {"cn;xxx+yyy", true}};
    }

    @Test(dataProvider="invalidAttributeDescriptions", expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testInvalidAttributeDescriptions(String atd, boolean allowIllegalCharacters) {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.setOption(SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS, (Object)allowIllegalCharacters);
        AttributeDescription.valueOf((String)atd, (Schema)builder.toSchema().asNonStrictSchema());
    }

    @DataProvider
    public Object[][] invalidSchemaElements() {
        return new Object[][]{{"(testtype+oid NAME 'testtype' DESC 'full type' OBSOLETE SUP cn  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE USAGE userApplications )", ATD_SYNTAX, false}, {"(testtype_oid NAME 'testtype' DESC 'full type' OBSOLETE SUP cn  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE USAGE userApplications )", ATD_SYNTAX, false}, {"(testtype.oid NAME 'testtype' DESC 'full type' OBSOLETE SUP cn  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE USAGE userApplications )", ATD_SYNTAX, false}, {"(1.2.8.5 NAME 'test+type' DESC 'full type' OBSOLETE SUP cn  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE USAGE userApplications )", ATD_SYNTAX, false}, {"(1.2.8.5 NAME 'test.type' DESC 'full type' OBSOLETE SUP cn  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE USAGE userApplications )", ATD_SYNTAX, false}, {"(1.2.8.5 NAME 'test_type' DESC 'full type' OBSOLETE SUP cn  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE USAGE userApplications )", ATD_SYNTAX, false}, {"(1.2.8.5 NAME 'test+type' DESC 'full type' OBSOLETE SUP cn  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE USAGE userApplications )", ATD_SYNTAX, true}};
    }

    @Test(dataProvider="invalidSchemaElements", expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testInvalidSchemaBuilderElementParsers(String element, Syntax syntax, boolean allowIllegalCharacters) {
        SchemaBuilder builder = new SchemaBuilder();
        builder.setOption(SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS, (Object)allowIllegalCharacters);
        if (syntax == ATD_SYNTAX) {
            builder.addAttributeType(element, false);
        } else if (syntax == OCD_SYNTAX) {
            builder.addObjectClass(element, false);
        }
    }

    @DataProvider
    public Object[][] validSchemaElements() {
        return new Object[][]{{"(1.2.8.5 NAME 'testtype' DESC 'full type' OBSOLETE SUP cn  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE USAGE userApplications )", ATD_SYNTAX, false}, {"(testtype-oid NAME 'testtype' DESC 'full type' OBSOLETE SUP cn  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE USAGE userApplications )", ATD_SYNTAX, false}, {"(testtype_oid NAME 'testtype' DESC 'full type' OBSOLETE SUP cn  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE USAGE userApplications )", ATD_SYNTAX, true}, {"(testtype.oid NAME 'testtype' DESC 'full type' OBSOLETE SUP cn  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE USAGE userApplications )", ATD_SYNTAX, true}, {"(1.2.8.5 NAME 'test-type' DESC 'full type' OBSOLETE SUP cn  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE USAGE userApplications )", ATD_SYNTAX, false}, {"(1.2.8.5 NAME 'test.type' DESC 'full type' OBSOLETE SUP cn  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE USAGE userApplications )", ATD_SYNTAX, true}, {"(1.2.8.5 NAME 'test_type' DESC 'full type' OBSOLETE SUP cn  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE USAGE userApplications )", ATD_SYNTAX, true}};
    }

    @Test(dataProvider="validSchemaElements")
    public void testValidSchemaBuilderElementParsers(String element, Syntax syntax, boolean allowIllegalCharacters) {
        SchemaBuilder builder = new SchemaBuilder();
        builder.setOption(SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS, (Object)allowIllegalCharacters);
        if (syntax == ATD_SYNTAX) {
            builder.addAttributeType(element, false);
        } else if (syntax == OCD_SYNTAX) {
            builder.addObjectClass(element, false);
        }
    }
}

