/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.CollectionAssert;
import org.fest.assertions.Fail;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.AttributeUsage;
import org.forgerock.opendj.ldap.schema.ConflictingSchemaElementException;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.opendj.ldap.schema.DITContentRule;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleUse;
import org.forgerock.opendj.ldap.schema.NameForm;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.mockito.Mockito;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SchemaBuilderTestCase
extends AbstractSchemaTestCase {
    @Test
    public void attributeTypeDependenciesChildThenParent() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).addAttributeType("( childtype-oid NAME 'childtype' SUP parenttype )", false).addAttributeType("( parenttype-oid NAME 'parenttype' SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 )", false).toSchema();
        Assertions.assertThat((Object)schema.getAttributeType("childtype").getSyntax()).isNotNull();
        Assertions.assertThat((String)schema.getAttributeType("childtype").getSyntax().getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.15");
    }

    @Test
    public void attributeTypeDependenciesParentThenChild() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).addAttributeType("( parenttype-oid NAME 'parenttype' SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 )", false).addAttributeType("( childtype-oid NAME 'childtype' SUP parenttype )", false).toSchema();
        Assertions.assertThat((Object)schema.getAttributeType("childtype").getSyntax()).isNotNull();
        Assertions.assertThat((String)schema.getAttributeType("childtype").getSyntax().getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.15");
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void attributeTypeNoSuperiorNoSyntaxWhenStrict() {
        new SchemaBuilder(Schema.getCoreSchema()).setOption(SchemaOptions.ALLOW_ATTRIBUTE_TYPES_WITH_NO_SUP_OR_SYNTAX, (Object)false).addAttributeType("( parenttype-oid NAME 'parenttype' )", false);
    }

    @Test
    public void attributeTypeNoSuperiorNoSyntaxWhenLeniant() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).addAttributeType("( parenttype-oid NAME 'parenttype' )", false).toSchema();
        Assertions.assertThat((Object)schema.getAttributeType("parenttype").getSyntax()).isNotNull();
        Assertions.assertThat((String)schema.getAttributeType("parenttype").getSyntax().getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.40");
    }

    @Test
    public void attributeTypeSuperiorFailureChildThenParent() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).addAttributeType("( childtype-oid NAME 'childtype' SUP parenttype )", false).addAttributeType("( parenttype-oid NAME 'parenttype' SUP xxx )", false).toSchema();
        try {
            schema.getAttributeType("childtype");
            Fail.fail((String)"childtype should not be in the schema because its parent is invalid");
        }
        catch (UnknownSchemaElementException unknownSchemaElementException) {
            // empty catch block
        }
        try {
            schema.getAttributeType("parenttype");
            Fail.fail((String)"parenttype should not be in the schema because it is invalid");
        }
        catch (UnknownSchemaElementException unknownSchemaElementException) {
            // empty catch block
        }
    }

    @Test
    public void attributeTypeSuperiorFailureParentThenChild() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).addAttributeType("( parenttype-oid NAME 'parenttype' SUP xxx )", false).addAttributeType("( childtype-oid NAME 'childtype' SUP parenttype )", false).toSchema();
        try {
            schema.getAttributeType("childtype");
            Fail.fail((String)"childtype should not be in the schema because its parent is invalid");
        }
        catch (UnknownSchemaElementException unknownSchemaElementException) {
            // empty catch block
        }
        try {
            schema.getAttributeType("parenttype");
            Fail.fail((String)"parenttype should not be in the schema because it is invalid");
        }
        catch (UnknownSchemaElementException unknownSchemaElementException) {
            // empty catch block
        }
    }

    @Test
    public void collectiveAttribute() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).addAttributeType("( 2.5.4.11.1 NAME 'c-ou' SUP ou SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 COLLECTIVE X-ORIGIN 'RFC 3671' )", false).toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
    }

    @Test
    public void copyOnWriteNoChanges() {
        Schema baseSchema = Schema.getCoreSchema();
        Schema schema = new SchemaBuilder(baseSchema).toSchema();
        Assertions.assertThat((Object)schema).isSameAs((Object)baseSchema);
    }

    @Test
    public void copyOnWriteWithChanges() {
        Schema baseSchema = Schema.getCoreSchema();
        Schema schema = new SchemaBuilder(baseSchema).addAttributeType("( testtype-oid NAME 'testtype' SUP name )", false).toSchema();
        Assertions.assertThat((Object)schema).isNotSameAs((Object)baseSchema);
        Assertions.assertThat(new ArrayList(schema.getObjectClasses())).isEqualTo(new ArrayList(baseSchema.getObjectClasses()));
        Assertions.assertThat((boolean)schema.getAttributeTypes().containsAll(baseSchema.getAttributeTypes()));
        Assertions.assertThat((Object)schema.getAttributeType("testtype")).isNotNull();
        Assertions.assertThat((String)schema.getSchemaName()).startsWith(baseSchema.getSchemaName());
        Assertions.assertThat((Boolean)((Boolean)schema.getOption(SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS))).isEqualTo(baseSchema.getOption(SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS));
    }

    @Test
    public void createEmptySchema() {
        Schema schema = new SchemaBuilder().toSchema();
        Assertions.assertThat((Collection)schema.getAttributeTypes()).isEmpty();
        Assertions.assertThat((Collection)schema.getObjectClasses()).isEmpty();
        Assertions.assertThat((Collection)schema.getSyntaxes()).isEmpty();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Object)schema.getDefaultSyntax()).isEqualTo((Object)CoreSchema.getOctetStringSyntax());
        Assertions.assertThat((Object)schema.getDefaultMatchingRule()).isEqualTo((Object)CoreSchema.getOctetStringMatchingRule());
    }

    @Test
    public void multipleToSchema1() {
        Schema baseSchema = Schema.getCoreSchema();
        SchemaBuilder builder = new SchemaBuilder(baseSchema);
        Schema schema1 = builder.toSchema();
        Schema schema2 = builder.toSchema();
        Assertions.assertThat((Object)schema1).isSameAs((Object)baseSchema);
        Assertions.assertThat((Object)schema1).isSameAs((Object)schema2);
    }

    @Test
    public void multipleToSchema2() {
        SchemaBuilder builder = new SchemaBuilder().addAttributeType("( testtype-oid NAME 'testtype' SYNTAX 1.3.6.1.4.1.1466.115.121.1.40 )", false);
        Schema schema1 = builder.toSchema();
        Schema schema2 = builder.toSchema();
        Assertions.assertThat((Object)schema1).isSameAs((Object)schema2);
        Assertions.assertThat((Object)schema1.getAttributeType("testtype")).isNotNull();
        Assertions.assertThat((Object)schema2.getAttributeType("testtype")).isNotNull();
    }

    @Test
    public void objectClassDependenciesChildThenParent() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).addObjectClass("( childtype-oid NAME 'childtype' SUP parenttype STRUCTURAL MUST sn )", false).addObjectClass("( parenttype-oid NAME 'parenttype' SUP top STRUCTURAL MUST cn )", false).toSchema();
        AttributeType cn = schema.getAttributeType("cn");
        AttributeType sn = schema.getAttributeType("sn");
        Assertions.assertThat((boolean)schema.getObjectClass("childtype").isRequired(cn)).isTrue();
        Assertions.assertThat((boolean)schema.getObjectClass("childtype").isRequired(sn)).isTrue();
    }

    @Test
    public void objectClassDependenciesParentThenChild() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).addObjectClass("( parenttype-oid NAME 'parenttype' SUP top STRUCTURAL MUST cn )", false).addObjectClass("( childtype-oid NAME 'childtype' SUP parenttype STRUCTURAL MUST sn )", false).toSchema();
        AttributeType cn = schema.getAttributeType("cn");
        AttributeType sn = schema.getAttributeType("sn");
        Assertions.assertThat((boolean)schema.getObjectClass("childtype").isRequired(cn)).isTrue();
        Assertions.assertThat((boolean)schema.getObjectClass("childtype").isRequired(sn)).isTrue();
    }

    @Test
    public void objectClassSuperiorFailureChildThenParent() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).addObjectClass("( childtype-oid NAME 'childtype' SUP parenttype STRUCTURAL MUST sn )", false).addObjectClass("( parenttype-oid NAME 'parenttype' SUP top STRUCTURAL MUST xxx )", false).toSchema();
        try {
            schema.getObjectClass("childtype");
            Fail.fail((String)"childtype should not be in the schema because its parent is invalid");
        }
        catch (UnknownSchemaElementException unknownSchemaElementException) {
            // empty catch block
        }
        try {
            schema.getObjectClass("parenttype");
            Fail.fail((String)"parenttype should not be in the schema because it is invalid");
        }
        catch (UnknownSchemaElementException unknownSchemaElementException) {
            // empty catch block
        }
    }

    @Test
    public void objectClassSuperiorFailureParentThenChild() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).addObjectClass("( parenttype-oid NAME 'parenttype' SUP top STRUCTURAL MUST xxx )", false).addObjectClass("( childtype-oid NAME 'childtype' SUP parenttype STRUCTURAL MUST sn )", false).toSchema();
        try {
            schema.getObjectClass("childtype");
            Fail.fail((String)"childtype should not be in the schema because its parent is invalid");
        }
        catch (UnknownSchemaElementException unknownSchemaElementException) {
            // empty catch block
        }
        try {
            schema.getObjectClass("parenttype");
            Fail.fail((String)"parenttype should not be in the schema because it is invalid");
        }
        catch (UnknownSchemaElementException unknownSchemaElementException) {
            // empty catch block
        }
    }

    @Test
    public void reuseSchemaBuilder() {
        SchemaBuilder builder = new SchemaBuilder();
        Schema schema1 = builder.addAttributeType("( testtype1-oid NAME 'testtype1' SYNTAX 1.3.6.1.4.1.1466.115.121.1.40 )", false).toSchema();
        Schema schema2 = builder.addAttributeType("( testtype2-oid NAME 'testtype2' SYNTAX 1.3.6.1.4.1.1466.115.121.1.40 )", false).toSchema();
        Assertions.assertThat((Object)schema1).isNotSameAs((Object)schema2);
        Assertions.assertThat((Object)schema1.getAttributeType("testtype1")).isNotNull();
        Assertions.assertThat((boolean)schema1.hasAttributeType("testtype2")).isFalse();
        Assertions.assertThat((Object)schema2.getAttributeType("testtype1")).isNotNull();
        Assertions.assertThat((Object)schema2.getAttributeType("testtype2")).isNotNull();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void schemaBuilderDoesntAllowNullEntry() throws Exception {
        new SchemaBuilder((Entry)null);
    }

    @Test
    public final void schemaBuilderWithEntryWithCoreSchema() throws Exception {
        String[] strEntry = new String[]{"dn: cn=schema", "objectClass: top", "objectClass: ldapSubentry", "objectClass: subschema", "cn: schema", "attributeTypes: ( temporary-fake-attr-id NAME 'myCustomAttribute' EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 USAGE userApplications )", "objectClasses: ( temporary-fake-oc-id NAME 'myCustomObjClass' SUP top AUXILIARY MAY myCustomAttribute )", "modifiersName: cn=Directory Manager,cn=Root DNs,cn=config", "modifyTimestamp: 20110620095948Z"};
        LinkedHashMapEntry e = new LinkedHashMapEntry(strEntry);
        SchemaBuilder builder = new SchemaBuilder((Entry)e);
        Assertions.assertThat((Collection)e.getAttribute("ldapSyntaxes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("attributeTypes")).isNotNull();
        Assertions.assertThat((Collection)e.getAttribute("objectClasses")).isNotNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRuleUse")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITContentRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITStructureRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("nameForms")).isNull();
        builder.addSchema(Schema.getCoreSchema(), false);
        Schema schema = builder.toSchema();
        Assertions.assertThat((Object)schema.getAttributeType("myCustomAttribute")).isNotNull();
        Assertions.assertThat((String)schema.getAttributeType("myCustomAttribute").getNameOrOID()).isEqualTo((Object)"myCustomAttribute");
        Assertions.assertThat((String)schema.getAttributeType("myCustomAttribute").getSyntax().toString()).isEqualTo((Object)"( 1.3.6.1.4.1.1466.115.121.1.15 DESC 'Directory String' X-ORIGIN 'RFC 4512' )");
        Assertions.assertThat((String)schema.getAttributeType("myCustomAttribute").getUsage().toString()).isEqualTo((Object)"userApplications");
        Assertions.assertThat((boolean)schema.getObjectClass("myCustomObjClass").isPlaceHolder()).isFalse();
    }

    @Test(expectedExceptions={UnknownSchemaElementException.class})
    public final void schemaBuilderWithEntryWithoutCoreSchema() throws Exception {
        String[] strEntry = new String[]{"dn: cn=schema", "objectClass: top", "objectClass: ldapSubentry", "objectClass: subschema", "cn: schema", "attributeTypes: ( temporary-fake-attr-id NAME 'myCustomAttribute' EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 USAGE userApplications )", "objectClasses: ( temporary-fake-oc-id NAME 'myCustomObjClass' SUP top AUXILIARY MAY myCustomAttribute )", "modifiersName: cn=Directory Manager,cn=Root DNs,cn=config", "modifyTimestamp: 20110620095948Z"};
        LinkedHashMapEntry e = new LinkedHashMapEntry(strEntry);
        SchemaBuilder builder = new SchemaBuilder((Entry)e);
        Assertions.assertThat((Collection)e.getAttribute("attributeTypes")).isNotNull();
        Assertions.assertThat((Collection)e.getAttribute("objectClasses")).isNotNull();
        Schema schema = builder.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isNotEmpty();
        Assertions.assertThat((Object)schema.getAttributeType("myCustomAttribute")).isNotNull();
    }

    @Test
    public final void schemaBuilderAttributeWithoutSpace() throws Exception {
        String[] strEntry = new String[]{"dn: cn=schema", "objectClass: top", "objectClass: ldapSubentry", "objectClass: subschema", "cn: schema", "attributeTypes: ( foo-oid NAME 'foo' SUP name DESC 'No trailing space' USAGE userApplications)"};
        LinkedHashMapEntry e = new LinkedHashMapEntry(strEntry);
        SchemaBuilder builder = new SchemaBuilder();
        builder.addSchema(Schema.getCoreSchema(), false);
        builder.addSchema((Entry)e, true);
        Assertions.assertThat((Collection)e.getAttribute("ldapSyntaxes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("attributeTypes")).isNotNull();
        Assertions.assertThat((Collection)e.getAttribute("objectClasses")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRuleUse")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITContentRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITStructureRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("nameForms")).isNull();
        Schema schema = builder.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((String)schema.getAttributeType("foo").getDescription()).isEqualTo((Object)"No trailing space");
    }

    @Test
    public final void schemaBuilderAttributeExtensionWithoutSpace() throws Exception {
        String[] strEntry = new String[]{"dn: cn=schema", "objectClass: top", "objectClass: ldapSubentry", "objectClass: subschema", "cn: schema", "attributeTypes: ( foo-oid NAME 'foo' SUP name DESC 'No trailing space' X-SCHEMA-FILE '99-test.ldif')"};
        LinkedHashMapEntry e = new LinkedHashMapEntry(strEntry);
        SchemaBuilder builder = new SchemaBuilder();
        builder.addSchema(Schema.getCoreSchema(), false);
        builder.addSchema((Entry)e, true);
        Assertions.assertThat((Collection)e.getAttribute("ldapSyntaxes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("attributeTypes")).isNotNull();
        Assertions.assertThat((Collection)e.getAttribute("objectClasses")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRuleUse")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITContentRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITStructureRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("nameForms")).isNull();
        Schema schema = builder.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((String)schema.getAttributeType("foo").getDescription()).isEqualTo((Object)"No trailing space");
    }

    @Test
    public final void schemaBuilderWithEntryAddLdapSyntax() throws Exception {
        String[] strEntry = new String[]{"dn: cn=schema", "objectClass: top", "objectClass: ldapSubentry", "objectClass: subschema", "cn: schema", "ldapSyntaxes: ( 1.3.6.1.4.1.1466.115.121.1.15 DESC 'Add a new ldapsyntax' )"};
        LinkedHashMapEntry e = new LinkedHashMapEntry(strEntry);
        SchemaBuilder builder = new SchemaBuilder();
        builder.addSchema(Schema.getCoreSchema(), false);
        builder.addSchema((Entry)e, true);
        Assertions.assertThat((Collection)e.getAttribute("ldapSyntaxes")).isNotNull();
        Assertions.assertThat((Collection)e.getAttribute("attributeTypes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("objectClasses")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRuleUse")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITContentRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITStructureRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("nameForms")).isNull();
        Schema schema = builder.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Collection)schema.getSyntaxes()).isNotEmpty();
        Assertions.assertThat((String)schema.getSyntax("1.3.6.1.4.1.1466.115.121.1.15").getDescription()).isEqualTo((Object)"Add a new ldapsyntax");
    }

    @Test
    public final void schemaBuilderWithEntryAddMalformedLdapSyntax() throws Exception {
        String[] strEntry = new String[]{"dn: cn=schema", "objectClass: top", "objectClass: ldapSubentry", "objectClass: subschema", "cn: schema", "ldapSyntaxes: ( 1.3.6.1.4.1.1466.115.121.1.15 MALFORMEDTOKEN 'binary' )"};
        LinkedHashMapEntry e = new LinkedHashMapEntry(strEntry);
        SchemaBuilder builder = new SchemaBuilder();
        builder.addSchema(Schema.getCoreSchema(), false);
        builder.addSchema((Entry)e, false);
        Assertions.assertThat((Collection)e.getAttribute("ldapSyntaxes")).isNotNull();
        Assertions.assertThat((Collection)e.getAttribute("attributeTypes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("objectClasses")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRuleUse")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITContentRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITStructureRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("nameForms")).isNull();
        Schema sc = builder.toSchema();
        Assertions.assertThat((Collection)sc.getWarnings()).isNotEmpty();
        Assertions.assertThat((String)sc.getWarnings().toString()).contains("illegal token \"MALFORMEDTOKEN\"");
    }

    @Test
    public final void schemaBuilderWithEntryAddMatchingRuleUse() throws Exception {
        String[] strEntry = new String[]{"dn: cn=schema", "objectClass: top", "objectClass: ldapSubentry", "objectClass: subschema", "cn: schema", "matchingRuleUse: ( 2.5.13.16 NAME 'bitStringMatch' APPLIES ( givenName $ surname ) )"};
        LinkedHashMapEntry e = new LinkedHashMapEntry(strEntry);
        SchemaBuilder builder = new SchemaBuilder();
        builder.addSchema(Schema.getCoreSchema(), false);
        builder.addSchema((Entry)e, false);
        Assertions.assertThat((Collection)e.getAttribute("ldapSyntaxes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("attributeTypes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("objectClasses")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRuleUse")).isNotNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITContentRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITStructureRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("nameForms")).isNull();
        Schema schema = builder.toSchema();
        Assertions.assertThat((Collection)schema.getMatchingRuleUses()).isNotEmpty();
        Assertions.assertThat((String)schema.getMatchingRuleUse("bitStringMatch").toString()).isEqualTo((Object)"( 2.5.13.16 NAME 'bitStringMatch' APPLIES ( givenName $ surname ) )");
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
    }

    @Test
    public final void schemaBuilderWithEntryAddMalformedMatchingRuleUse() throws Exception {
        String[] strEntry = new String[]{"dn: cn=schema", "objectClass: top", "objectClass: ldapSubentry", "objectClass: subschema", "cn: schema", "matchingRuleUse: ( 2.5.13.16 NAM 'bitStringMatch' APPLIES ( givenName $ surname ) )"};
        LinkedHashMapEntry e = new LinkedHashMapEntry(strEntry);
        SchemaBuilder builder = new SchemaBuilder();
        builder.addSchema(Schema.getCoreSchema(), false);
        builder.addSchema((Entry)e, false);
        Assertions.assertThat((Collection)e.getAttribute("ldapSyntaxes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("attributeTypes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("objectClasses")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRuleUse")).isNotNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITContentRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITStructureRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("nameForms")).isNull();
        Schema schema = builder.toSchema();
        Assertions.assertThat((Collection)schema.getMatchingRuleUses()).isEmpty();
        Assertions.assertThat((Collection)schema.getWarnings()).isNotEmpty();
        Assertions.assertThat((String)schema.getWarnings().toString()).contains("illegal token");
    }

    @Test
    public final void schemaBuilderWithEntryAddMatchingRule() throws Exception {
        String[] strEntry = new String[]{"dn: cn=schema", "objectClass: top", "objectClass: ldapSubentry", "objectClass: subschema", "cn: schema", "matchingRules: ( 2.5.13.16 NAME 'bitStringMatch' SYNTAX 1.3.6.1.4.1.1466.115.121.1.6 )"};
        LinkedHashMapEntry e = new LinkedHashMapEntry(strEntry);
        SchemaBuilder builder = new SchemaBuilder();
        builder.addSchema(Schema.getCoreSchema(), false);
        builder.addSchema((Entry)e, true);
        Assertions.assertThat((Collection)e.getAttribute("ldapSyntaxes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("attributeTypes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("objectClasses")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRuleUse")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRules")).isNotNull();
        Assertions.assertThat((Collection)e.getAttribute("dITContentRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITStructureRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("nameForms")).isNull();
        Schema schema = builder.toSchema();
        Assertions.assertThat((Collection)schema.getMatchingRules()).isNotEmpty();
        Assertions.assertThat((String)schema.getMatchingRule("bitStringMatch").toString()).isEqualTo((Object)"( 2.5.13.16 NAME 'bitStringMatch' SYNTAX 1.3.6.1.4.1.1466.115.121.1.6 )");
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
    }

    @Test
    public final void schemaBuilderWithEntryAddMalformedMatchingRule() throws Exception {
        String[] strEntry = new String[]{"dn: cn=schema", "objectClass: top", "objectClass: ldapSubentry", "objectClass: subschema", "cn: schema", "matchingRules: ( 2.5.13.16 NAME 'bitStringMatch' SYNTAXE 1.3.6.1.4.1.1466.115.121.1.6 )"};
        LinkedHashMapEntry e = new LinkedHashMapEntry(strEntry);
        SchemaBuilder builder = new SchemaBuilder();
        builder.addSchema(Schema.getCoreSchema(), false);
        builder.addSchema((Entry)e, true);
        Assertions.assertThat((Collection)e.getAttribute("ldapSyntaxes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("attributeTypes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("objectClasses")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRuleUse")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRules")).isNotNull();
        Assertions.assertThat((Collection)e.getAttribute("dITContentRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITStructureRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("nameForms")).isNull();
        Schema schema = builder.toSchema();
        Assertions.assertThat((Collection)schema.getMatchingRuleUses()).isEmpty();
        Assertions.assertThat((Collection)schema.getWarnings()).isNotEmpty();
        Assertions.assertThat((String)schema.getWarnings().toString()).contains("illegal token");
    }

    @Test
    public final void schemaBuilderWithEntryAddDITContentRule() throws Exception {
        String[] strEntry = new String[]{"dn: cn=schema", "objectClass: top", "objectClass: ldapSubentry", "objectClass: subschema", "cn: schema", "DITContentRules: ( 2.5.6.4 DESC 'content rule for organization' NOT ( x121Address $ telexNumber ) )"};
        LinkedHashMapEntry e = new LinkedHashMapEntry(strEntry);
        SchemaBuilder builder = new SchemaBuilder();
        builder.addSchema(Schema.getCoreSchema(), false);
        builder.addSchema((Entry)e, true);
        Assertions.assertThat((Collection)e.getAttribute("ldapSyntaxes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("attributeTypes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("objectClasses")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRuleUse")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITContentRules")).isNotNull();
        Assertions.assertThat((Collection)e.getAttribute("dITStructureRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("nameForms")).isNull();
        Schema schema = builder.toSchema();
        Assertions.assertThat((Collection)schema.getDITContentRules()).isNotEmpty();
        Assertions.assertThat((String)schema.getDITContentRule("2.5.6.4").toString()).isEqualTo((Object)"( 2.5.6.4 DESC 'content rule for organization' NOT ( x121Address $ telexNumber ) )");
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
    }

    @Test
    public final void schemaBuilderWithEntryAddMalformedDITContentRule() throws Exception {
        String[] strEntry = new String[]{"dn: cn=schema", "objectClass: top", "objectClass: ldapSubentry", "objectClass: subschema", "cn: schema", "DITContentRules: ( 2.5.6.4 DESCS 'content rule for organization' NOT ( x121Address $ telexNumber ) )"};
        LinkedHashMapEntry e = new LinkedHashMapEntry(strEntry);
        SchemaBuilder builder = new SchemaBuilder();
        builder.addSchema(Schema.getDefaultSchema(), false);
        builder.addSchema((Entry)e, true);
        Assertions.assertThat((Collection)e.getAttribute("ldapSyntaxes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("attributeTypes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("objectClasses")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRuleUse")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITContentRules")).isNotNull();
        Assertions.assertThat((Collection)e.getAttribute("dITStructureRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("nameForms")).isNull();
        Schema schema = builder.toSchema();
        Assertions.assertThat((Collection)schema.getDITContentRules()).isEmpty();
        Assertions.assertThat((Collection)schema.getWarnings()).isNotEmpty();
        Assertions.assertThat((String)schema.getWarnings().toString()).contains("illegal token");
    }

    @Test
    public final void schemaBuilderWithEntryAddObjectClass() throws Exception {
        String[] strEntry = new String[]{"dn: cn=schema", "objectClass: top", "objectClass: ldapSubentry", "objectClass: subschema", "cn: schema", "objectClasses:  ( 1.3.6.1.4.1.36733.2.1.1.15.1 NAME 'myNewClass' SUP top MUST ( cn ) MAY (sn $ uid) )"};
        LinkedHashMapEntry e = new LinkedHashMapEntry(strEntry);
        SchemaBuilder builder = new SchemaBuilder();
        builder.addSchema(Schema.getDefaultSchema(), false);
        builder.addSchema((Entry)e, true);
        Assertions.assertThat((Collection)e.getAttribute("ldapSyntaxes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("attributeTypes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("objectClasses")).isNotNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRuleUse")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITContentRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITStructureRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("nameForms")).isNull();
        Schema schema = builder.toSchema();
        Assertions.assertThat((Collection)schema.getDITContentRules()).isEmpty();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((String)schema.getObjectClass("myNewClass").getOID()).isEqualTo((Object)"1.3.6.1.4.1.36733.2.1.1.15.1");
    }

    @Test
    public final void schemaBuilderWithEntryAddMalformedObjectClass() throws Exception {
        String[] strEntry = new String[]{"dn: cn=schema", "objectClass: top", "objectClass: ldapSubentry", "objectClass: subschema", "cn: schema", "objectClasses: ( 1.3.6.1.4.1.36733.2.1.1.15.1 NAME 'myNewClass' SUP top MUST ( unknownAttribute ) MAY (sn $ uid) )"};
        LinkedHashMapEntry e = new LinkedHashMapEntry(strEntry);
        SchemaBuilder builder = new SchemaBuilder();
        builder.addSchema(Schema.getDefaultSchema(), false);
        builder.addSchema((Entry)e, true);
        Assertions.assertThat((Collection)e.getAttribute("ldapSyntaxes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("attributeTypes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("objectClasses")).isNotNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRuleUse")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITContentRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITStructureRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("nameForms")).isNull();
        Schema schema = builder.toSchema();
        Assertions.assertThat((Collection)schema.getDITContentRules()).isEmpty();
        Assertions.assertThat((Collection)schema.getWarnings()).isNotEmpty();
        Assertions.assertThat((String)schema.getWarnings().toString()).contains("\"unknownAttribute\" which is not defined in the schema");
    }

    @Test
    public final void schemaBuilderAddAttributeWithEntryContainingDescriptionWithCoreSchema() throws Exception {
        String[] strEntry = new String[]{"dn: cn=schema", "objectClass: top", "objectClass: ldapSubentry", "objectClass: subschema", "cn: schema", "attributeTypes: ( temporary-fake-attr-id NAME 'myCustomAttribute' DESC 'A short description' EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 USAGE userApplications )", "objectClasses: ( temporary-fake-oc-id NAME 'myCustomObjClass' SUP top AUXILIARY MAY myCustomAttribute )", "modifiersName: cn=Directory Manager,cn=Root DNs,cn=config", "modifyTimestamp: 20110620095948Z"};
        LinkedHashMapEntry e = new LinkedHashMapEntry(strEntry);
        SchemaBuilder builder = new SchemaBuilder((Entry)e);
        Assertions.assertThat((Collection)e.getAttribute("ldapSyntaxes")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("attributeTypes")).isNotNull();
        Assertions.assertThat((Collection)e.getAttribute("objectClasses")).isNotNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRuleUse")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("matchingRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITContentRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("dITStructureRules")).isNull();
        Assertions.assertThat((Collection)e.getAttribute("nameForms")).isNull();
        builder.addSchema(Schema.getCoreSchema(), false);
        Schema schema = builder.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Object)schema.getAttributeType("myCustomAttribute")).isNotNull();
        Assertions.assertThat((String)schema.getAttributeType("myCustomAttribute").getNameOrOID()).isEqualTo((Object)"myCustomAttribute");
        Assertions.assertThat((String)schema.getAttributeType("myCustomAttribute").getSyntax().toString()).isEqualTo((Object)"( 1.3.6.1.4.1.1466.115.121.1.15 DESC 'Directory String' X-ORIGIN 'RFC 4512' )");
        Assertions.assertThat((String)schema.getAttributeType("myCustomAttribute").getUsage().toString()).isEqualTo((Object)"userApplications");
        Assertions.assertThat((String)schema.getAttributeType("myCustomAttribute").getDescription()).isEqualTo((Object)"A short description");
        Assertions.assertThat((boolean)schema.getObjectClass("myCustomObjClass").isPlaceHolder()).isFalse();
    }

    @Test
    public final void schemaBuilderAddAttributeContainingDescriptionWithCoreSchema() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder();
        scBuild.addObjectClass("( temporary-fake-oc-id NAME 'myCustomObjClass' SUP top AUXILIARY MAY myCustomAttribute )", false);
        scBuild.addAttributeType("( temporary-fake-attr-id NAME 'myCustomAttribute' DESC 'A short description' EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 USAGE userApplications )", false);
        scBuild.addSchema(Schema.getCoreSchema(), false);
        Schema schema = scBuild.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Object)schema.getAttributeType("myCustomAttribute")).isNotNull();
        Assertions.assertThat((String)schema.getAttributeType("myCustomAttribute").getNameOrOID()).isEqualTo((Object)"myCustomAttribute");
        Assertions.assertThat((String)schema.getAttributeType("myCustomAttribute").getSyntax().toString()).isEqualTo((Object)"( 1.3.6.1.4.1.1466.115.121.1.15 DESC 'Directory String' X-ORIGIN 'RFC 4512' )");
        Assertions.assertThat((String)schema.getAttributeType("myCustomAttribute").getUsage().toString()).isEqualTo((Object)"userApplications");
        Assertions.assertThat((String)schema.getAttributeType("myCustomAttribute").getDescription()).isEqualTo((Object)"A short description");
        Assertions.assertThat((boolean)schema.getObjectClass("myCustomObjClass").isPlaceHolder()).isFalse();
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public final void schemaBuilderAddAttributeDoesntAllowWrongUsage() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder();
        scBuild.addObjectClass("( temporary-fake-oc-id NAME 'myCustomObjClass' SUP top AUXILIARY MAY myCustomAttribute )", false);
        scBuild.addAttributeType("( temporary-fake-attr-id NAME 'myCustomAttribute' DESC 'A short description' EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 USAGE wrongUsage )", false);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void schemaBuilderAddAttributeTypeDoesntAllowNull() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder();
        scBuild.addObjectClass("( temporary-fake-oc-id NAME 'myCustomObjClass' SUP top AUXILIARY MAY myCustomAttribute )", false);
        scBuild.addAttributeType((String)null, false);
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public final void schemaBuilderAddAttributeTypeDoesntAllowEmptyString() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder();
        scBuild.addObjectClass("( temporary-fake-oc-id NAME 'myCustomObjClass' SUP top AUXILIARY MAY myCustomAttribute )", false);
        scBuild.addAttributeType(" ", false);
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public final void schemaBuilderAddAttributeDoesntAllowLeftParenthesisMising() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getDefaultSchema());
        scBuild.addObjectClass("( temporary-fake-oc-id NAME 'myCustomObjClass' SUP top AUXILIARY MAY myCustomAttribute )", false);
        scBuild.addAttributeType(" temporary-fake-attr-id NAME 'myCustomAttribute' DESC 'A short description' EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 USAGE userApplications )", false);
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public final void schemaBuilderAddAttributeDoesntAllowRightParenthesisMising() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getDefaultSchema());
        scBuild.addObjectClass("( temporary-fake-oc-id NAME 'myCustomObjClass' SUP top AUXILIARY MAY myCustomAttribute )", false);
        scBuild.addAttributeType(" ( temporary-fake-attr-id NAME 'myCustomAttribute' DESC 'A short description' EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 USAGE userApplications ", false);
    }

    @Test
    public final void schemaBuilderCompareAddAttributeTypesSucceed() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getDefaultSchema());
        scBuild.addObjectClass("( temporary-fake-oc-id NAME 'myCustomObjClass' SUP top AUXILIARY MAY myCustomAttribute )", false);
        scBuild.addAttributeType("( temporary-fake-attr-id NAME 'myCustomAttribute' DESC 'A short description' EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 USAGE userApplications )", false);
        Schema sc = scBuild.toSchema();
        Assertions.assertThat((String)sc.getAttributeType("myCustomAttribute").getDescription()).isEqualTo((Object)"A short description");
        Assertions.assertThat((String)sc.getAttributeType("myCustomAttribute").getSyntax().toString()).isEqualTo((Object)"( 1.3.6.1.4.1.1466.115.121.1.15 DESC 'Directory String' X-ORIGIN 'RFC 4512' )");
        SchemaBuilder scBuild2 = new SchemaBuilder(Schema.getDefaultSchema());
        scBuild2.addObjectClass("( temporary-fake-oc-id NAME 'myCustomObjClass' SUP top AUXILIARY MAY myCustomAttribute )", false);
        scBuild2.buildAttributeType("temporary-fake-attr-id").names(new String[]{"myCustomAttribute"}).description("The new attribute type").equalityMatchingRule("caseIgnoreOrderingMatch").orderingMatchingRule("caseIgnoreOrderingMatch").substringMatchingRule("caseIgnoreSubstringsMatch").syntax("1.3.6.1.4.1.1466.115.121.1.15").usage(AttributeUsage.USER_APPLICATIONS).addToSchemaOverwrite();
        Schema sc2 = scBuild2.toSchema();
        Assertions.assertThat((String)sc2.getAttributeType("myCustomAttribute").getDescription()).isEqualTo((Object)"The new attribute type");
        Assertions.assertThat((String)sc2.getAttributeType("myCustomAttribute").getSyntax().toString()).isEqualTo((Object)"( 1.3.6.1.4.1.1466.115.121.1.15 DESC 'Directory String' X-ORIGIN 'RFC 4512' )");
        Assertions.assertThat((Object)sc2.getAttributeType("myCustomAttribute")).isEqualTo((Object)sc.getAttributeType("myCustomAttribute"));
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public final void schemaBuilderAddObjectClassDoesntAllowMalformedObjectClass() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder();
        scBuild.addObjectClass(" temporary-fake-oc-id NAME 'myCustomObjClass' SUP top AUXILIARY MAY myCustomAttribute )", false);
        scBuild.addAttributeType("( temporary-fake-attr-id NAME 'myCustomAttribute' DESC 'A short description' EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 USAGE userApplications )", false);
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public final void schemaBuilderAddObjectClassDoesntAllowMalformedObjectClassIllegalToken() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder();
        scBuild.addObjectClass("( temporary-fake-oc-id NAME 'myCustomObjClass' SUP top AUXI MAY myCustomAttribute )", false);
        scBuild.addAttributeType("( temporary-fake-attr-id NAME 'myCustomAttribute' DESC 'A short description' EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 USAGE userApplications )", false);
    }

    @Test
    public final void schemaBuilderAddObjectClass() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getDefaultSchema());
        scBuild.buildObjectClass("2.5.6.14").names(new String[]{"device"}).description("New description for the new existing Object Class").superiorObjectClasses(new String[]{"top"}).requiredAttributes(new String[]{"cn"}).optionalAttributes(new String[]{"seeAlso", "ou", "l", "description"}).extraProperties("X-ORIGIN", new String[]{"RFC 4519"}).addToSchemaOverwrite();
        Schema sc = scBuild.toSchema();
        Assertions.assertThat((Collection)sc.getWarnings()).isEmpty();
        Assertions.assertThat((String)sc.getObjectClass("device").getOID()).isEqualTo((Object)"2.5.6.14");
        Assertions.assertThat((String)sc.getObjectClass("device").getDescription()).isEqualTo((Object)"New description for the new existing Object Class");
    }

    @Test(expectedExceptions={ConflictingSchemaElementException.class})
    public final void schemaBuilderDoesntAllowConflictingAttributesOverwriteFalse() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder();
        scBuild.addAttributeType("( temporary-fake-attr-id NAME 'myCustomAttribute' DESC 'A short description' EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 USAGE userApplications )", false);
        scBuild.addAttributeType("( temporary-fake-attr-id NAME 'myCustomAttribute' DESC 'A short description' EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 USAGE userApplications )", false);
    }

    @Test
    public final void schemaBuilderWithAttributeUsageDifferentFromSuperior() {
        SchemaBuilder scBuild = new SchemaBuilder();
        scBuild.addAttributeType("(1.2.8.5 NAME 'testtype' DESC 'full type' OBSOLETE SUP cn  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE NO-USER-MODIFICATION USAGE directoryOperation )", true);
        scBuild.addSchema(Schema.getCoreSchema(), false);
        Schema schema = scBuild.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).hasSize(1);
        Assertions.assertThat((String)schema.getWarnings().toString()).contains("attribute usage directoryOperation is not the same");
    }

    @Test
    public final void schemaBuilderAllowsConflictingAttributesOverwriteTrue() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder();
        scBuild.addAttributeType("( temporary-fake-attr-id NAME 'myCustomAttribute' DESC 'A short description' EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 USAGE userApplications )", true);
        scBuild.addAttributeType("( temporary-fake-attr-id NAME 'myCustomAttribute' DESC 'Another description' EQUALITY objectIdentifierFirstComponentMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.37 USAGE directoryOperation )", true);
        scBuild.addSchema(Schema.getCoreSchema(), false);
        Schema schema = scBuild.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Object)schema.getAttributeType("myCustomAttribute")).isNotNull();
        Assertions.assertThat((String)schema.getAttributeType("myCustomAttribute").getOID()).isEqualTo((Object)"temporary-fake-attr-id");
        Assertions.assertThat((String)schema.getAttributeType("myCustomAttribute").getSyntax().toString()).isEqualTo((Object)"( 1.3.6.1.4.1.1466.115.121.1.37 DESC 'Object Class Description' X-ORIGIN 'RFC 4512' )");
        Assertions.assertThat((String)schema.getAttributeType("myCustomAttribute").getUsage().toString()).isEqualTo((Object)"directoryOperation");
    }

    @Test(expectedExceptions={ConflictingSchemaElementException.class})
    public final void schemaBuilderDoesntAllowConflictingDITOverwriteFalse() throws Exception {
        new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testditstructureruleconstraintssupoc-oid NAME 'testDITStructureRuleConstraintsSupOC' SUP top STRUCTURAL MUST ou X-ORIGIN 'SchemaBackendTestCase')", false).addObjectClass("( testditstructureruleconstraintssuboc-oid NAME 'testDITStructureRuleConstraintsSubOC' SUP top STRUCTURAL MUST cn X-ORIGIN 'SchemaBackendTestCase')", false).addNameForm("( testditstructureruleconstraintsupsnf-oid NAME 'testDITStructureRuleConstraintsSupNF' OC testDITStructureRuleConstraintsSupOC MUST ou X-ORIGIN 'SchemaBackendTestCase' )", false).addNameForm("( testditstructureruleconstraintsubsnf-oid NAME 'testDITStructureRuleConstraintsSubNF' OC testDITStructureRuleConstraintsSubOC MUST cn X-ORIGIN 'SchemaBackendTestCase' )", false).addDITStructureRule("( 999014 NAME 'testDITStructureRuleConstraintsSup' FORM testDITStructureRuleConstraintsSupNF X-ORIGIN 'SchemaBackendTestCase' )", false).addDITStructureRule("( 999014 NAME 'testDITStructureRuleConstraintsSup' DESC 'A short description' FORM testDITStructureRuleConstraintsSupNF X-ORIGIN 'SchemaBackendTestCase' )", false).toSchema();
    }

    @Test
    public final void schemaBuilderAllowsConflictingDITStructureRuleOverwriteTrue() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testditstructureruleconstraintssupoc-oid NAME 'testDITStructureRuleConstraintsSupOC' SUP top STRUCTURAL MUST ou X-ORIGIN 'SchemaBackendTestCase')", false).addObjectClass("( testditstructureruleconstraintssuboc-oid NAME 'testDITStructureRuleConstraintsSubOC' SUP top STRUCTURAL MUST cn X-ORIGIN 'SchemaBackendTestCase')", false).addNameForm("( testditstructureruleconstraintsupsnf-oid NAME 'testDITStructureRuleConstraintsSupNF' OC testDITStructureRuleConstraintsSupOC MUST ou X-ORIGIN 'SchemaBackendTestCase' )", false).addNameForm("( testditstructureruleconstraintsubsnf-oid NAME 'testDITStructureRuleConstraintsSubNF' OC testDITStructureRuleConstraintsSubOC MUST cn X-ORIGIN 'SchemaBackendTestCase' )", false).addDITStructureRule("( 999014 NAME 'testDITStructureRuleConstraintsSup' FORM testDITStructureRuleConstraintsSupNF X-ORIGIN 'SchemaBackendTestCase' )", true).addDITStructureRule("( 999014 NAME 'testDITStructureRuleConstraintsSup' DESC 'A short description' FORM testDITStructureRuleConstraintsSupNF X-ORIGIN 'SchemaBackendTestCase' )", true).toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((String)schema.getDITStructureRule(999014).getDescription()).isEqualTo((Object)"A short description");
        Assertions.assertThat((String)schema.getDITStructureRule(999014).getNameOrRuleID()).isEqualTo((Object)"testDITStructureRuleConstraintsSup");
    }

    @Test
    public final void schemaBuilderAddDITContentRuleBuilder() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).addObjectClass("( 2.16.840.1.113730.3.2.2 NAME 'myCustomObjClass' SUP top)", false).addDITContentRule("( 2.16.840.1.113730.3.2.2 NAME 'inetOPerson' DESC 'inetOrgPerson is defined in RFC2798')", true).toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Object)schema.getDITContentRule("inetOPerson")).isNotNull();
        Assertions.assertThat((String)schema.getDITContentRule("inetOPerson").getNameOrOID()).isEqualTo((Object)"inetOPerson");
        Assertions.assertThat((String)schema.getDITContentRule("inetOPerson").getDescription()).isEqualTo((Object)"inetOrgPerson is defined in RFC2798");
    }

    @Test(expectedExceptions={ConflictingSchemaElementException.class})
    public final void schemaBuilderDoesntAllowConflictingDITContentRuleOverwriteFalse() throws Exception {
        new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testdontallowattributeprohibitedbydcroc-oid NAME 'testDontAllowAttributeProhibitedByDCROC' SUP top STRUCTURAL MUST cn MAY description X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addDITContentRule("( testdontallowattributeprohibitedbydcroc-oid NAME 'testDontAllowAttributeProhibitedByDCR' NOT description X-ORIGIN 'EntrySchemaCheckingTestCase2' )", false).addDITContentRule("( testdontallowattributeprohibitedbydcroc-oid NAME 'testDontAllowAttributeProhibitedByDCR' DESC 'Ensure attributes prohibited' NOT description X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
    }

    @Test
    public final void schemaBuilderAllowsConflictingDITContentRuleOverwriteTrue() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testdontallowattributeprohibitedbydcroc-oid NAME 'testDontAllowAttributeProhibitedByDCROC' SUP top STRUCTURAL MUST cn MAY description X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addDITContentRule("( testdontallowattributeprohibitedbydcroc-oid NAME 'testDontAllowAttributeProhibitedByDCR' NOT description X-ORIGIN 'EntrySchemaCheckingTestCase2' )", true).addDITContentRule("( testdontallowattributeprohibitedbydcroc-oid NAME 'testDontAllowAttributeProhibitedByDCR' DESC 'Ensure attributes prohibited' NOT description X-ORIGIN 'EntrySchemaCheckingTestCase' )", true).toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Object)schema.getDITContentRule("testDontAllowAttributeProhibitedByDCR")).isNotNull();
        Assertions.assertThat((String)schema.getDITContentRule("testDontAllowAttributeProhibitedByDCR").getDescription()).isEqualTo((Object)"Ensure attributes prohibited");
        Assertions.assertThat((String)schema.getDITContentRule("testDontAllowAttributeProhibitedByDCR").getNameOrOID()).isEqualTo((Object)"testDontAllowAttributeProhibitedByDCR");
    }

    @Test(expectedExceptions={ConflictingSchemaElementException.class})
    public final void schemaBuilderDoesntAllowConflictingMatchingRuleOverwriteFalse() throws Exception {
        new SchemaBuilder(Schema.getDefaultSchema()).addMatchingRule("( 2.5.13.16 NAME 'bitStringMatche' SYNTAX 1.3.6.1.4.1.1466.115.121.1.7 )", false).addMatchingRule("( 2.5.13.16 NAME 'bitStringMatch' SYNTAX 1.3.6.1.4.1.1466.115.121.1.6 )", false).toSchema();
    }

    @Test
    public final void schemaBuilderAllowsConflictingMatchingRuleOverwriteTrue() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addMatchingRule("( 2.5.13.16 NAME 'bitStringMatche' SYNTAX 1.3.6.1.4.1.1466.115.121.1.7 )", true).addMatchingRule("( 2.5.13.16 NAME 'bitStringMatch' SYNTAX 1.3.6.1.4.1.1466.115.121.1.6 )", true).toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Object)schema.getMatchingRule("bitStringMatch")).isNotNull();
        Assertions.assertThat((String)schema.getMatchingRule("bitStringMatch").getOID()).isEqualTo((Object)"2.5.13.16");
        Assertions.assertThat((String)schema.getMatchingRule("bitStringMatch").getSyntax().toString()).isEqualTo((Object)"( 1.3.6.1.4.1.1466.115.121.1.6 DESC 'Bit String' X-ORIGIN 'RFC 4512' )");
    }

    @Test(expectedExceptions={ConflictingSchemaElementException.class})
    public final void schemaBuilderDoesntAllowConflictingMatchingRuleUseOverwriteFalse() throws Exception {
        new SchemaBuilder(Schema.getDefaultSchema()).addMatchingRuleUse("( 2.5.13.16 APPLIES ( givenName $ name ) )", false).addMatchingRuleUse("( 2.5.13.16 APPLIES ( givenName $ surname ) )", false).toSchema();
    }

    @Test
    public final void schemaBuilderAllowsConflictingMatchingRuleUseOverwriteTrue() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addMatchingRuleUse("( 2.5.13.16 NAME 'bitStringMatch' APPLIES ( givenName $ name ) )", true).addMatchingRuleUse("( 2.5.13.16 NAME 'bitStringMatch' APPLIES ( givenName $ surname ) )", true).toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Object)schema.getMatchingRuleUse("bitStringMatch")).isNotNull();
        Assertions.assertThat((int)schema.getMatchingRuleUses().size()).isEqualTo(1);
        for (MatchingRuleUse o : schema.getMatchingRuleUses()) {
            Assertions.assertThat((String)o.getNameOrOID()).isEqualTo((Object)"bitStringMatch");
            Assertions.assertThat((String)o.getMatchingRuleOID()).isEqualTo((Object)"2.5.13.16");
            Assertions.assertThat((String)o.getMatchingRule().toString()).isEqualTo((Object)"( 2.5.13.16 NAME 'bitStringMatch' SYNTAX 1.3.6.1.4.1.1466.115.121.1.6 X-ORIGIN 'RFC 4512' )");
        }
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
    }

    @Test(expectedExceptions={ConflictingSchemaElementException.class})
    public final void schemaBuilderDoesntAllowConflictingNameFormOverwriteFalse() throws Exception {
        new SchemaBuilder(Schema.getDefaultSchema()).addNameForm("( testviolatessinglevaluednameform-oid NAME 'testViolatesSingleValuedNameForm' OC testViolatesSingleValuedNameFormOC MUST cn X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).addNameForm("( testviolatessinglevaluednameform-oid NAME 'testViolatesSingleValuedNameForm' OC testViolatesSingleValuedNameFormOC MUST cn X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
    }

    @Test
    public final void schemaBuilderAllowsConflictingNameFormOverwriteTrue() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testviolatessinglevaluednameformoc-oid NAME 'testViolatesSingleValuedNameFormOC' SUP top STRUCTURAL MUST cn MAY description X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addNameForm("( testviolatessinglevaluednameform-oid NAME 'testViolatesSingleValuedNameForm' OC testViolatesSingleValuedNameFormOC MUST sn X-ORIGIN 'EntrySchemaCheckingTestCase' )", true).addNameForm("( testviolatessinglevaluednameform-oid NAME 'testViolatesSingleValuedNameForm' OC testViolatesSingleValuedNameFormOC MUST cn X-ORIGIN 'EntrySchemaCheckingTestCase' )", true).toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Object)schema.getNameForm("testViolatesSingleValuedNameForm")).isNotNull();
        for (NameForm o : schema.getNameForms()) {
            Assertions.assertThat((String)o.getNameOrOID()).isEqualTo((Object)"testViolatesSingleValuedNameForm");
            Assertions.assertThat((String)o.getOID()).isEqualTo((Object)"testviolatessinglevaluednameform-oid");
            Assertions.assertThat((String)o.getStructuralClass().getOID()).isEqualTo((Object)"testviolatessinglevaluednameformoc-oid");
        }
    }

    @Test(expectedExceptions={UnknownSchemaElementException.class})
    public final void schemaBuilderRemoveAttributeType() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getDefaultSchema());
        scBuild.addObjectClass("( temporary-fake-oc-id NAME 'myCustomObjClass' SUP top AUXILIARY MAY myCustomAttribute )", false);
        scBuild.addAttributeType("( temporary-fake-attr-id NAME 'myCustomAttribute' DESC 'A short description' EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 USAGE userApplications )", false);
        boolean isRemoved = scBuild.removeAttributeType("myCustomAttribute");
        Assertions.assertThat((boolean)isRemoved).isTrue();
        Schema schema = scBuild.toSchema();
        Assertions.assertThat((Object)schema.getAttributeType("myCustomAttribute")).isNull();
    }

    @Test
    public final void schemaBuilderRemoveInexistantAttributeType() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getCoreSchema());
        boolean isRemoved = scBuild.removeAttributeType("wrongName");
        Assertions.assertThat((boolean)isRemoved).isFalse();
    }

    @Test
    public final void schemaBuilderRemoveInexistantSyntax() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getCoreSchema());
        boolean isRemoved = scBuild.removeSyntax("1.3.6.1.4.1.14aa");
        Assertions.assertThat((boolean)isRemoved).isFalse();
    }

    @Test(expectedExceptions={UnknownSchemaElementException.class})
    public final void schemaBuilderRemoveSyntax() throws Exception {
        Assertions.assertThat((Object)Schema.getCoreSchema().getSyntax("1.3.6.1.4.1.1466.115.121.1.15")).isNotNull();
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getDefaultSchema());
        boolean isRemoved = scBuild.removeSyntax("1.3.6.1.4.1.1466.115.121.1.15");
        Assertions.assertThat((boolean)isRemoved).isTrue();
        Schema sc = scBuild.toSchema();
        Assertions.assertThat((Object)sc.getSyntax("1.3.6.1.4.1.1466.115.121.1.15")).isNull();
    }

    @Test
    public final void schemaBuilderRemoveDitContentRule() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getCoreSchema());
        scBuild.addObjectClass("( 2.16.840.1.113730.3.2.2 NAME 'myCustomObjClass' SUP top)", false);
        scBuild.addDITContentRule("( 2.16.840.1.113730.3.2.2 NAME 'inetOPerson' DESC 'inetOrgPerson is defined in RFC2798')", true);
        boolean isRemoved = scBuild.removeDITContentRule("inetOPerson");
        Assertions.assertThat((boolean)isRemoved).isTrue();
        Schema sc = scBuild.toSchema();
        for (DITContentRule dit : sc.getDITContentRules()) {
            Assertions.assertThat((String)dit.getNameOrOID()).isNotEqualTo((Object)"inetOPerson");
        }
    }

    @Test
    public final void schemaBuilderRemoveInexistantDitContentRule() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getCoreSchema());
        boolean isRemoved = scBuild.removeDITContentRule("badDITContentRule");
        Assertions.assertThat((boolean)isRemoved).isFalse();
    }

    @Test(expectedExceptions={UnknownSchemaElementException.class})
    public final void schemaBuilderRemoveDitStructureRule() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getCoreSchema());
        scBuild.addObjectClass("( testditstructureruleconstraintssupoc-oid NAME 'testDITStructureRuleConstraintsSupOC' SUP top STRUCTURAL MUST ou X-ORIGIN 'SchemaBackendTestCase')", false).addObjectClass("( testditstructureruleconstraintssuboc-oid NAME 'testDITStructureRuleConstraintsSubOC' SUP top STRUCTURAL MUST cn X-ORIGIN 'SchemaBackendTestCase')", false).addNameForm("( testditstructureruleconstraintsupsnf-oid NAME 'testDITStructureRuleConstraintsSupNF' OC testDITStructureRuleConstraintsSupOC MUST ou X-ORIGIN 'SchemaBackendTestCase' )", false).addNameForm("( testditstructureruleconstraintsubsnf-oid NAME 'testDITStructureRuleConstraintsSubNF' OC testDITStructureRuleConstraintsSubOC MUST cn X-ORIGIN 'SchemaBackendTestCase' )", false).addDITStructureRule("( 999014 NAME 'testDITStructureRuleConstraintsSup' FORM testDITStructureRuleConstraintsSupNF X-ORIGIN 'SchemaBackendTestCase' )", true);
        boolean isRemoved = scBuild.removeDITStructureRule(999014);
        Assertions.assertThat((boolean)isRemoved).isTrue();
        Schema sc = scBuild.toSchema();
        Assertions.assertThat((Object)sc.getDITStructureRule(999014)).isNull();
    }

    @Test
    public final void schemaBuilderRemoveInexistantDitStructureRule() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getCoreSchema());
        boolean isRemoved = scBuild.removeDITStructureRule(999014);
        Assertions.assertThat((boolean)isRemoved).isFalse();
    }

    @Test(expectedExceptions={UnknownSchemaElementException.class})
    public final void schemaBuilderRemoveMatchingRule() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder();
        scBuild.addMatchingRule("( 2.5.13.16 NAME 'bitStringMatch' SYNTAX 1.3.6.1.4.1.1466.115.121.1.6 )", false);
        boolean isRemoved = scBuild.removeMatchingRule("bitStringMatch");
        Assertions.assertThat((boolean)isRemoved).isTrue();
        Schema sc = scBuild.toSchema();
        Assertions.assertThat((Object)sc.getMatchingRule("bitStringMatch")).isNull();
    }

    @Test
    public final void schemaBuilderRemoveInexistantMatchingRule() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getCoreSchema());
        boolean isRemoved = scBuild.removeMatchingRule("bitStringMatchZ");
        Assertions.assertThat((boolean)isRemoved).isFalse();
    }

    @Test(expectedExceptions={UnknownSchemaElementException.class})
    public final void schemaBuilderRemoveMatchingRuleUSe() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder();
        scBuild.addMatchingRuleUse("( 2.5.13.16 NAME 'bitStringMatch' APPLIES ( givenName $ surname ) )", false);
        boolean isRemoved = scBuild.removeMatchingRuleUse("bitStringMatch");
        Assertions.assertThat((boolean)isRemoved).isTrue();
        Schema sc = scBuild.toSchema();
        Assertions.assertThat((Object)sc.getMatchingRuleUse("bitStringMatch")).isNull();
    }

    @Test
    public final void schemaBuilderRemoveInexistantMatchingRuleUse() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getCoreSchema());
        boolean isRemoved = scBuild.removeMatchingRuleUse("bitStringMatchZ");
        Assertions.assertThat((boolean)isRemoved).isFalse();
    }

    @Test(expectedExceptions={UnknownSchemaElementException.class})
    public final void schemaBuilderRemoveNameForm() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder();
        scBuild.addNameForm("( testviolatessinglevaluednameform-oid NAME 'testViolatesSingleValuedNameForm' OC testViolatesSingleValuedNameFormOC MUST cn X-ORIGIN 'EntrySchemaCheckingTestCase' )", false);
        boolean isRemoved = scBuild.removeNameForm("testViolatesSingleValuedNameForm");
        Assertions.assertThat((boolean)isRemoved).isTrue();
        Schema sc = scBuild.toSchema();
        Assertions.assertThat((Object)sc.getNameForm("testViolatesSingleValuedNameForm")).isNull();
    }

    @Test
    public final void schemaBuilderRemoveInexistantNameForm() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getCoreSchema());
        boolean isRemoved = scBuild.removeNameForm("bitStringMatchZ");
        Assertions.assertThat((boolean)isRemoved).isFalse();
    }

    @Test(expectedExceptions={UnknownSchemaElementException.class})
    public final void schemaBuilderRemoveObjectClass() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder();
        scBuild.addObjectClass("( 2.5.6.6 NAME 'person' SUP top STRUCTURAL MUST ( sn $ cn ) MAY ( userPassword $ telephoneNumber $ seeAlso $ description ) X-ORIGIN 'RFC 4519' )", false);
        boolean isRemoved = scBuild.removeObjectClass("person");
        Assertions.assertThat((boolean)isRemoved).isTrue();
        Schema sc = scBuild.toSchema();
        Assertions.assertThat((Object)sc.getObjectClass("person")).isNull();
    }

    @Test
    public final void schemaBuilderRemoveInexistantObjectClass() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getCoreSchema());
        boolean isRemoved = scBuild.removeObjectClass("bitStringMatchZ");
        Assertions.assertThat((boolean)isRemoved).isFalse();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void schemaBuilderAddSchemaForEntryDoesntAllowNull() throws Exception {
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getCoreSchema());
        scBuild.addSchemaForEntry(null, null, false);
    }

    @Test(expectedExceptions={EntryNotFoundException.class})
    public final void schemaBuilderAddSchemaForEntryDoesntContainSubschemaMockConnection() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getCoreSchema());
        String[] entry = new String[]{"dn: uid=scarter,ou=People,dc=example,dc=com", "objectClass: person", "objectClass: inetorgperson", "objectClass: organizationalperson", "objectClass: top", "postalAddress: Aaccf Amar$01251 Chestnut Street$Panama City, DE  50369", "postalCode: 50369", "uid: user.0"};
        Mockito.when((Object)connection.searchSingleEntry((SearchRequest)Mockito.any())).thenReturn((Object)Responses.newSearchResultEntry((String[])entry));
        scBuild.addSchemaForEntry(connection, DN.valueOf((String)"uid=scarter,ou=People,dc=example,dc=com"), false);
    }

    @Test
    public final void schemaBuilderAddSchemaForEntryMockConnection() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getCoreSchema());
        String[] entry = new String[]{"# Search result entry: uid=bjensen,ou=People,dc=example,dc=com", "dn: uid=bjensen,ou=People,dc=example,dc=com", "subschemaSubentry: cn=schema", "entryDN: uid=bjensen,ou=people,dc=example,dc=com", "entryUUID: fc252fd9-b982-3ed6-b42a-c76d2546312c"};
        Mockito.when((Object)connection.searchSingleEntry((SearchRequest)Mockito.any())).thenReturn((Object)Responses.newSearchResultEntry((String[])entry));
        scBuild.addSchemaForEntry(connection, DN.valueOf((String)"uid=bjensen,ou=People,dc=example,dc=com"), false);
        Schema sc = scBuild.toSchema();
        Assertions.assertThat((Collection)sc.getSyntaxes()).isNotNull();
        Assertions.assertThat((Collection)sc.getAttributeTypes()).isNotNull();
        Assertions.assertThat((Collection)sc.getAttributeTypes()).isNotEmpty();
        Assertions.assertThat((Collection)sc.getObjectClasses()).isNotNull();
        Assertions.assertThat((Collection)sc.getObjectClasses()).isNotEmpty();
        Assertions.assertThat((Collection)sc.getMatchingRuleUses()).isNotNull();
        Assertions.assertThat((Collection)sc.getMatchingRuleUses()).isEmpty();
        Assertions.assertThat((Collection)sc.getMatchingRules()).isNotNull();
        Assertions.assertThat((Collection)sc.getMatchingRules()).isNotEmpty();
        Assertions.assertThat((Collection)sc.getDITContentRules()).isNotNull();
        Assertions.assertThat((Collection)sc.getDITContentRules()).isEmpty();
        Assertions.assertThat((Collection)sc.getDITStuctureRules()).isNotNull();
        Assertions.assertThat((Collection)sc.getDITStuctureRules()).isEmpty();
        Assertions.assertThat((Collection)sc.getNameForms()).isNotNull();
        Assertions.assertThat((Collection)sc.getNameForms()).isEmpty();
        connection.close();
    }

    @Test
    public final void schemaBuilderAddSchemaForEntryAsyncMockConnection() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        SchemaBuilder scBuild = new SchemaBuilder(Schema.getCoreSchema());
        String[] entry = new String[]{"# Search result entry: uid=bjensen,ou=People,dc=example,dc=com", "dn: uid=bjensen,ou=People,dc=example,dc=com", "subschemaSubentry: cn=schema", "entryDN: uid=bjensen,ou=people,dc=example,dc=com", "entryUUID: fc252fd9-b982-3ed6-b42a-c76d2546312c"};
        LdapPromise result = LdapPromises.newSuccessfulLdapPromise((Object)Responses.newSearchResultEntry((String[])entry));
        Mockito.when((Object)connection.searchSingleEntryAsync((SearchRequest)Mockito.any())).thenReturn((Object)result);
        DN testDN = DN.valueOf((String)"uid=bjensen,ou=People,dc=example,dc=com");
        Schema sc = ((SchemaBuilder)scBuild.addSchemaForEntryAsync(connection, testDN, false).getOrThrow()).toSchema();
        Assertions.assertThat((Collection)sc.getSyntaxes()).isNotNull();
        Assertions.assertThat((Collection)sc.getAttributeTypes()).isNotNull();
        Assertions.assertThat((Collection)sc.getAttributeTypes()).isNotEmpty();
        Assertions.assertThat((Collection)sc.getObjectClasses()).isNotNull();
        Assertions.assertThat((Collection)sc.getObjectClasses()).isNotEmpty();
        Assertions.assertThat((Collection)sc.getMatchingRuleUses()).isNotNull();
        Assertions.assertThat((Collection)sc.getMatchingRuleUses()).isEmpty();
        Assertions.assertThat((Collection)sc.getMatchingRules()).isNotNull();
        Assertions.assertThat((Collection)sc.getMatchingRules()).isNotEmpty();
        Assertions.assertThat((Collection)sc.getDITContentRules()).isNotNull();
        Assertions.assertThat((Collection)sc.getDITContentRules()).isEmpty();
        Assertions.assertThat((Collection)sc.getDITStuctureRules()).isNotNull();
        Assertions.assertThat((Collection)sc.getDITStuctureRules()).isEmpty();
        Assertions.assertThat((Collection)sc.getNameForms()).isNotNull();
        Assertions.assertThat((Collection)sc.getNameForms()).isEmpty();
        connection.close();
    }

    @Test
    public void defaultSyntax() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).toSchema().asNonStrictSchema();
        Assertions.assertThat((Object)schema.getDefaultSyntax()).isEqualTo((Object)CoreSchema.getOctetStringSyntax());
        Assertions.assertThat((Object)schema.getAttributeType("dummy").getSyntax()).isEqualTo((Object)CoreSchema.getOctetStringSyntax());
    }

    @Test
    public void overrideDefaultSyntax() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).setOption(SchemaOptions.DEFAULT_SYNTAX_OID, (Object)CoreSchema.getDirectoryStringSyntax().getOID()).toSchema().asNonStrictSchema();
        Assertions.assertThat((Object)schema.getDefaultSyntax()).isEqualTo((Object)CoreSchema.getDirectoryStringSyntax());
        Assertions.assertThat((Object)schema.getAttributeType("dummy").getSyntax()).isEqualTo((Object)CoreSchema.getDirectoryStringSyntax());
    }

    @Test
    public void defaultMatchingRule() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).toSchema().asNonStrictSchema();
        Assertions.assertThat((Object)schema.getDefaultMatchingRule()).isEqualTo((Object)CoreSchema.getOctetStringMatchingRule());
        Assertions.assertThat((Object)schema.getAttributeType("dummy").getEqualityMatchingRule()).isEqualTo((Object)CoreSchema.getOctetStringMatchingRule());
    }

    @Test
    public void overrideMatchingRule() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).setOption(SchemaOptions.DEFAULT_MATCHING_RULE_OID, (Object)CoreSchema.getCaseIgnoreMatchingRule().getOID()).toSchema().asNonStrictSchema();
        Assertions.assertThat((Object)schema.getDefaultMatchingRule()).isEqualTo((Object)CoreSchema.getCaseIgnoreMatchingRule());
        Assertions.assertThat((Object)schema.getAttributeType("dummy").getEqualityMatchingRule()).isEqualTo((Object)CoreSchema.getCaseIgnoreMatchingRule());
    }

    @Test
    public void defaultSyntaxDefinedInSchema() {
        Schema schema = new SchemaBuilder().addSyntax("( 9.9.9 DESC 'Test Syntax' )", false).addSyntax(CoreSchema.getOctetStringSyntax().toString(), false).toSchema();
        Assertions.assertThat((boolean)schema.getSyntax("9.9.9").valueIsAcceptable((ByteSequence)ByteString.valueOfUtf8((CharSequence)"test"), null)).isTrue();
    }

    @Test
    public void defaultMatchingRuleDefinedInSchema() throws DecodeException {
        Schema schema = new SchemaBuilder().addSyntax(CoreSchema.getOctetStringSyntax().toString(), false).addMatchingRule("( 9.9.9 NAME 'testRule' SYNTAX 1.3.6.1.4.1.1466.115.121.1.40 )", false).addMatchingRule(CoreSchema.getOctetStringMatchingRule().toString(), false).toSchema();
        Assertions.assertThat((Object)schema.getMatchingRule("9.9.9").normalizeAttributeValue((ByteSequence)ByteString.valueOfUtf8((CharSequence)"test"))).isEqualTo((Object)ByteString.valueOfUtf8((CharSequence)"test"));
    }

    @Test
    public void enumSyntaxAddThenRemove() {
        Schema coreSchema = Schema.getCoreSchema();
        Schema schemaWithEnum = new SchemaBuilder(coreSchema).addSyntax("( 3.3.3  DESC 'Day Of The Week'  X-ENUM  ( 'monday' 'tuesday'   'wednesday'  'thursday'  'friday'  'saturday' 'sunday') )", false).toSchema();
        Assertions.assertThat((Collection)schemaWithEnum.getWarnings()).isEmpty();
        ((CollectionAssert)Assertions.assertThat((Collection)schemaWithEnum.getMatchingRules()).as("Expected an enum ordering matching rule to be added for the enum syntax")).hasSize(coreSchema.getMatchingRules().size() + 1);
        SchemaBuilder builder = new SchemaBuilder(schemaWithEnum);
        Assertions.assertThat((boolean)builder.removeSyntax("3.3.3")).isTrue();
        Schema schemaNoEnum = builder.toSchema();
        Assertions.assertThat((Collection)schemaNoEnum.getWarnings()).isEmpty();
        ((CollectionAssert)Assertions.assertThat((Collection)schemaNoEnum.getMatchingRules()).as("Expected the enum ordering matching rule to be removed at the same time as the enum syntax")).hasSize(coreSchema.getMatchingRules().size());
    }

    @Test
    public void attributeTypesUseNewlyBuiltSyntaxes() throws Exception {
        Schema coreSchema = Schema.getCoreSchema();
        Schema schema = new SchemaBuilder(coreSchema).addAttributeType("( 1.2.3.4.5.7 NAME 'associateoid'  EQUALITY 2.5.13.2 ORDERING 2.5.13.3 SUBSTR 2.5.13.4 SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 USAGE userApplications X-APPROX '1.3.6.1.4.1.26027.1.4.1' )", false).toSchema();
        Syntax dnSyntax = schema.getAttributeType("distinguishedName").getSyntax();
        Assertions.assertThat((Object)dnSyntax).isSameAs((Object)schema.getSyntax("1.3.6.1.4.1.1466.115.121.1.12"));
        LocalizableMessageBuilder invalidReason = new LocalizableMessageBuilder();
        boolean isValid = dnSyntax.valueIsAcceptable((ByteSequence)ByteString.valueOfUtf8((CharSequence)"associateoid=test"), invalidReason);
        ((BooleanAssert)Assertions.assertThat((boolean)isValid).as("Value should have been valid, but it is not: " + invalidReason.toString())).isTrue();
    }

    @DataProvider
    private Object[][] schemasWithEnumerationSyntaxes() {
        Schema coreSchema = Schema.getCoreSchema();
        Schema usingAddEnumerationSyntax = new SchemaBuilder("usingAddEnumerationSyntax").addSchema(coreSchema, true).addEnumerationSyntax("3.3.3", "Primary colors", true, new String[]{"red", "green", "blue"}).toSchema();
        Schema usingAddSyntaxString = new SchemaBuilder("usingAddSyntaxString").addSchema(coreSchema, true).addSyntax("( 3.3.3  DESC 'Primary colors' X-ENUM ( 'red' 'green' 'blue' ))", true).toSchema();
        Schema usingBuildSyntaxCopy = new SchemaBuilder("usingBuildSyntaxCopy").addSchema(coreSchema, true).buildSyntax(usingAddEnumerationSyntax.getSyntax("3.3.3")).addToSchema().toSchema();
        Schema usingBuildSyntaxIncremental = new SchemaBuilder("usingBuildSyntaxIncremental").addSchema(coreSchema, true).buildSyntax("3.3.3").description("Primary colors").extraProperties("X-ENUM", new String[]{"red", "green", "blue"}).addToSchema().toSchema();
        Schema usingCopyOfSchema = new SchemaBuilder("usingCopyOfSchema").addSchema(usingAddEnumerationSyntax, true).toSchema();
        return new Object[][]{{usingAddEnumerationSyntax}, {usingAddSyntaxString}, {usingBuildSyntaxCopy}, {usingBuildSyntaxIncremental}, {usingCopyOfSchema}};
    }

    @Test(dataProvider="schemasWithEnumerationSyntaxes")
    public void enumerationSyntaxesCanBeCreatedUsingDifferentApproaches(Schema schema) {
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        ((CollectionAssert)Assertions.assertThat((Collection)schema.getMatchingRules()).as("Expected an enum ordering matching rule to be added for the enum syntax")).hasSize(Schema.getCoreSchema().getMatchingRules().size() + 1);
        LocalizableMessageBuilder msgBuilder = new LocalizableMessageBuilder();
        Syntax primaryColors = schema.getSyntax("3.3.3");
        Assertions.assertThat((boolean)primaryColors.valueIsAcceptable((ByteSequence)ByteString.valueOfUtf8((CharSequence)"red"), msgBuilder)).isTrue();
        Assertions.assertThat((boolean)primaryColors.valueIsAcceptable((ByteSequence)ByteString.valueOfUtf8((CharSequence)"yellow"), msgBuilder)).isFalse();
        MatchingRule matchingRule = schema.getMatchingRule("1.3.6.1.4.1.26027.1.4.8.3.3.3");
        Assertions.assertThat((Object)matchingRule).isNotNull();
        Assertions.assertThat((Object)matchingRule).isSameAs((Object)primaryColors.getOrderingMatchingRule());
    }

    @DataProvider
    private Object[][] schemasWithSubstitutionSyntaxes() {
        Schema coreSchema = Schema.getCoreSchema();
        Schema usingAddSubstitutionSyntax = new SchemaBuilder("usingAddSubstitutionSyntax").addSchema(coreSchema, true).addSubstitutionSyntax("3.3.3", "Long Integer", "1.3.6.1.4.1.1466.115.121.1.27", true).toSchema();
        Schema usingAddSyntaxString = new SchemaBuilder("usingAddSyntaxString").addSchema(coreSchema, true).addSyntax("( 3.3.3  DESC 'Long Integer' X-SUBST '1.3.6.1.4.1.1466.115.121.1.27' )", true).toSchema();
        Schema usingBuildSyntaxCopy = new SchemaBuilder("usingBuildSyntaxCopy").addSchema(coreSchema, true).buildSyntax(usingAddSubstitutionSyntax.getSyntax("3.3.3")).addToSchema().toSchema();
        Schema usingBuildSyntaxIncremental = new SchemaBuilder("usingBuildSyntaxIncremental").addSchema(coreSchema, true).buildSyntax("3.3.3").description("Long Integer").extraProperties("X-SUBST", new String[]{"1.3.6.1.4.1.1466.115.121.1.27"}).addToSchema().toSchema();
        Schema usingCopyOfSchema = new SchemaBuilder("usingCopyOfSchema").addSchema(usingAddSubstitutionSyntax, true).toSchema();
        return new Object[][]{{usingAddSubstitutionSyntax}, {usingAddSyntaxString}, {usingBuildSyntaxCopy}, {usingBuildSyntaxIncremental}, {usingCopyOfSchema}};
    }

    @Test(dataProvider="schemasWithSubstitutionSyntaxes")
    public void substitutionSyntaxesCanBeCreatedUsingDifferentApproaches(Schema schema) {
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        LocalizableMessageBuilder msgBuilder = new LocalizableMessageBuilder();
        Syntax longInteger = schema.getSyntax("3.3.3");
        Assertions.assertThat((boolean)longInteger.valueIsAcceptable((ByteSequence)ByteString.valueOfUtf8((CharSequence)"12345"), msgBuilder)).isTrue();
        Assertions.assertThat((boolean)longInteger.valueIsAcceptable((ByteSequence)ByteString.valueOfUtf8((CharSequence)"NaN"), msgBuilder)).isFalse();
        MatchingRule matchingRule = schema.getMatchingRule("integerOrderingMatch");
        Assertions.assertThat((Object)matchingRule).isNotNull();
        Assertions.assertThat((Object)matchingRule).isSameAs((Object)longInteger.getOrderingMatchingRule());
    }

    @DataProvider
    private Object[][] schemasWithPatternSyntaxes() {
        Schema coreSchema = Schema.getCoreSchema();
        Schema usingAddPatternSyntax = new SchemaBuilder("usingAddSubstitutionSyntax").addSchema(coreSchema, true).addPatternSyntax("3.3.3", "Host and Port", Pattern.compile("[^:]+:\\d+"), true).toSchema();
        Schema usingAddSyntaxString = new SchemaBuilder("usingAddSyntaxString").addSchema(coreSchema, true).addSyntax("( 3.3.3  DESC 'Host and Port' X-PATTERN '[^:]+:\\d+' )", true).toSchema();
        Schema usingBuildSyntaxCopy = new SchemaBuilder("usingBuildSyntaxCopy").addSchema(coreSchema, true).buildSyntax(usingAddPatternSyntax.getSyntax("3.3.3")).addToSchema().toSchema();
        Schema usingBuildSyntaxIncremental = new SchemaBuilder("usingBuildSyntaxIncremental").addSchema(coreSchema, true).buildSyntax("3.3.3").description("Host and Port").extraProperties("X-PATTERN", new String[]{"[^:]+:\\d+"}).addToSchema().toSchema();
        Schema usingCopyOfSchema = new SchemaBuilder("usingCopyOfSchema").addSchema(usingAddPatternSyntax, true).toSchema();
        return new Object[][]{{usingAddPatternSyntax}, {usingAddSyntaxString}, {usingBuildSyntaxCopy}, {usingBuildSyntaxIncremental}, {usingCopyOfSchema}};
    }

    @Test(dataProvider="schemasWithPatternSyntaxes")
    public void patternSyntaxesCanBeCreatedUsingDifferentApproaches(Schema schema) {
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        LocalizableMessageBuilder msgBuilder = new LocalizableMessageBuilder();
        Syntax longInteger = schema.getSyntax("3.3.3");
        Assertions.assertThat((boolean)longInteger.valueIsAcceptable((ByteSequence)ByteString.valueOfUtf8((CharSequence)"localhost:389"), msgBuilder)).isTrue();
        Assertions.assertThat((boolean)longInteger.valueIsAcceptable((ByteSequence)ByteString.valueOfUtf8((CharSequence)"bad"), msgBuilder)).isFalse();
        MatchingRule matchingRule = schema.getMatchingRule("caseIgnoreOrderingMatch");
        Assertions.assertThat((Object)matchingRule).isNotNull();
        Assertions.assertThat((Object)matchingRule).isSameAs((Object)longInteger.getOrderingMatchingRule());
    }
}

