/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Calendar;
import java.util.Date;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.GeneralizedTime;
import org.forgerock.opendj.ldap.schema.AbstractSubstringMatchingRuleImplTest;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleTest;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.forgerock.util.time.TimeService;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class RelativeTimeGreaterThanMatchingRuleTest
extends MatchingRuleTest {
    @Override
    @DataProvider(name="matchingRuleInvalidAttributeValues")
    public Object[][] createMatchingRuleInvalidAttributeValues() {
        return new Object[][]{{"1Z"}, {"201a0630Z"}, {"20141330Z"}, {"20140635Z"}, {"20140630351010Z"}, {"20140630108810Z"}, {"20140630101088Z"}};
    }

    @Override
    @DataProvider(name="matchingRuleInvalidAssertionValues")
    public Object[][] createMatchingRuleInvalidAssertionValues() {
        return new Object[][]{{" "}, {"bla"}, {"-30b"}, {"-30ms"}};
    }

    @Override
    @DataProvider(name="matchingrules")
    public Object[][] createMatchingRuleTest() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(TimeService.SYSTEM.now());
        Date nowDate = calendar.getTime();
        calendar.add(2, 1);
        Date oneMonthAheadDate = calendar.getTime();
        String nowGT = GeneralizedTime.valueOf((Date)nowDate).toString();
        String oneMonthAheadGT = GeneralizedTime.valueOf((Date)oneMonthAheadDate).toString();
        return new Object[][]{{oneMonthAheadGT, "1", ConditionResult.TRUE}, {oneMonthAheadGT, "+1s", ConditionResult.TRUE}, {oneMonthAheadGT, "+1h", ConditionResult.TRUE}, {oneMonthAheadGT, "+1m", ConditionResult.TRUE}, {nowGT, "-30d", ConditionResult.TRUE}, {nowGT, "-30w", ConditionResult.TRUE}, {nowGT, "-30m", ConditionResult.TRUE}, {nowGT, "-30s", ConditionResult.TRUE}, {oneMonthAheadGT, "6w", ConditionResult.FALSE}, {nowGT, "1d", ConditionResult.FALSE}, {nowGT, "10s", ConditionResult.FALSE}, {nowGT, "+1h", ConditionResult.FALSE}, {nowGT, "+1m", ConditionResult.FALSE}, {nowGT, "+1w", ConditionResult.FALSE}, {"19000101010203Z", "1d", ConditionResult.FALSE}};
    }

    @Override
    protected MatchingRule getRule() {
        return CoreSchema.getInstance().getMatchingRule("1.3.6.1.4.1.26027.1.4.5");
    }

    @Test
    public void testCreateIndexQuery() throws Exception {
        Assertion assertion = this.getRule().getAssertion((ByteSequence)ByteString.valueOfUtf8((CharSequence)"+5m"));
        String indexQuery = (String)assertion.createIndexQuery((IndexQueryFactory)new AbstractSubstringMatchingRuleImplTest.FakeIndexQueryFactory(AbstractSubstringMatchingRuleImplTest.newIndexingOptions(), false));
        Assertions.assertThat((String)indexQuery).startsWith("rangeMatch(generalizedTimeMatch, '").endsWith("' < value < '')");
    }
}

