/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.regex.Pattern;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxTestCase;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class RegexSyntaxTestCase
extends AbstractSyntaxTestCase {
    @Override
    @DataProvider(name="acceptableValues")
    public Object[][] createAcceptableValues() {
        return new Object[][]{{"invalid regex", false}, {"host:0.0.0", true}};
    }

    @Test
    public void testDecode() {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.addSyntax("( 1.1.1 DESC 'Host and Port in the format of HOST:PORT'  X-PATTERN '^[a-z-A-Z]+:[0-9.]+\\d$' )", true);
        builder.toSchema();
    }

    @Test
    public void testInvalidPattern() {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.addSyntax("( 1.1.1 DESC 'Host and Port in the format of HOST:PORT'  X-PATTERN '^[a-z-A-Z+:[0-@.]+\\d$' )", true);
        Assert.assertFalse((boolean)builder.toSchema().getWarnings().isEmpty());
    }

    @Override
    protected Syntax getRule() {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.addPatternSyntax("1.1.1", "Host and Port in the format of HOST:PORT", Pattern.compile("^[a-z-A-Z]+:[0-9.]+\\d$"), false);
        return builder.toSchema().getSyntax("1.1.1");
    }
}

