/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.schema.AbstractSubstringMatchingRuleImplTest;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleTest;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.forgerock.util.time.TimeService;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class PartialDateAndTimeMatchingRuleTestCase
extends MatchingRuleTest {
    @Override
    @DataProvider(name="matchingRuleInvalidAttributeValues")
    public Object[][] createMatchingRuleInvalidAttributeValues() {
        return new Object[][]{{"1Z"}, {"201a0630Z"}, {"20141330Z"}, {"20140635Z"}, {"20140630351010Z"}, {"20140630108810Z"}, {"20140630101080Z"}};
    }

    @Override
    @DataProvider(name="matchingRuleInvalidAssertionValues")
    public Object[][] createMatchingRuleInvalidAssertionValues() {
        return new Object[][]{{" "}, {"bla"}, {"-1Y03M11D12h48m32s"}, {"0Y03M11D12h48m32s"}, {"2014Y-1M11D12h48m32s"}, {"2014Y0M11D12h48m32s"}, {"2014Y13M11D12h48m32s"}, {"2014Y03M-1D12h48m32s"}, {"2014Y03M0D12h48m32s"}, {"2014Y13M32D12h48m32s"}, {"2014Y03M11D-1h48m32s"}, {"2014Y03M11D24h48m32s"}, {"2014Y03M11D12h-1m32s"}, {"2014Y03M11D12h60m32s"}, {"2014Y03M11D12h48m-1s"}, {"2014Y03M11D12h48m61s"}, {"1Y2014Y03M11D12h"}, {"2014Y1M03M11D12h"}, {"2014Y03M1D11D12h"}, {"2014Y03M11D1h12h"}, {"2014Y03M11D12h1m48m"}, {"2014Y03M11D12h48m1s32s"}, {"2014Y02M29D"}, {"1800Y02M29D"}, {"2000Y02M30D"}, {"2000Y02M31D"}, {"2012Y04M31D"}, {"2012Y06M31D"}, {"2012Y09M31D"}, {"2012Y11M31D"}};
    }

    @Override
    @DataProvider(name="matchingrules")
    public Object[][] createMatchingRuleTest() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(TimeService.SYSTEM.now());
        Date nowDate = calendar.getTime();
        calendar.add(2, 1);
        Date oneMonthAheadDate = calendar.getTime();
        SimpleDateFormat partialTimeUpToSeconds = new SimpleDateFormat("yyyy'Y'MM'M'dd'D'HH'h'mm'm'ss's'");
        SimpleDateFormat generalizedTimeUpToSeconds = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        SimpleDateFormat partialTimeUpToMinutes = new SimpleDateFormat("yyyy'Y'MM'M'dd'D'HH'h'mm'm'");
        SimpleDateFormat generalizedTimeUpToMinutes = new SimpleDateFormat("yyyyMMddHHmm'Z'");
        SimpleDateFormat partialTimeUpToHours = new SimpleDateFormat("yyyy'Y'MM'M'dd'D'HH'h'");
        SimpleDateFormat generalizedTimeUpToHours = new SimpleDateFormat("yyyyMMddHH'Z'");
        return new Object[][]{{generalizedTimeUpToSeconds.format(nowDate), partialTimeUpToSeconds.format(nowDate), ConditionResult.TRUE}, {generalizedTimeUpToSeconds.format(oneMonthAheadDate), partialTimeUpToSeconds.format(oneMonthAheadDate), ConditionResult.TRUE}, {generalizedTimeUpToMinutes.format(nowDate), partialTimeUpToMinutes.format(nowDate), ConditionResult.TRUE}, {generalizedTimeUpToMinutes.format(oneMonthAheadDate), partialTimeUpToMinutes.format(oneMonthAheadDate), ConditionResult.TRUE}, {generalizedTimeUpToHours.format(nowDate), partialTimeUpToHours.format(nowDate), ConditionResult.TRUE}, {generalizedTimeUpToHours.format(oneMonthAheadDate), partialTimeUpToHours.format(oneMonthAheadDate), ConditionResult.TRUE}, {"20120329120000Z", "2012Y03M29D", ConditionResult.TRUE}, {"20120229120000Z", "2012Y02M29D", ConditionResult.TRUE}, {"20000229120000Z", "2000Y02M29D", ConditionResult.TRUE}, {"20120630235959Z", "2012Y06M30D23h59m60s", ConditionResult.FALSE}, {"20111231235930Z", "2012Y12M31D23h59m30s", ConditionResult.FALSE}, {"20121031235930Z", "2012Y12M31D23h59m30s", ConditionResult.FALSE}, {"20121230235930Z", "2012Y12M31D23h59m30s", ConditionResult.FALSE}, {"20121231225930Z", "2012Y12M31D23h59m30s", ConditionResult.FALSE}, {"20121231235830Z", "2012Y12M31D23h59m30s", ConditionResult.FALSE}, {"20121231235829Z", "2012Y12M31D23h59m30s", ConditionResult.FALSE}, {"19820930120000Z", "1982Y09M30D", ConditionResult.TRUE}, {"20120131120000Z", "2012Y01M31D", ConditionResult.TRUE}, {"20120331120000Z", "2012Y03M31D", ConditionResult.TRUE}, {"20120531120000Z", "2012Y05M31D", ConditionResult.TRUE}, {"20120731120000Z", "2012Y07M31D", ConditionResult.TRUE}, {"20120831120000Z", "2012Y08M31D", ConditionResult.TRUE}, {"20121031120000Z", "2012Y10M31D", ConditionResult.TRUE}, {"20121231120000Z", "2012Y12M31D", ConditionResult.TRUE}, {"20121231123000Z", "2012Y", ConditionResult.TRUE}, {"20121231123000Z", "2012Y12M", ConditionResult.TRUE}, {"20121231123000Z", "2012Y31D", ConditionResult.TRUE}, {"20121231123000Z", "2012Y12h", ConditionResult.TRUE}, {"20121231123000Z", "2012Y30m", ConditionResult.TRUE}, {"20121231123000Z", "2012Y0s", ConditionResult.TRUE}};
    }

    @Override
    protected MatchingRule getRule() {
        return CoreSchema.getInstance().getMatchingRule("1.3.6.1.4.1.26027.1.4.7");
    }

    @Test
    public void testCreateIndexQuery() throws Exception {
        Assertion assertion = this.getRule().getAssertion((ByteSequence)ByteString.valueOfUtf8((CharSequence)"2012Y"));
        String indexQuery = (String)assertion.createIndexQuery((IndexQueryFactory)new AbstractSubstringMatchingRuleImplTest.FakeIndexQueryFactory(AbstractSubstringMatchingRuleImplTest.newIndexingOptions(), false));
        Assertions.assertThat((String)indexQuery).matches("intersect\\[exactMatch\\(partialDateAndTimeMatchingRule, value=='[0-9A-Z ]*'\\)\\]");
    }
}

