/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class OrderingMatchingRuleTest
extends AbstractSchemaTestCase {
    @DataProvider(name="OrderingMatchingRuleInvalidValues")
    public abstract Object[][] createOrderingMatchingRuleInvalidValues();

    @DataProvider(name="Orderingmatchingrules")
    public abstract Object[][] createOrderingMatchingRuleTestData();

    @Test(dataProvider="Orderingmatchingrules")
    public void orderingMatchingRules(String value1, String value2, int result) throws Exception {
        ByteString normalizedValue2;
        MatchingRule ruleInstance = this.getRule();
        ByteString normalizedValue1 = ruleInstance.normalizeAttributeValue((ByteSequence)ByteString.valueOfUtf8((CharSequence)value1));
        int comp = normalizedValue1.compareTo((ByteSequence)(normalizedValue2 = ruleInstance.normalizeAttributeValue((ByteSequence)ByteString.valueOfUtf8((CharSequence)value2))));
        if (comp == 0) {
            Assert.assertEquals((int)comp, (int)result);
        } else if (comp > 0) {
            Assert.assertTrue((result > 0 ? 1 : 0) != 0);
        } else if (comp < 0) {
            Assert.assertTrue((result < 0 ? 1 : 0) != 0);
        }
        Assertion a = ruleInstance.getGreaterOrEqualAssertion((ByteSequence)ByteString.valueOfUtf8((CharSequence)value2));
        Assert.assertEquals((Object)a.matches((ByteSequence)normalizedValue1), (Object)ConditionResult.valueOf((result >= 0 ? 1 : 0) != 0));
        a = ruleInstance.getLessOrEqualAssertion((ByteSequence)ByteString.valueOfUtf8((CharSequence)value2));
        Assert.assertEquals((Object)a.matches((ByteSequence)normalizedValue1), (Object)ConditionResult.valueOf((result <= 0 ? 1 : 0) != 0));
        a = ruleInstance.getAssertion((ByteSequence)ByteString.valueOfUtf8((CharSequence)value2));
        Assert.assertEquals((Object)a.matches((ByteSequence)normalizedValue1), (Object)ConditionResult.valueOf((result < 0 ? 1 : 0) != 0));
    }

    @Test(expectedExceptions={DecodeException.class}, dataProvider="OrderingMatchingRuleInvalidValues")
    public void orderingMatchingRulesInvalidValues(String value) throws Exception {
        MatchingRule ruleInstance = this.getRule();
        ruleInstance.normalizeAttributeValue((ByteSequence)ByteString.valueOfUtf8((CharSequence)value));
    }

    protected abstract MatchingRule getRule();
}

