/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleTest;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.forgerock.opendj.ldap.spi.Indexer;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class ObjectIdentifierEqualityMatchingRuleTest
extends MatchingRuleTest {
    @Override
    @DataProvider(name="matchingRuleInvalidAttributeValues")
    public Object[][] createMatchingRuleInvalidAttributeValues() {
        return new Object[0][];
    }

    @Override
    @DataProvider(name="matchingrules")
    public Object[][] createMatchingRuleTest() {
        return new Object[][]{{"2.5.4.3", "2.5.4.3", ConditionResult.TRUE}, {"2.5.4.3", "2.5.4.4", ConditionResult.FALSE}, {"2.5.4.3", "9.9.9.999", ConditionResult.FALSE}, {"9.9.9.999", "9.9.9.999", ConditionResult.TRUE}, {"9.9.9.999", "9.9.9.9999", ConditionResult.FALSE}, {"2.5.4.3", "cn", ConditionResult.TRUE}, {"2.5.4.3", "commonName", ConditionResult.TRUE}, {"2.5.4.3", "l", ConditionResult.FALSE}, {"cn", "2.5.4.3", ConditionResult.TRUE}, {"commonName", "2.5.4.3", ConditionResult.TRUE}, {"l", "2.5.4.3", ConditionResult.FALSE}, {"cn", "cn", ConditionResult.TRUE}, {"commonName", "cn", ConditionResult.TRUE}, {"cn", "commonName", ConditionResult.TRUE}, {"commonName", "commonName", ConditionResult.TRUE}, {"l", "cn", ConditionResult.FALSE}, {"cn", "l", ConditionResult.FALSE}, {"dummy", "DUMMY", ConditionResult.TRUE}, {"dummy", "2.5.4.3", ConditionResult.FALSE}};
    }

    @Override
    protected MatchingRule getRule() {
        return Schema.getCoreSchema().getMatchingRule("2.5.13.0");
    }

    @Test
    public void indexingShouldNotBeSensitiveToSchemaChanges() throws Exception {
        String customDefinition = "( 9.9.9.999 NAME ( 'foo' 'bar' ) SUP name )";
        Schema customSchema = new SchemaBuilder(Schema.getCoreSchema()).addAttributeType("( 9.9.9.999 NAME ( 'foo' 'bar' ) SUP name )", true).toSchema();
        List<ByteString> attributeValues = Arrays.asList(this.b("9.9.9.999"), this.b("FOO"), this.b("cn"));
        this.checkIndexContainsExpectedKeys(Schema.getCoreSchema(), attributeValues, this.b("9.9.9.999"), this.b("foo"), this.b("cn"));
        this.checkIndexContainsExpectedKeys(customSchema, attributeValues, this.b("9.9.9.999"), this.b("foo"), this.b("cn"));
        ByteString assertionValue = this.b("bar");
        this.checkKeysUsedForIndexQuerying(Schema.getCoreSchema(), assertionValue, this.b("bar"));
        this.checkKeysUsedForIndexQuerying(customSchema, assertionValue, this.b("bar"), this.b("9.9.9.999"), this.b("foo"));
    }

    private void checkIndexContainsExpectedKeys(Schema schema, List<ByteString> attributeValues, ByteString ... expectedKeys) throws DecodeException {
        MatchingRule mr = schema.getMatchingRule("2.5.13.0");
        Indexer indexer = (Indexer)mr.createIndexers(null).iterator().next();
        ArrayList keys = new ArrayList();
        for (ByteString value : attributeValues) {
            indexer.createKeys(schema, (ByteSequence)value, keys);
        }
        Assertions.assertThat(keys).containsExactly((Object[])expectedKeys);
    }

    private void checkKeysUsedForIndexQuerying(Schema schema, ByteString assertionValue, ByteString ... expectedKeys) throws DecodeException {
        MatchingRule mr = schema.getMatchingRule("2.5.13.0");
        Assertion assertion = mr.getAssertion((ByteSequence)assertionValue);
        IndexQueryFactory indexQueryFactory = (IndexQueryFactory)Mockito.mock(IndexQueryFactory.class);
        assertion.createIndexQuery(indexQueryFactory);
        for (ByteString key : expectedKeys) {
            ((IndexQueryFactory)Mockito.verify((Object)indexQueryFactory)).createExactMatchQuery("objectIdentifierMatch", (ByteSequence)key);
        }
        ((IndexQueryFactory)Mockito.verify((Object)indexQueryFactory)).createUnionQuery(Matchers.anyCollection());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{indexQueryFactory});
    }

    private ByteString b(String value) {
        return ByteString.valueOfUtf8((CharSequence)value);
    }
}

