/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.fest.assertions.Assertions;
import org.fest.assertions.CollectionAssert;
import org.fest.assertions.StringAssert;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ObjectClassTestCase
extends AbstractSchemaTestCase {
    @Test
    public void extensibleObjectShouldAcceptPlaceholderAttribute() {
        Schema schema = Schema.getCoreSchema();
        ObjectClass extensibleObject = schema.getObjectClass("1.3.6.1.4.1.1466.101.120.111");
        AttributeType attributeType = schema.getAttributeType("dummy");
        Assertions.assertThat((boolean)attributeType.isPlaceHolder()).isTrue();
        Assertions.assertThat((boolean)extensibleObject.isRequired(attributeType)).isFalse();
        Assertions.assertThat((boolean)extensibleObject.isOptional(attributeType)).isTrue();
        Assertions.assertThat((boolean)extensibleObject.isRequiredOrOptional(attributeType)).isTrue();
    }

    @Test
    public void extensibleObjectShouldAcceptAnyAttribute() {
        Schema schema = Schema.getCoreSchema();
        ObjectClass extensibleObject = schema.getObjectClass("1.3.6.1.4.1.1466.101.120.111");
        AttributeType cn = schema.getAttributeType("cn");
        Assertions.assertThat((boolean)cn.isPlaceHolder()).isFalse();
        Assertions.assertThat((boolean)extensibleObject.isRequired(cn)).isFalse();
        Assertions.assertThat((boolean)extensibleObject.isOptional(cn)).isTrue();
        Assertions.assertThat((boolean)extensibleObject.isRequiredOrOptional(cn)).isTrue();
    }

    @Test
    public void testNames() throws Exception {
        ObjectClass oc = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3").names(new String[]{"testType", "testNameAlias", "anotherNameAlias"}).addToSchema().toSchema().getObjectClass("1.2.3");
        Assertions.assertThat((boolean)oc.hasName("testType")).isTrue();
        Assertions.assertThat((boolean)oc.hasName("testNameAlias")).isTrue();
        Assertions.assertThat((boolean)oc.hasName("anotherNameAlias")).isTrue();
        Assertions.assertThat((boolean)oc.hasName("unknownAlias")).isFalse();
        Assertions.assertThat((List)oc.getNames()).containsOnly(new Object[]{"testType", "testNameAlias", "anotherNameAlias"});
    }

    @Test
    public void testNameOrOIDReturnsOIDWhenNoName() throws Exception {
        ObjectClass oc = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3").addToSchema().toSchema().getObjectClass("1.2.3");
        Assertions.assertThat((String)oc.getNameOrOID()).isEqualTo((Object)"1.2.3");
    }

    @Test
    public void testNameOrOIDReturnsPrimaryNameWhenOneOrMoreNames() throws Exception {
        ObjectClass oc1 = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3").names(new String[]{"testType"}).addToSchema().toSchema().getObjectClass("1.2.3");
        ObjectClass oc2 = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3").names(new String[]{"testType", "testAlias"}).addToSchema().toSchema().getObjectClass("1.2.3");
        Assertions.assertThat((String)oc1.getNameOrOID()).isEqualTo((Object)"testType");
        Assertions.assertThat((String)oc2.getNameOrOID()).isEqualTo((Object)"testType");
    }

    @DataProvider
    public final Object[][] equalsData() {
        return new Object[][]{{"testType", "1.2.3", "testType", "1.2.3", true}, {"testType", "1.2.3", "xxx", "1.2.3", true}, {"testType", "1.2.3", "testType", "1.2.4", false}, {"testType", "1.2.3", "xxx", "1.2.4", false}};
    }

    @Test(dataProvider="equalsData")
    public final void testEquals(String name1, String oid1, String name2, String oid2, boolean shouldBeEqual) throws Exception {
        ObjectClass oc1 = new SchemaBuilder(this.schema()).buildObjectClass(oid1).names(new String[]{name1}).addToSchema().toSchema().getObjectClass(oid1);
        ObjectClass oc2 = new SchemaBuilder(this.schema()).buildObjectClass(oid2).names(new String[]{name2}).addToSchema().toSchema().getObjectClass(oid2);
        if (shouldBeEqual) {
            Assertions.assertThat((Object)oc1).isEqualTo((Object)oc2);
            Assertions.assertThat((Object)oc2).isEqualTo((Object)oc1);
        } else {
            Assertions.assertThat((Object)oc1).isNotEqualTo((Object)oc2);
            Assertions.assertThat((Object)oc2).isNotEqualTo((Object)oc1);
        }
    }

    @Test
    public void testGetOptionalAttributesNoSuperiorNoAttribute() throws Exception {
        ObjectClass.Builder ocBuilder = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3").names(new String[]{"testType"});
        ObjectClass oc = ocBuilder.addToSchema().toSchema().getObjectClass("1.2.3");
        Assertions.assertThat((Collection)oc.getOptionalAttributes()).isEmpty();
        Assertions.assertThat((Collection)oc.getDeclaredOptionalAttributes()).isEmpty();
    }

    @Test
    public void testGetOptionalAttributesNoSuperior() throws Exception {
        Schema schema = this.schema();
        ObjectClass oc = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3").names(new String[]{"testType"}).optionalAttributes(new String[]{"at1", "at2", "at3"}).addToSchema().toSchema().getObjectClass("1.2.3");
        Assertions.assertThat((Collection)oc.getOptionalAttributes()).containsOnly(this.attrs(schema, "at1", "at2", "at3"));
        Assertions.assertThat((Collection)oc.getDeclaredOptionalAttributes()).containsOnly(this.attrs(schema, "at1", "at2", "at3"));
    }

    @Test
    public void testGetOptionalAttributeOneSuperiorNoAttribute() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"parent"}).optionalAttributes(new String[]{"at1", "at2", "at3"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"child"}).superiorObjectClasses(new String[]{"parent"}).addToSchema().toSchema();
        ObjectClass child = schema.getObjectClass("child");
        Assertions.assertThat((Collection)child.getOptionalAttributes()).containsOnly(this.attrs(schema, "at1", "at2", "at3"));
        Assertions.assertThat((Collection)child.getDeclaredOptionalAttributes()).isEmpty();
    }

    @Test
    public void testGetOptionalAttributeMultipleSuperiorsNoAttribute() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"parent1"}).optionalAttributes(new String[]{"at1", "at2", "at3"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"parent2"}).optionalAttributes(new String[]{"at4", "at5", "at6"}).addToSchema().buildObjectClass("1.2.3.3").names(new String[]{"child"}).superiorObjectClasses(new String[]{"parent1", "parent2"}).addToSchema().toSchema();
        ObjectClass child = schema.getObjectClass("child");
        Set attributes = child.getOptionalAttributes();
        Assertions.assertThat((Collection)attributes).containsOnly(this.attrs(schema, "at1", "at2", "at3", "at4", "at5", "at6"));
    }

    @Test
    public void testGetOptionalAttributeOneSuperior() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"parent"}).optionalAttributes(new String[]{"at1", "at2", "at3"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"child"}).optionalAttributes(new String[]{"at4", "at5", "at6"}).superiorObjectClasses(new String[]{"parent"}).addToSchema().toSchema();
        ObjectClass child = schema.getObjectClass("child");
        Assertions.assertThat((Collection)child.getOptionalAttributes()).containsOnly(this.attrs(schema, "at1", "at2", "at3", "at4", "at5", "at6"));
        Assertions.assertThat((Collection)child.getDeclaredOptionalAttributes()).containsOnly(this.attrs(schema, "at4", "at5", "at6"));
    }

    @Test
    public void testGetOptionalAttributeMultipleSuperiors() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"parent1"}).optionalAttributes(new String[]{"at1", "at2", "at3"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"parent2"}).optionalAttributes(new String[]{"at4", "at5", "at6"}).addToSchema().buildObjectClass("1.2.3.3").names(new String[]{"child"}).optionalAttributes(new String[]{"at7", "at8", "at9"}).superiorObjectClasses(new String[]{"parent1", "parent2"}).addToSchema().toSchema();
        ObjectClass child = schema.getObjectClass("child");
        Assertions.assertThat((Collection)child.getOptionalAttributes()).containsOnly(this.attrs(schema, "at1", "at2", "at3", "at4", "at5", "at6", "at7", "at8", "at9"));
        Assertions.assertThat((Collection)child.getDeclaredOptionalAttributes()).containsOnly(this.attrs(schema, "at7", "at8", "at9"));
    }

    @Test
    public void testGetRequiredAttributesNoSuperiorNoAttribute() throws Exception {
        ObjectClass.Builder ocBuilder = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3").names(new String[]{"testType"});
        ObjectClass oc = ocBuilder.addToSchema().toSchema().getObjectClass("1.2.3");
        Assertions.assertThat((Collection)oc.getRequiredAttributes()).isEmpty();
        Assertions.assertThat((Collection)oc.getDeclaredRequiredAttributes()).isEmpty();
    }

    @Test
    public void testGetRequiredAttributesNoSuperior() throws Exception {
        Schema schema = this.schema();
        ObjectClass oc = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3").names(new String[]{"testType"}).requiredAttributes(new String[]{"at1", "at2", "at3"}).addToSchema().toSchema().getObjectClass("1.2.3");
        Assertions.assertThat((Collection)oc.getRequiredAttributes()).containsOnly(this.attrs(schema, "at1", "at2", "at3"));
        Assertions.assertThat((Collection)oc.getDeclaredRequiredAttributes()).containsOnly(this.attrs(schema, "at1", "at2", "at3"));
    }

    @Test
    public void testGetRequiredAttributeOneSuperiorNoAttribute() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"parent"}).requiredAttributes(new String[]{"at1", "at2", "at3"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"child"}).superiorObjectClasses(new String[]{"parent"}).addToSchema().toSchema();
        ObjectClass child = schema.getObjectClass("child");
        Assertions.assertThat((Collection)child.getRequiredAttributes()).containsOnly(this.attrs(schema, "at1", "at2", "at3"));
        Assertions.assertThat((Collection)child.getDeclaredRequiredAttributes()).isEmpty();
    }

    @Test
    public void testGetRequiredAttributeMultipleSuperiorsNoAttribute() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"parent1"}).requiredAttributes(new String[]{"at1", "at2", "at3"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"parent2"}).requiredAttributes(new String[]{"at4", "at5", "at6"}).addToSchema().buildObjectClass("1.2.3.3").names(new String[]{"child"}).superiorObjectClasses(new String[]{"parent1", "parent2"}).addToSchema().toSchema();
        ObjectClass child = schema.getObjectClass("child");
        Assertions.assertThat((Collection)child.getRequiredAttributes()).containsOnly(this.attrs(schema, "at1", "at2", "at3", "at4", "at5", "at6"));
        Assertions.assertThat((Collection)child.getDeclaredRequiredAttributes()).isEmpty();
    }

    @Test
    public void testGetRequiredAttributeOneSuperior() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"parent"}).requiredAttributes(new String[]{"at1", "at2", "at3"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"child"}).requiredAttributes(new String[]{"at4", "at5", "at6"}).superiorObjectClasses(new String[]{"parent"}).addToSchema().toSchema();
        ObjectClass child = schema.getObjectClass("child");
        Assertions.assertThat((Collection)child.getRequiredAttributes()).containsOnly(this.attrs(schema, "at1", "at2", "at3", "at4", "at5", "at6"));
        Assertions.assertThat((Collection)child.getDeclaredRequiredAttributes()).containsOnly(this.attrs(schema, "at4", "at5", "at6"));
    }

    @Test
    public void testGetRequiredAttributeMultipleSuperiors() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"parent1"}).requiredAttributes(new String[]{"at1", "at2", "at3"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"parent2"}).requiredAttributes(new String[]{"at4", "at5", "at6"}).addToSchema().buildObjectClass("1.2.3.3").names(new String[]{"child"}).requiredAttributes(new String[]{"at7", "at8", "at9"}).superiorObjectClasses(new String[]{"parent1", "parent2"}).addToSchema().toSchema();
        ObjectClass child = schema.getObjectClass("child");
        Assertions.assertThat((Collection)child.getRequiredAttributes()).containsOnly(this.attrs(schema, "at1", "at2", "at3", "at4", "at5", "at6", "at7", "at8", "at9"));
        Assertions.assertThat((Collection)child.getDeclaredRequiredAttributes()).containsOnly(this.attrs(schema, "at7", "at8", "at9"));
    }

    @Test
    public void testGetSuperiorClassNoSuperiorDefined() throws Exception {
        Schema schema = this.schema();
        ObjectClass oc = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3").names(new String[]{"testType"}).addToSchema().toSchema().getObjectClass("1.2.3");
        ((CollectionAssert)Assertions.assertThat((Collection)oc.getSuperiorClasses()).as("\"top\" should be added to superior classes for STRUCTURAL object classes")).containsOnly(new Object[]{schema.getObjectClass("2.5.6.0")});
        ((StringAssert)Assertions.assertThat((String)oc.toString()).as("toString() should return the initial definition, without top")).isEqualTo((Object)"( 1.2.3 NAME 'testType' )");
    }

    @Test
    public void testGetSuperiorClassWithSuperior() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"parent"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"child"}).superiorObjectClasses(new String[]{"parent"}).addToSchema().toSchema();
        ObjectClass child = schema.getObjectClass("child");
        Assertions.assertThat((Collection)child.getSuperiorClasses()).containsOnly(this.objectClasses(schema, "parent"));
        Assertions.assertThat((String)child.toString()).isEqualTo((Object)"( 1.2.3.2 NAME 'child' SUP parent )");
    }

    @Test
    public void testGetSuperiorClassWithMultipleSuperiors() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"parent1"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"parent2"}).addToSchema().buildObjectClass("1.2.3.3").names(new String[]{"child"}).superiorObjectClasses(new String[]{"parent1", "parent2"}).addToSchema().toSchema();
        ObjectClass child = schema.getObjectClass("child");
        Assertions.assertThat((Collection)child.getSuperiorClasses()).containsOnly(this.objectClasses(schema, "parent1", "parent2"));
    }

    @Test
    public void testStructuralIsDescendantOfTopDespiteNoSuperiorDeclared() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"testType1"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"testType2"}).addToSchema().toSchema();
        ObjectClass testType1 = schema.getObjectClass("testType1");
        ObjectClass testType2 = schema.getObjectClass("testType2");
        Assertions.assertThat((boolean)testType1.isDescendantOf(testType2)).isFalse();
        Assertions.assertThat((boolean)testType1.isDescendantOf(schema.getObjectClass("2.5.6.0"))).isTrue();
    }

    @Test
    public void testIsDescendantOfWithSuperior() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"grandParent"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"parent"}).superiorObjectClasses(new String[]{"grandParent"}).addToSchema().buildObjectClass("1.2.3.3").names(new String[]{"child"}).superiorObjectClasses(new String[]{"parent"}).addToSchema().toSchema();
        ObjectClass grandParent = schema.getObjectClass("grandParent");
        ObjectClass parent = schema.getObjectClass("parent");
        ObjectClass child = schema.getObjectClass("child");
        Assert.assertTrue((boolean)parent.isDescendantOf(grandParent));
        Assert.assertTrue((boolean)child.isDescendantOf(parent));
        Assert.assertTrue((boolean)child.isDescendantOf(grandParent));
        Assert.assertFalse((boolean)child.isDescendantOf(child));
        Assert.assertFalse((boolean)parent.isDescendantOf(child));
        Assert.assertFalse((boolean)grandParent.isDescendantOf(child));
    }

    @Test
    public void testIsDescendantOfWithMultipleSuperiors() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"grandParent"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"parent1"}).superiorObjectClasses(new String[]{"grandParent"}).addToSchema().buildObjectClass("1.2.3.3").names(new String[]{"parent2"}).addToSchema().buildObjectClass("1.2.3.4").names(new String[]{"child"}).superiorObjectClasses(new String[]{"parent1", "parent2"}).addToSchema().toSchema();
        ObjectClass grandParent = schema.getObjectClass("grandParent");
        ObjectClass parent1 = schema.getObjectClass("parent1");
        ObjectClass parent2 = schema.getObjectClass("parent2");
        ObjectClass child = schema.getObjectClass("child");
        Assert.assertTrue((boolean)parent1.isDescendantOf(grandParent));
        Assert.assertTrue((boolean)child.isDescendantOf(parent1));
        Assert.assertTrue((boolean)child.isDescendantOf(parent2));
        Assert.assertTrue((boolean)child.isDescendantOf(grandParent));
        Assert.assertFalse((boolean)child.isDescendantOf(child));
        Assert.assertFalse((boolean)parent1.isDescendantOf(child));
        Assert.assertFalse((boolean)parent1.isDescendantOf(parent2));
        Assert.assertFalse((boolean)parent2.isDescendantOf(grandParent));
        Assert.assertFalse((boolean)grandParent.isDescendantOf(child));
    }

    @Test
    public void testIsOptionalNoAttribute() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"testType"}).addToSchema().toSchema();
        ObjectClass oc = schema.getObjectClass("testType");
        Assert.assertFalse((boolean)oc.isOptional(schema.getAttributeType("at1")));
    }

    @Test
    public void testIsOptionalNoSuperior() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"testType"}).optionalAttributes(new String[]{"at1"}).addToSchema().toSchema();
        ObjectClass oc = schema.getObjectClass("testType");
        Assert.assertTrue((boolean)oc.isOptional(schema.getAttributeType("at1")));
        Assert.assertFalse((boolean)oc.isOptional(schema.getAttributeType("at2")));
    }

    @Test
    public void testIsOptionalNoAttributeWithOneSuperior() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"parent"}).optionalAttributes(new String[]{"at1"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"child"}).superiorObjectClasses(new String[]{"parent"}).addToSchema().toSchema();
        ObjectClass child = schema.getObjectClass("child");
        Assert.assertTrue((boolean)child.isOptional(schema.getAttributeType("at1")));
        Assert.assertFalse((boolean)child.isOptional(schema.getAttributeType("at2")));
    }

    @Test
    public void testIsOptionalWithOneSuperior() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"parent"}).optionalAttributes(new String[]{"at1"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"child"}).optionalAttributes(new String[]{"at2"}).superiorObjectClasses(new String[]{"parent"}).addToSchema().toSchema();
        ObjectClass child = schema.getObjectClass("child");
        Assert.assertTrue((boolean)child.isOptional(schema.getAttributeType("at1")));
        Assert.assertTrue((boolean)child.isOptional(schema.getAttributeType("at2")));
        Assert.assertFalse((boolean)child.isOptional(schema.getAttributeType("at3")));
    }

    @Test
    public void testIsOptionalExtensible() throws Exception {
        Schema schema = this.schema();
        ObjectClass oc = schema.getObjectClass("1.3.6.1.4.1.1466.101.120.111");
        Assert.assertTrue((boolean)oc.isOptional(schema.getAttributeType("at1")));
        Assert.assertTrue((boolean)oc.isOptional(schema.getAttributeType("at2")));
    }

    @Test
    public void testIsRequiredNoAttribute() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"testType"}).addToSchema().toSchema();
        ObjectClass oc = schema.getObjectClass("testType");
        Assert.assertFalse((boolean)oc.isRequired(schema.getAttributeType("at1")));
    }

    @Test
    public void testIsRequiredNoSuperior() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"testType"}).requiredAttributes(new String[]{"at1"}).addToSchema().toSchema();
        ObjectClass oc = schema.getObjectClass("testType");
        Assert.assertTrue((boolean)oc.isRequired(schema.getAttributeType("at1")));
        Assert.assertFalse((boolean)oc.isRequired(schema.getAttributeType("at2")));
    }

    @Test
    public void testIsRequiredNoAttributeWithOneSuperior() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"parent"}).requiredAttributes(new String[]{"at1"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"child"}).superiorObjectClasses(new String[]{"parent"}).addToSchema().toSchema();
        ObjectClass child = schema.getObjectClass("child");
        Assert.assertTrue((boolean)child.isRequired(schema.getAttributeType("at1")));
        Assert.assertFalse((boolean)child.isRequired(schema.getAttributeType("at2")));
    }

    @Test
    public void testIsRequiredWithOneSuperior() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"parent"}).requiredAttributes(new String[]{"at1"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"child"}).requiredAttributes(new String[]{"at2"}).superiorObjectClasses(new String[]{"parent"}).addToSchema().toSchema();
        ObjectClass child = schema.getObjectClass("child");
        Assert.assertTrue((boolean)child.isRequired(schema.getAttributeType("at1")));
        Assert.assertTrue((boolean)child.isRequired(schema.getAttributeType("at2")));
        Assert.assertFalse((boolean)child.isRequired(schema.getAttributeType("at3")));
    }

    @Test
    public void testIsRequiredOrOptionalNoAttribute() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"testType"}).addToSchema().toSchema();
        ObjectClass oc = schema.getObjectClass("testType");
        Assert.assertFalse((boolean)oc.isRequiredOrOptional(schema.getAttributeType("at1")));
    }

    @Test
    public void testIsRequiredOrOptionalNoSuperior() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"testType"}).requiredAttributes(new String[]{"at1"}).optionalAttributes(new String[]{"at2"}).addToSchema().toSchema();
        ObjectClass oc = schema.getObjectClass("testType");
        Assert.assertTrue((boolean)oc.isRequiredOrOptional(schema.getAttributeType("at1")));
        Assert.assertTrue((boolean)oc.isRequiredOrOptional(schema.getAttributeType("at2")));
        Assert.assertFalse((boolean)oc.isRequiredOrOptional(schema.getAttributeType("at3")));
    }

    @Test
    public void testIsRequiredOrOptionalNoAttributeWithOneSuperior() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"parent"}).requiredAttributes(new String[]{"at1"}).optionalAttributes(new String[]{"at2"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"child"}).superiorObjectClasses(new String[]{"parent"}).addToSchema().toSchema();
        ObjectClass child = schema.getObjectClass("child");
        Assert.assertTrue((boolean)child.isRequiredOrOptional(schema.getAttributeType("at1")));
        Assert.assertTrue((boolean)child.isRequiredOrOptional(schema.getAttributeType("at2")));
        Assert.assertFalse((boolean)child.isRequiredOrOptional(schema.getAttributeType("at3")));
    }

    @Test
    public void testIsRequiredOrOptionalWithOneSuperior() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"parent"}).requiredAttributes(new String[]{"at1"}).optionalAttributes(new String[]{"at2"}).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"child"}).requiredAttributes(new String[]{"at3"}).optionalAttributes(new String[]{"at4"}).superiorObjectClasses(new String[]{"parent"}).addToSchema().toSchema();
        ObjectClass child = schema.getObjectClass("child");
        Assert.assertTrue((boolean)child.isRequiredOrOptional(schema.getAttributeType("at1")));
        Assert.assertTrue((boolean)child.isRequiredOrOptional(schema.getAttributeType("at2")));
        Assert.assertTrue((boolean)child.isRequiredOrOptional(schema.getAttributeType("at3")));
        Assert.assertTrue((boolean)child.isRequiredOrOptional(schema.getAttributeType("at4")));
        Assert.assertFalse((boolean)child.isRequiredOrOptional(schema.getAttributeType("at5")));
    }

    @Test
    public void testIsRequiredOrOptionalExtensible() throws Exception {
        Schema schema = this.schema();
        ObjectClass oc = schema.getObjectClass("1.3.6.1.4.1.1466.101.120.111");
        Assert.assertTrue((boolean)oc.isRequiredOrOptional(schema.getAttributeType("at1")));
        Assert.assertTrue((boolean)oc.isRequiredOrOptional(schema.getAttributeType("at2")));
    }

    @DataProvider
    public Object[][] superiorData() throws Exception {
        Schema schema = new SchemaBuilder(this.schema()).buildObjectClass("1.2.3.1").names(new String[]{"parent1"}).type(ObjectClassType.ABSTRACT).addToSchema().buildObjectClass("1.2.3.2").names(new String[]{"parent2"}).type(ObjectClassType.ABSTRACT).addToSchema().buildObjectClass("1.2.3.3").names(new String[]{"parent3"}).type(ObjectClassType.STRUCTURAL).addToSchema().buildObjectClass("1.2.3.4").names(new String[]{"parent4"}).type(ObjectClassType.STRUCTURAL).addToSchema().buildObjectClass("1.2.3.5").names(new String[]{"parent5"}).type(ObjectClassType.AUXILIARY).addToSchema().buildObjectClass("1.2.3.6").names(new String[]{"parent6"}).type(ObjectClassType.AUXILIARY).addToSchema().toSchema();
        return new Object[][]{{"parent1", "parent2", ObjectClassType.ABSTRACT, schema}, {"parent3", "parent4", ObjectClassType.STRUCTURAL, schema}, {"parent5", "parent6", ObjectClassType.AUXILIARY, schema}};
    }

    @Test(dataProvider="superiorData")
    public void testMultipleSuperiors(String parent1, String parent2, ObjectClassType type, Schema schema) throws Exception {
        ObjectClass child = new SchemaBuilder(schema).buildObjectClass("1.2.3.7").names(new String[]{"child"}).type(type).superiorObjectClasses(new String[]{parent1, parent2}).addToSchema().toSchema().getObjectClass("child");
        Assertions.assertThat((Collection)child.getSuperiorClasses()).hasSize(2);
    }

    private Schema schema() throws Exception {
        SchemaBuilder sb = new SchemaBuilder(Schema.getCoreSchema());
        for (int i = 1; i <= 9; ++i) {
            sb.buildAttributeType("1.2.3.4." + i).names(new String[]{"at" + i}).addToSchema();
        }
        return sb.toSchema();
    }

    private Object[] attrs(Schema schema, String ... names) {
        Object[] attrs = new AttributeType[names.length];
        int i = 0;
        for (String name : names) {
            attrs[i++] = schema.getAttributeType(name);
        }
        return attrs;
    }

    private Object[] objectClasses(Schema schema, String ... names) {
        Object[] attrs = new ObjectClass[names.length];
        int i = 0;
        for (String name : names) {
            attrs[i++] = schema.getObjectClass(name);
        }
        return attrs;
    }
}

