/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fest.assertions.Assertions;
import org.fest.assertions.MapAssert;
import org.forgerock.opendj.ldap.schema.AbstractSchemaElement;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.ConflictingSchemaElementException;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ObjectClassBuilderTestCase
extends AbstractSchemaTestCase {
    @DataProvider
    Object[][] validObjectClasses() {
        return new Object[][]{{"1.2.3.4", false, Collections.singletonList("MyObjectClass"), Collections.emptySet(), Collections.singleton("cn"), Collections.singleton("top"), ObjectClassType.STRUCTURAL, "MyObjectClass description.", "X-New-extra-property", "New extra value", false}, {"2.5.6.9", false, Collections.singletonList("groupOfFirstNames"), Collections.emptySet(), Collections.singleton("cn"), Collections.singleton("top"), ObjectClassType.AUXILIARY, "MyObjectClass description.", "X-New-extra-property", "New extra value", true}, {"1.2.3.4", false, Collections.emptyList(), Collections.singleton("name"), Collections.singleton("cn"), Collections.singleton("top"), ObjectClassType.STRUCTURAL, "MyObjectClass description.", "X-New-extra-property", "New extra value", false}, {"1.2.3.4", false, Collections.emptyList(), Collections.singleton("name"), Collections.singleton("cn"), Collections.singleton("top"), ObjectClassType.STRUCTURAL, "", "X-New-extra-property", "New extra value", false}};
    }

    @Test(dataProvider="validObjectClasses")
    public void testValidOCBuilder(String oid, boolean isObsolete, List<String> names, Set<String> optionalAttributeOIDs, Set<String> requiredAttributesOIDs, Set<String> superiorClassOIDs, ObjectClassType type, String description, String extraPropertyName, String extraPropertyValue, boolean overwrite) throws Exception {
        ObjectClass.Builder ocBuilder = new SchemaBuilder(Schema.getCoreSchema()).buildObjectClass(oid).description(description).obsolete(isObsolete).names(names).superiorObjectClasses(superiorClassOIDs).requiredAttributes(requiredAttributesOIDs).optionalAttributes(optionalAttributeOIDs).type(type).extraProperties(extraPropertyName, new String[]{extraPropertyValue});
        Schema schema = overwrite ? ocBuilder.addToSchemaOverwrite().toSchema() : ocBuilder.addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        ObjectClass oc = schema.getObjectClass(oid);
        this.validate(oc, oid, isObsolete, names, optionalAttributeOIDs, requiredAttributesOIDs, superiorClassOIDs, type, description, extraPropertyName, extraPropertyValue);
        ObjectClass copiedOC = new SchemaBuilder(schema).buildObjectClass(oid + "-oid").addToSchema().toSchema().getObjectClass(oid);
        this.validate(copiedOC, oid, isObsolete, names, optionalAttributeOIDs, requiredAttributesOIDs, superiorClassOIDs, type, description, extraPropertyName, extraPropertyValue);
    }

    private void validate(ObjectClass oc, String oid, boolean isObsolete, List<String> names, Set<String> optionalAttributeOIDs, Set<String> requiredAttributesOIDs, Set<String> superiorClassOIDs, ObjectClassType type, String description, String extraPropertyName, String extraPropertyValue) throws Exception {
        Assertions.assertThat((Object)oc).isNotNull();
        Assertions.assertThat((String)oc.getOID()).isEqualTo((Object)oid);
        Assertions.assertThat((String)oc.getDescription()).isEqualTo((Object)description);
        Assertions.assertThat((boolean)oc.isObsolete()).isEqualTo(isObsolete);
        Assertions.assertThat((List)oc.getNames()).containsOnly(names.toArray());
        this.assertSchemaElementsContainsAll((Set<? extends AbstractSchemaElement>)oc.getSuperiorClasses(), superiorClassOIDs);
        this.assertSchemaElementsContainsAll((Set<? extends AbstractSchemaElement>)oc.getRequiredAttributes(), requiredAttributesOIDs);
        this.assertSchemaElementsContainsAll((Set<? extends AbstractSchemaElement>)oc.getOptionalAttributes(), optionalAttributeOIDs);
        Assertions.assertThat((Object)oc.getObjectClassType()).isEqualTo((Object)type);
        Assertions.assertThat((Map)oc.getExtraProperties()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)extraPropertyName, Collections.singletonList(extraPropertyValue))});
    }

    @Test
    public void testOCBuilderDefaultValues() throws Exception {
        SchemaBuilder sb = new SchemaBuilder(Schema.getCoreSchema());
        ObjectClass.Builder ocBuilder = sb.buildObjectClass("1.1.1.42").description("Default object class").superiorObjectClasses(new String[]{"top"}).names(new String[]{"defaultObjectClass"});
        Schema schema = ocBuilder.addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        ObjectClass oc = schema.getObjectClass("defaultObjectClass");
        Assertions.assertThat((Object)oc).isNotNull();
        Assertions.assertThat((String)oc.getOID()).isEqualTo((Object)"1.1.1.42");
        Assertions.assertThat((String)oc.getDescription()).isEqualTo((Object)"Default object class");
        Assertions.assertThat((boolean)oc.isObsolete()).isFalse();
        Assertions.assertThat((List)oc.getNames()).containsOnly(new Object[]{"defaultObjectClass"});
        this.assertSchemaElementsContainsAll((Set<? extends AbstractSchemaElement>)oc.getSuperiorClasses(), "top");
        Set topReqAttrs = schema.getObjectClass("top").getRequiredAttributes();
        Assertions.assertThat((Collection)oc.getRequiredAttributes()).containsOnly(topReqAttrs.toArray());
        Assertions.assertThat((Collection)oc.getOptionalAttributes()).isEmpty();
        Assertions.assertThat((Object)oc.getObjectClassType()).isEqualTo((Object)ObjectClassType.STRUCTURAL);
        Assertions.assertThat((Map)oc.getExtraProperties()).isEmpty();
    }

    @Test
    public void testOCBuilderCopyConstructor() throws Exception {
        SchemaBuilder sb = new SchemaBuilder(Schema.getCoreSchema());
        ObjectClass.Builder ocBuilder = sb.buildObjectClass("1.1.1.42").description("Object class to duplicate").superiorObjectClasses(new String[]{"top"}).names(new String[]{"ObjectClassToDuplicate"}).requiredAttributes(new String[]{"name"});
        Schema schema = ocBuilder.addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        sb.buildObjectClass(schema.getObjectClass("ObjectClassToDuplicate")).oid("1.1.1.43").removeAllNames().names(new String[]{"DuplicatedOC", "Copy"}).obsolete(true).addToSchemaOverwrite();
        Schema schemaCopy = sb.toSchema();
        Assertions.assertThat((Collection)schemaCopy.getWarnings()).isEmpty();
        ObjectClass ocCopy = schemaCopy.getObjectClass("Copy");
        Assertions.assertThat((Object)ocCopy).isNotNull();
        Assertions.assertThat((String)ocCopy.getOID()).isEqualTo((Object)"1.1.1.43");
        Assertions.assertThat((String)ocCopy.getDescription()).isEqualTo((Object)"Object class to duplicate");
        Assertions.assertThat((boolean)ocCopy.isObsolete()).isTrue();
        Assertions.assertThat((List)ocCopy.getNames()).containsOnly(new Object[]{"DuplicatedOC", "Copy"});
        this.assertSchemaElementsContainsAll((Set<? extends AbstractSchemaElement>)ocCopy.getSuperiorClasses(), "top");
        this.assertSchemaElementsContainsAll((Set<? extends AbstractSchemaElement>)ocCopy.getRequiredAttributes(), "name");
        Assertions.assertThat((Collection)ocCopy.getOptionalAttributes()).isEmpty();
        Assertions.assertThat((Object)ocCopy.getObjectClassType()).isEqualTo((Object)ObjectClassType.STRUCTURAL);
        Assertions.assertThat((Map)ocCopy.getExtraProperties()).isEmpty();
    }

    @Test(expectedExceptions={ConflictingSchemaElementException.class})
    public void testOCBuilderDoesNotAllowOverwrite() throws Exception {
        ObjectClass.Builder ocBuilder = new SchemaBuilder(Schema.getCoreSchema()).buildObjectClass("2.5.6.9").description("MyObjectClass description").names(new String[]{"groupOfFirstNames"}).requiredAttributes(new String[]{"cn"}).type(ObjectClassType.AUXILIARY).extraProperties("New extra property", new String[]{"New extra value"});
        ocBuilder.addToSchema().toSchema();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testOCBuilderDoesNotAllowEmptyOID() throws Exception {
        ObjectClass.Builder ocBuilder = new SchemaBuilder(Schema.getCoreSchema()).buildObjectClass("").description("MyObjectClass description").names(new String[]{"MyObjectClass"}).requiredAttributes(new String[]{"cn"}).extraProperties("New extra property", new String[]{"New extra value"});
        ocBuilder.addToSchema().toSchema();
    }

    private void assertSchemaElementsContainsAll(Set<? extends AbstractSchemaElement> elements, Set<String> namesOrOIDs) throws Exception {
        this.assertSchemaElementsContainsAll(elements, namesOrOIDs.toArray(new String[namesOrOIDs.size()]));
    }

    private void assertSchemaElementsContainsAll(Set<? extends AbstractSchemaElement> elements, String ... namesOrOIDs) throws Exception {
        for (String nameOrOID : namesOrOIDs) {
            Assertions.assertThat((boolean)this.assertSchemaElementsContains(elements, nameOrOID)).isTrue();
        }
    }

    private boolean assertSchemaElementsContains(Set<? extends AbstractSchemaElement> elements, String nameOrOID) {
        for (AbstractSchemaElement abstractSchemaElement : elements) {
            String oid = abstractSchemaElement instanceof AttributeType ? ((AttributeType)abstractSchemaElement).getNameOrOID() : ((ObjectClass)abstractSchemaElement).getNameOrOID();
            if (!oid.equals(nameOrOID)) continue;
            return true;
        }
        return false;
    }
}

