/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.NameForm;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.testng.annotations.Test;

public class NameFormTestCase
extends AbstractSchemaTestCase {
    @Test
    public final void testCreatesANewFormWithOnlyRequiredParameters() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.35").structuralObjectClassOID("person").requiredAttributes(new String[]{"sn", "cn"}).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((int)schema.getNameForms().size()).isGreaterThan(0);
        for (NameForm nf : schema.getNameForms()) {
            Assertions.assertThat((boolean)nf.hasName("hasAName ?")).isFalse();
            Assertions.assertThat((String)nf.getNameOrOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.35");
            Assertions.assertThat((String)nf.getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.35");
            Assertions.assertThat((String)nf.toString()).isEqualTo((Object)"( 1.3.6.1.4.1.1466.115.121.1.35 OC person MUST ( sn $ cn ) )");
        }
    }

    @Test
    public final void testCreatesANewFormWithAName() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.35").structuralObjectClassOID("person").names(new String[]{"MyNewForm"}).requiredAttributes(new String[]{"sn", "cn"}).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((int)schema.getNameForms().size()).isGreaterThan(0);
        for (NameForm nf : schema.getNameForms()) {
            Assertions.assertThat((boolean)nf.hasName("hasAName ?")).isFalse();
            Assertions.assertThat((String)nf.getNameOrOID()).isEqualTo((Object)"MyNewForm");
            Assertions.assertThat((String)nf.getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.35");
            Assertions.assertThat((String)nf.toString()).isEqualTo((Object)"( 1.3.6.1.4.1.1466.115.121.1.35 NAME 'MyNewForm' OC person MUST ( sn $ cn ) )");
        }
    }

    @Test
    public final void testCreatesANewFormWithOptionalAttributesOid() {
        SchemaBuilder sb = new SchemaBuilder();
        sb.addSchema(Schema.getCoreSchema(), false);
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.35").structuralObjectClassOID("person").names(new String[]{"MyNewForm"}).requiredAttributes(new String[]{"sn", "cn"}).optionalAttributes(new String[]{"owner"}).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((int)schema.getNameForms().size()).isGreaterThan(0);
        for (NameForm nf : schema.getNameForms()) {
            Assertions.assertThat((boolean)nf.hasName("hasAName ?")).isFalse();
            Assertions.assertThat((String)nf.getNameOrOID()).isEqualTo((Object)"MyNewForm");
            Assertions.assertThat((String)nf.getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.35");
            Assertions.assertThat((String)nf.getOptionalAttributes().toString()).contains("owner");
            Assertions.assertThat((String)nf.toString()).isEqualTo((Object)"( 1.3.6.1.4.1.1466.115.121.1.35 NAME 'MyNewForm' OC person MUST ( sn $ cn ) MAY owner )");
        }
    }

    @Test
    public final void testCreatesANewNameFormWithExtraProperties() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.35").structuralObjectClassOID("person").names(new String[]{"MyNewForm"}).requiredAttributes(new String[]{"sn", "cn"}).optionalAttributes(new String[]{"owner"}).extraProperties("X-ORIGIN", new String[]{"RFC xxx"}).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((int)schema.getNameForms().size()).isGreaterThan(0);
        for (NameForm nf : schema.getNameForms()) {
            Assertions.assertThat((boolean)nf.hasName("hasAName ?")).isFalse();
            Assertions.assertThat((String)nf.getNameOrOID()).isEqualTo((Object)"MyNewForm");
            Assertions.assertThat((String)nf.getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.35");
            Assertions.assertThat((String)((String)((List)nf.getExtraProperties().get("X-ORIGIN")).get(0))).isEqualTo((Object)"RFC xxx");
            Assertions.assertThat((String)nf.toString()).isEqualTo((Object)"( 1.3.6.1.4.1.1466.115.121.1.35 NAME 'MyNewForm' OC person MUST ( sn $ cn ) MAY owner X-ORIGIN 'RFC xxx' )");
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public final void testBuilderDoesntAllowNullOid() {
        new SchemaBuilder(Schema.getCoreSchema()).buildNameForm((String)null).description("This is a description").names(new String[]{"name1"}).names(new String[]{"name2", "name3"}).extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).structuralObjectClassOID("person").requiredAttributes(new String[]{"sn, cn"}).addToSchema().toSchema();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public final void testBuilderDoesntAllowNullStructuralClassOid() {
        new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.35").description("This is a description").names(new String[]{"MyNewForm"}).extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).requiredAttributes(new String[]{"sn, cn"}).addToSchema().toSchema();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public final void testBuilderDoesntAllowEmptyRequiredAttributes() {
        new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.35").description("This is a description").names(new String[]{"MyNewForm"}).structuralObjectClassOID("person").extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).requiredAttributes(new String[0]).addToSchema().toSchema();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public final void testBuilderDoesntAllowNullRequiredAttributes() {
        new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.35").description("This is a description").names(new String[]{"MyNewForm"}).structuralObjectClassOID("person").extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).addToSchema().toSchema();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testBuilderDoesntAllowNullOptionalAttributes() {
        new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.35").description("This is a description").names(new String[]{"MyNewForm"}).extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).structuralObjectClassOID("person").requiredAttributes(new String[]{"sn, cn"}).requiredAttributes((String[])null).addToSchema().toSchema();
    }

    @Test
    public final void testBuilderAllowsEmptyOptionalAttributes() {
        new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.35").description("This is a description").names(new String[]{"MyNewForm"}).structuralObjectClassOID("person").extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).requiredAttributes(new String[]{"sn", "cn"}).addToSchema().toSchema();
    }

    @Test
    public final void testBuilderAllowRemovingNonexistentAttributes() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.35").description("This is a description").names(new String[]{"MyNewForm"}).extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).structuralObjectClassOID("person").requiredAttributes(new String[]{"sn"}).removeRequiredAttribute("unknown").removeOptionalAttribute("optionalunknown").addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Collection)schema.getNameForms()).isNotEmpty();
        NameForm nf = (NameForm)schema.getNameForms().iterator().next();
        Assertions.assertThat((String)nf.getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.35");
        Assertions.assertThat((int)nf.getRequiredAttributes().size()).isEqualTo(1);
        Assertions.assertThat((String)((AttributeType)nf.getRequiredAttributes().iterator().next()).getNameOrOID()).isEqualTo((Object)"sn");
        Assertions.assertThat((Collection)nf.getOptionalAttributes()).isEmpty();
    }

    @Test
    public final void testNameFormDefinition() {
        SchemaBuilder sb = new SchemaBuilder();
        sb.addSchema(Schema.getCoreSchema(), false);
        String nameFormDefinition = "( 1.3.6.1.4.1.1466.115.121.1.35 NAME 'MyNewForm' DESC 'Description of the new form' OC person MUST ( sn $ cn ) MAY ( description $ uid ) X-SCHEMA-FILE 'NameFormCheckingTestCase' X-ORIGIN 'NameFormCheckingTestCase' )";
        sb.addNameForm("( 1.3.6.1.4.1.1466.115.121.1.35 NAME 'MyNewForm' DESC 'Description of the new form' OC person MUST ( sn $ cn ) MAY ( description $ uid ) X-SCHEMA-FILE 'NameFormCheckingTestCase' X-ORIGIN 'NameFormCheckingTestCase' )", false);
        Schema schema = sb.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Collection)schema.getNameForms()).isNotEmpty();
        NameForm nf = (NameForm)schema.getNameForms().iterator().next();
        Assertions.assertThat((String)nf.getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.35");
        Assertions.assertThat((Map)nf.getExtraProperties()).isNotEmpty();
        Assertions.assertThat((String)nf.toString()).isEqualTo((Object)"( 1.3.6.1.4.1.1466.115.121.1.35 NAME 'MyNewForm' DESC 'Description of the new form' OC person MUST ( sn $ cn ) MAY ( description $ uid ) X-SCHEMA-FILE 'NameFormCheckingTestCase' X-ORIGIN 'NameFormCheckingTestCase' )");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public final void testNameFormDefinitionDoesntAllowMissingAttributes() {
        SchemaBuilder sb = new SchemaBuilder();
        sb.addSchema(Schema.getCoreSchema(), false);
        String nameFormDefinition = "( 1.3.6.1.4.1.1466.115.121.1.35 NAME 'MyNewForm' DESC 'Description of the new form' OC person MAY ( description $ uid ) X-SCHEMA-FILE 'NameFormCheckingTestCase' X-ORIGIN 'EntrySchemaCheckingTestCase' X-ORIGIN 'NameFormCheckingTestCase' )";
        sb.addNameForm("( 1.3.6.1.4.1.1466.115.121.1.35 NAME 'MyNewForm' DESC 'Description of the new form' OC person MAY ( description $ uid ) X-SCHEMA-FILE 'NameFormCheckingTestCase' X-ORIGIN 'EntrySchemaCheckingTestCase' X-ORIGIN 'NameFormCheckingTestCase' )", false);
        Schema schema = sb.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
    }

    @Test
    public final void testDuplicatesTheNameForm() {
        SchemaBuilder sb = new SchemaBuilder();
        sb.addSchema(Schema.getCoreSchema(), false);
        NameForm.Builder nfb = new NameForm.Builder("1.3.6.1.4.1.1466.115.121.1.35", sb);
        nfb.description("Description of the new form").names(new String[]{"MyNewForm"}).structuralObjectClassOID("person").extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).requiredAttributes(new String[]{"sn", "cn"}).optionalAttributes(new String[]{"description", "uid"}).addToSchema();
        Schema schema = sb.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Collection)schema.getNameForms()).isNotEmpty();
        NameForm nf = (NameForm)schema.getNameForms().iterator().next();
        Assertions.assertThat((String)nf.getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.35");
        sb.buildNameForm(nf).removeAllNames().names(new String[]{"Dolly"}).oid("1.3.6.1.4.1.1466.115.121.1.36").addToSchemaOverwrite();
        schema = sb.toSchema();
        Assertions.assertThat((Collection)schema.getNameForms()).isNotEmpty();
        Assertions.assertThat((int)schema.getNameForms().size()).isEqualTo(2);
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Iterator i = schema.getNameForms().iterator();
        i.next();
        NameForm dolly = (NameForm)i.next();
        Assertions.assertThat((String)dolly.getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.36");
        Assertions.assertThat((int)dolly.getNames().size()).isEqualTo(1);
    }

    @Test
    public final void testDuplicatesTheNameFormFails() {
        SchemaBuilder sb = new SchemaBuilder();
        sb.addSchema(Schema.getCoreSchema(), false);
        NameForm.Builder nfb = new NameForm.Builder("1.3.6.1.4.1.1466.115.121.1.35", sb);
        nfb.description("Description of the new form").names(new String[]{"MyNewForm"}).structuralObjectClassOID("person").extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).requiredAttributes(new String[]{"sn", "cn"}).optionalAttributes(new String[]{"description", "uid"}).addToSchema();
        Schema schema = sb.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Collection)schema.getNameForms()).isNotEmpty();
        NameForm nf = (NameForm)schema.getNameForms().iterator().next();
        Assertions.assertThat((String)nf.getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.35");
        sb.buildNameForm(nf).names(new String[]{"Dolly"}).oid("1.3.6.1.4.1.1466.115.121.1.36").structuralObjectClassOID("wrongStructuralOID").addToSchemaOverwrite();
        schema = sb.toSchema();
        Assertions.assertThat((int)schema.getNameForms().size()).isEqualTo(1);
        Assertions.assertThat((Collection)schema.getWarnings()).isNotEmpty();
    }

    @Test
    public final void testNameFormEqualsTrue() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.35").description("Description of the new form").names(new String[]{"MyNewForm"}).names(new String[]{"TheNewForm"}).structuralObjectClassOID("person").extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).requiredAttributes(new String[]{"sn", "cn"}).optionalAttributes(new String[]{"description", "uid"}).addToSchema().toSchema();
        NameForm nf1 = (NameForm)schema.getNameForms().iterator().next();
        Schema schema2 = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.35").names(new String[]{"MyNewForm"}).structuralObjectClassOID("person").requiredAttributes(new String[]{"sn", "cn"}).addToSchema().toSchema();
        NameForm nf2 = schema2.getNameForm("MyNewForm");
        Assertions.assertThat((boolean)nf1.equals((Object)nf2)).isTrue();
    }

    @Test
    public final void testNameFormEqualsFalse() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.35").description("Description of the new form").names(new String[]{"MyNewForm"}).names(new String[]{"TheNewForm"}).structuralObjectClassOID("person").extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).requiredAttributes(new String[]{"sn", "cn"}).optionalAttributes(new String[]{"description", "uid"}).addToSchema().toSchema();
        NameForm nf1 = (NameForm)schema.getNameForms().iterator().next();
        Schema schema2 = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.36").description("Description of the new form").names(new String[]{"MyNewForm"}).names(new String[]{"TheNewForm"}).structuralObjectClassOID("person").extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).requiredAttributes(new String[]{"sn", "cn"}).optionalAttributes(new String[]{"description", "uid"}).addToSchema().toSchema();
        Assertions.assertThat((boolean)nf1.equals(schema2.getNameForms().iterator().next())).isFalse();
    }

    @Test
    public final void testCreateFormUsingDefinitionAndSchemaBuilder() {
        SchemaBuilder sb = new SchemaBuilder();
        sb.addSchema(Schema.getCoreSchema(), false).addObjectClass("( mycustomobjectclass-oid NAME 'myCustomObjectClassOC' SUP top STRUCTURAL MUST cn X-ORIGIN 'NameFormTestCase')", false).addNameForm("( mycustomnameform-oid NAME 'myCustomNameForm' OC myCustomObjectClassOC MUST cn X-ORIGIN 'NameFormTestCase' )", false).toSchema();
        Schema schema = sb.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Object)schema.getNameForm("mycustomnameform")).isNotNull();
        for (NameForm o : schema.getNameForms()) {
            Assertions.assertThat((String)o.getNameOrOID()).isEqualTo((Object)"myCustomNameForm");
            Assertions.assertThat((String)o.getOID()).isEqualTo((Object)"mycustomnameform-oid");
            Assertions.assertThat((String)o.getStructuralClass().getOID()).isEqualTo((Object)"mycustomobjectclass-oid");
        }
    }

    @Test
    public final void testNameFormEqualityReturnsTrueBetweenBuilderAndDefinition() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.35").description("Description of the new form").names(new String[]{"MyNewForm"}).structuralObjectClassOID("person").extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).requiredAttributes(new String[]{"sn", "cn"}).optionalAttributes(new String[]{"description", "uid"}).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        NameForm nf1 = (NameForm)schema.getNameForms().iterator().next();
        SchemaBuilder sb2 = new SchemaBuilder();
        sb2.addSchema(Schema.getCoreSchema(), false);
        sb2.addNameForm("( 1.3.6.1.4.1.1466.115.121.1.35 NAME ( 'MyNewForm' ) DESC 'Description of the new form' OC person MUST ( sn $ cn ) MAY ( description $ uid ) X-ORIGIN 'NameFormCheckingTestCase' )", false);
        NameForm nf2 = sb2.toSchema().getNameForm("MyNewForm");
        Assertions.assertThat((boolean)nf1.equals((Object)nf2)).isTrue();
    }

    @Test
    public final void testNameFormEqualityReturnsFalseBetweenBuilderAndDefinition() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.35").description("Description of the new form").names(new String[]{"MyNewForm"}).structuralObjectClassOID("person").extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).requiredAttributes(new String[]{"sn", "cn"}).optionalAttributes(new String[]{"description", "uid"}).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        NameForm nf1 = (NameForm)schema.getNameForms().iterator().next();
        SchemaBuilder sb2 = new SchemaBuilder();
        sb2.addSchema(Schema.getCoreSchema(), false);
        sb2.addNameForm("( 1.3.6.1.4.1.1466.115.121.1.36 NAME ( 'MyNewForm' ) DESC 'Description of the new form' OC person MUST ( sn $ cn ) MAY ( description $ uid ) X-ORIGIN 'NameFormCheckingTestCase' )", false);
        NameForm nf2 = sb2.toSchema().getNameForm("MyNewForm");
        Assertions.assertThat((boolean)nf1.equals((Object)nf2)).isFalse();
    }

    @Test
    public final void testNameFormValidateDoesntAllowAbstractObjectClass() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("mynewform-oid").description("Description of the new form").names(new String[]{"MyNewForm"}).structuralObjectClassOID("top").extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).requiredAttributes(new String[]{"sn", "cn"}).optionalAttributes(new String[]{"description", "uid"}).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getNameForms()).isEmpty();
        Assertions.assertThat((Collection)schema.getWarnings()).isNotEmpty();
        Assertions.assertThat((String)schema.getWarnings().toString()).contains("This object class exists in the schema but is defined as ABSTRACT rather than structural");
    }

    @Test
    public final void testNameFormValidateAllowsStructuralObjectClass() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("mynewform-oid").description("Description of the new form").names(new String[]{"MyNewForm"}).structuralObjectClassOID("person").extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).requiredAttributes(new String[]{"sn", "cn"}).optionalAttributes(new String[]{"description", "uid"}).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getNameForms()).isNotEmpty();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((String)((NameForm)schema.getNameForms().iterator().next()).getOID()).isEqualTo((Object)"mynewform-oid");
        Assertions.assertThat((String)((String)((NameForm)schema.getNameForms().iterator().next()).getNames().get(0))).isEqualTo((Object)"MyNewForm");
    }

    @Test
    public final void testBuildsANewFormWithMultipleAttributes() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("0.0.1.2.3").description("multipleAttributes Test description").names(new String[]{"multipleAttributes"}).structuralObjectClassOID("person").extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase2"}).requiredAttributes(new String[]{"sn", "cn"}).requiredAttributes(new String[]{"uid"}).optionalAttributes(new String[]{"owner"}).optionalAttributes(new String[]{"l"}).names(new String[]{"Rock"}).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Collection)schema.getNameForms()).isNotEmpty();
        for (NameForm nf : schema.getNameForms()) {
            Assertions.assertThat((String)nf.getDescription()).isEqualTo((Object)"multipleAttributes Test description");
            Assertions.assertThat((String)nf.getOID()).isEqualTo((Object)"0.0.1.2.3");
            Assertions.assertThat((String)((String)nf.getNames().get(0))).isEqualTo((Object)"multipleAttributes");
            Assertions.assertThat((String)((String)nf.getNames().get(1))).isEqualTo((Object)"Rock");
            Assertions.assertThat((String)((String)((List)nf.getExtraProperties().get("X-ORIGIN")).get(0))).isEqualTo((Object)"NameFormCheckingTestCase");
            Assertions.assertThat((String)((String)((List)nf.getExtraProperties().get("X-ORIGIN")).get(1))).isEqualTo((Object)"NameFormCheckingTestCase2");
            Assertions.assertThat((String)nf.getStructuralClass().getNameOrOID()).isEqualTo((Object)"person");
            for (AttributeType att : nf.getRequiredAttributes()) {
                Assertions.assertThat((String)att.getNameOrOID()).isIn(new Object[]{"cn", "sn", "uid"});
            }
            for (AttributeType att : nf.getOptionalAttributes()) {
                Assertions.assertThat((String)att.getNameOrOID()).isIn(new Object[]{"owner", "l"});
            }
        }
    }

    @Test
    public final void testCreatesANewFormUsingChainingMethods() {
        TreeMap extraProperties = new TreeMap();
        ArrayList<String> extra = new ArrayList<String>();
        extra.add("EntrySchemaCheckingTestCase");
        extraProperties.put("X-ORIGIN", extra);
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.2.3").description("NF1's description").names(new String[]{"theFirstNameForm"}).structuralObjectClassOID("person").extraProperties(extraProperties).requiredAttributes(new String[]{"uid"}).optionalAttributes(new String[]{"sn"}).addToSchemaOverwrite().buildNameForm("4.4.4").description("NF2's description").names(new String[]{"theSecondNameForm"}).structuralObjectClassOID("person").extraProperties(extraProperties).requiredAttributes(new String[]{"uid"}).requiredAttributes(new String[]{"sn"}).addToSchemaOverwrite().toSchema();
        NameForm first = schema.getNameForm("theFirstNameForm");
        Assertions.assertThat((String)first.getOID()).isEqualTo((Object)"1.2.3");
        Assertions.assertThat((String)first.getDescription()).isEqualTo((Object)"NF1's description");
        Assertions.assertThat((Collection)first.getRequiredAttributes()).isNotEmpty();
        Assertions.assertThat((Collection)first.getOptionalAttributes()).isNotEmpty();
        Assertions.assertThat((String)first.getStructuralClass().getNameOrOID()).isEqualTo((Object)"person");
        NameForm second = schema.getNameForm("theSecondNameForm");
        Assertions.assertThat((String)second.getOID()).isEqualTo((Object)"4.4.4");
        Assertions.assertThat((String)second.getDescription()).isEqualTo((Object)"NF2's description");
        Assertions.assertThat((Collection)second.getRequiredAttributes()).isNotEmpty();
        Assertions.assertThat((Collection)second.getOptionalAttributes()).isEmpty();
    }

    @Test
    public final void testCreatesNewFormAndRemovesAttributes() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("0.0.1.2.3").description("multipleAttributes Test description").structuralObjectClassOID("person").extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase"}).extraProperties("X-ORIGIN", new String[]{"NameFormCheckingTestCase2"}).requiredAttributes(new String[]{"sn", "cn"}).requiredAttributes(new String[]{"uid"}).optionalAttributes(new String[]{"givenName"}).optionalAttributes(new String[]{"l"}).names(new String[]{"nameform1"}).names(new String[]{"nameform2"}).names(new String[]{"nameform3"}).removeName("nameform2").removeRequiredAttribute("cn").removeOptionalAttribute("l").addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getNameForms()).isNotEmpty();
        NameForm nf = (NameForm)schema.getNameForms().iterator().next();
        Assertions.assertThat((List)nf.getNames()).hasSize(2);
        Assertions.assertThat((List)nf.getNames()).contains(new Object[]{"nameform1"});
        Assertions.assertThat((List)nf.getNames()).contains(new Object[]{"nameform3"});
        Assertions.assertThat((int)nf.getRequiredAttributes().size()).isEqualTo(2);
        Assertions.assertThat((String)nf.getRequiredAttributes().toString()).contains("'sn'");
        Assertions.assertThat((String)nf.getRequiredAttributes().toString()).contains("uid");
        Assertions.assertThat((int)nf.getOptionalAttributes().size()).isEqualTo(1);
    }

    @Test
    public final void testDuplicatesNameFormAndRemovesAttributes() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.35").description("Description of the new form").names(new String[]{"MyNewForm"}).structuralObjectClassOID("person").extraProperties("X-ORIGIN", new String[]{"NameFormTestCase", "Forgerock", "extra"}).extraProperties("FROM", new String[]{"NameFormTestCase"}).requiredAttributes(new String[]{"sn", "cn"}).optionalAttributes(new String[]{"description", "uid"}).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Collection)schema.getNameForms()).isNotEmpty();
        NameForm nf = (NameForm)schema.getNameForms().iterator().next();
        Assertions.assertThat((String)nf.getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.35");
        Assertions.assertThat((int)nf.getRequiredAttributes().size()).isEqualTo(2);
        Assertions.assertThat((int)nf.getOptionalAttributes().size()).isEqualTo(2);
        SchemaBuilder sb = new SchemaBuilder(Schema.getCoreSchema());
        NameForm.Builder nfBuilder = new NameForm.Builder(nf, sb).removeAllNames().names(new String[]{"MyCopiedNewForm", "Dolly"}).oid("1.3.6.1.4.1.1466.115.121.1.36").removeOptionalAttribute("uid").removeOptionalAttribute("nonExistentUid").requiredAttributes(new String[]{"street"}).removeRequiredAttribute("sn").removeExtraProperty("X-ORIGIN", new String[]{"extra"}).removeExtraProperty("X-ORIGIN", new String[]{"Forgerock"}).removeExtraProperty("FROM", new String[0]);
        sb.addSchema(schema, true);
        sb.addSchema(nfBuilder.addToSchemaOverwrite().toSchema(), true);
        Schema finalSchema = sb.toSchema();
        Assertions.assertThat((Collection)finalSchema.getNameForms()).isNotEmpty();
        Assertions.assertThat((int)finalSchema.getNameForms().size()).isEqualTo(2);
        Assertions.assertThat((Collection)finalSchema.getWarnings()).isEmpty();
        Iterator i = finalSchema.getNameForms().iterator();
        i.next();
        NameForm dolly = (NameForm)i.next();
        Assertions.assertThat((String)dolly.getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.36");
        Assertions.assertThat((int)dolly.getRequiredAttributes().size()).isEqualTo(2);
        Assertions.assertThat((String)dolly.getRequiredAttributes().toString()).contains("street");
        Assertions.assertThat((String)dolly.getRequiredAttributes().toString()).contains("cn");
        Assertions.assertThat((int)dolly.getOptionalAttributes().size()).isEqualTo(1);
        Assertions.assertThat((int)((List)dolly.getExtraProperties().get("X-ORIGIN")).size()).isEqualTo(1);
        Assertions.assertThat((List)((List)dolly.getExtraProperties().get("FROM"))).isNull();
    }

    @Test
    public final void testDuplicatesNameFormAndClears() {
        SchemaBuilder sb = new SchemaBuilder();
        sb.addSchema(Schema.getCoreSchema(), false);
        NameForm.Builder nfb = new NameForm.Builder("1.3.6.1.4.1.1466.115.121.1.35", sb);
        nfb.description("Description of the new form").names(new String[]{"MyNewForm"}).structuralObjectClassOID("person").extraProperties("X-ORIGIN", new String[]{"NameFormTestCase", "Forgerock", "extra"}).extraProperties("FROM", new String[]{"NameFormTestCase"}).requiredAttributes(new String[]{"sn", "cn"}).optionalAttributes(new String[]{"description", "uid"}).addToSchema();
        Schema schema = sb.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Collection)schema.getNameForms()).isNotEmpty();
        NameForm nf = (NameForm)schema.getNameForms().iterator().next();
        Assertions.assertThat((String)nf.getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.35");
        Assertions.assertThat((Collection)nf.getRequiredAttributes()).hasSize(2);
        Assertions.assertThat((Collection)nf.getOptionalAttributes()).hasSize(2);
        Assertions.assertThat((Map)nf.getExtraProperties()).hasSize(2);
        sb.buildNameForm(nf).removeAllNames().names(new String[]{"Dolly"}).removeName("thisOneDoesntExist").oid("1.3.6.1.4.1.1466.115.121.1.36").removeAllOptionalAttributes().removeAllExtraProperties().removeAllRequiredAttributes().requiredAttributes(new String[]{"businessCategory"}).addToSchemaOverwrite();
        schema = sb.toSchema();
        Assertions.assertThat((Collection)schema.getNameForms()).isNotEmpty();
        Assertions.assertThat((int)schema.getNameForms().size()).isEqualTo(2);
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Iterator i = schema.getNameForms().iterator();
        i.next();
        NameForm dolly = (NameForm)i.next();
        Assertions.assertThat((String)dolly.getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.36");
        Assertions.assertThat((int)dolly.getNames().size()).isEqualTo(1);
        Assertions.assertThat((String)((String)dolly.getNames().get(0))).isEqualTo((Object)"Dolly");
        Assertions.assertThat((int)dolly.getRequiredAttributes().size()).isEqualTo(1);
        Assertions.assertThat((String)((AttributeType)dolly.getRequiredAttributes().iterator().next()).getOID()).isEqualTo((Object)"2.5.4.15");
        Assertions.assertThat((String)((AttributeType)dolly.getRequiredAttributes().iterator().next()).getNameOrOID()).isEqualTo((Object)"businessCategory");
        Assertions.assertThat((Collection)dolly.getOptionalAttributes()).isEmpty();
        Assertions.assertThat((Map)dolly.getExtraProperties()).isEmpty();
    }

    @Test
    public final void testAddsSeveralFormsToSchemaBuilder() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildNameForm("1.3.6.1.4.1.1466.115.121.1.35").description("Description of the new form").names(new String[]{"MyNewForm"}).structuralObjectClassOID("person").extraProperties("X-ORIGIN", new String[]{"NameFormTestCase", "Forgerock", "extra"}).requiredAttributes(new String[]{"sn", "cn"}).optionalAttributes(new String[]{"description", "uid"}).addToSchema().buildNameForm("1.3.6.1.4.1.1466.115.121.1.36").description("Description of the second form").names(new String[]{"SecondForm"}).structuralObjectClassOID("organization").extraProperties("X-ORIGIN", new String[]{"NameFormTestCase2"}).requiredAttributes(new String[]{"name"}).optionalAttributes(new String[]{"owner"}).addToSchema().buildNameForm("1.3.6.1.4.1.1466.115.121.1.37").description("Description of the third form").names(new String[]{"ThirdForm"}).structuralObjectClassOID("groupOfNames").extraProperties("X-ORIGIN", new String[]{"NameFormTestCase3", "ForgeRock"}).requiredAttributes(new String[]{"sn", "l"}).optionalAttributes(new String[]{"description", "uid"}).description("Description of the third form").addToSchema().buildNameForm("1.3.6.1.4.1.1466.115.121.1.37").names(new String[]{"ThirdFormOverwritten"}).structuralObjectClassOID("groupOfNames").extraProperties("X-ORIGIN", new String[]{"RFC 2252"}).requiredAttributes(new String[]{"sn", "l"}).optionalAttributes(new String[]{"description", "uid"}).addToSchemaOverwrite().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((int)schema.getNameForms().size()).isEqualTo(3);
        Assertions.assertThat((String)schema.getNameForm("MyNewForm").getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.35");
        Assertions.assertThat((String)schema.getNameForm("SecondForm").getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.36");
        Assertions.assertThat((String)schema.getNameForm("ThirdFormOverwritten").getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.37");
        Assertions.assertThat((String)schema.getNameForm("ThirdFormOverwritten").getDescription()).isEmpty();
        Assertions.assertThat((String)((String)((List)schema.getNameForm("ThirdFormOverwritten").getExtraProperties().get("X-ORIGIN")).get(0))).isEqualTo((Object)"RFC 2252");
    }
}

