/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.fest.assertions.MapAssert;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.ConflictingSchemaElementException;
import org.forgerock.opendj.ldap.schema.MatchingRuleUse;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.testng.annotations.Test;

public class MatchingRuleUseBuilderTestCase
extends AbstractSchemaTestCase {
    @Test
    public void testValidMatchingRuleUse() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRuleUse("2.5.13.5").names(new String[]{"Matching rule use test"}).description("Matching rule use description").attributes(new String[]{"2.5.4.40", "2.5.4.52", "2.5.4.53"}).extraProperties("property name", new String[]{"property value"}).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        MatchingRuleUse mru = schema.getMatchingRuleUse("2.5.13.5");
        Assertions.assertThat((Object)mru).isNotNull();
        Assertions.assertThat((String)mru.getMatchingRuleOID()).isEqualTo((Object)"2.5.13.5");
        Assertions.assertThat((List)mru.getNames()).containsOnly(new Object[]{"Matching rule use test"});
        Assertions.assertThat((String)mru.getDescription()).isEqualTo((Object)"Matching rule use description");
        Assertions.assertThat((Collection)mru.getAttributes()).containsOnly(new Object[]{schema.getAttributeType("2.5.4.40"), schema.getAttributeType("2.5.4.52"), schema.getAttributeType("2.5.4.53")});
        Assertions.assertThat((Map)mru.getExtraProperties()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"property name", Collections.singletonList("property value"))});
        Assertions.assertThat((boolean)mru.isObsolete()).isFalse();
    }

    @Test
    public void testCopyConstructor() {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRuleUse("2.5.13.16").description("Matching rule use description").names(new String[]{"Matching rule use test"}).attributes(new String[]{"2.5.4.40"}).extraProperties("property name", new String[]{"property value"}).addToSchema();
        Schema schema = builder.toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Schema schemaCopy = builder.buildMatchingRuleUse(schema.getMatchingRuleUse("2.5.13.16")).oid("2.5.13.17").removeAllNames().names(new String[]{"Matching rule use test copy"}).attributes(new String[]{"2.5.4.53"}).addToSchema().toSchema();
        Assertions.assertThat((Collection)schemaCopy.getWarnings()).isEmpty();
        MatchingRuleUse mru = schemaCopy.getMatchingRuleUse("2.5.13.17");
        Assertions.assertThat((Object)mru).isNotNull();
        Assertions.assertThat((String)mru.getMatchingRuleOID()).isEqualTo((Object)"2.5.13.17");
        Assertions.assertThat((List)mru.getNames()).containsOnly(new Object[]{"Matching rule use test copy"});
        Assertions.assertThat((String)mru.getDescription()).isEqualTo((Object)"Matching rule use description");
        Assertions.assertThat((Collection)mru.getAttributes()).containsOnly(new Object[]{schema.getAttributeType("2.5.4.40"), schema.getAttributeType("2.5.4.53")});
        Assertions.assertThat((Map)mru.getExtraProperties()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"property name", Collections.singletonList("property value"))});
        Assertions.assertThat((boolean)mru.isObsolete()).isFalse();
    }

    @Test(expectedExceptions={ConflictingSchemaElementException.class})
    public void testBuilderDoesNotAllowOverwrite() throws Exception {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRuleUse("2.5.13.16").names(new String[]{"Matching rule use test"}).attributes(new String[]{"2.5.4.40"}).addToSchema();
        builder.buildMatchingRuleUse("2.5.13.16").addToSchema().toSchema();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testBuilderDoesNotAllowNullMatchingRuleOID() throws Exception {
        new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRuleUse((String)null).addToSchema();
    }

    @Test
    public void testBuilderRemoveAll() throws Exception {
        MatchingRuleUse.Builder builder = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRuleUse("2.5.13.16").description("Matching rule use description").names(new String[]{"Matching rule use test"}).attributes(new String[]{"2.5.4.40", "2.5.4.52"}).extraProperties("property name", new String[]{"property value"});
        Schema schema = builder.removeAllNames().removeAllAttributes().removeAllExtraProperties().addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        MatchingRuleUse mru = schema.getMatchingRuleUse("2.5.13.16");
        Assertions.assertThat((List)mru.getNames()).isEmpty();
        Assertions.assertThat((Collection)mru.getAttributes()).isEmpty();
        Assertions.assertThat((Map)mru.getExtraProperties()).isEmpty();
    }

    @Test
    public void testBuilderRemove() throws Exception {
        MatchingRuleUse.Builder builder = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRuleUse("2.5.13.17").description("Matching rule use description").names(new String[]{"Matching rule use test", "I should not be in the schema"}).attributes(new String[]{"2.5.4.52", "I should not be in the schema"}).extraProperties("property name", new String[]{"property value"});
        Schema schema = builder.removeName("I should not be in the schema").removeAttribute("I should not be in the schema").removeExtraProperty("property name", new String[0]).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        MatchingRuleUse mru = schema.getMatchingRuleUse("2.5.13.17");
        Assertions.assertThat((List)mru.getNames()).containsOnly(new Object[]{"Matching rule use test"});
        Assertions.assertThat((Collection)mru.getAttributes()).containsOnly(new Object[]{schema.getAttributeType("2.5.4.52")});
        Assertions.assertThat((Map)mru.getExtraProperties()).isEmpty();
    }
}

