/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.assertj.core.api.Assertions;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.AuthPasswordExactEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.BooleanEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.DirectoryStringFirstComponentEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.testng.annotations.Test;

public class MatchingRuleTestCase
extends AbstractSchemaTestCase {
    @Test
    public final void testCreatesBasicMatchingRule() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"ExampleMatch"}).description("An example of matching rule").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchema().toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        MatchingRule mr = schema.getMatchingRule("ExampleMatch");
        Assertions.assertThat((Object)mr).isNotNull();
        Assertions.assertThat((String)mr.getOID()).isEqualTo((Object)"1.1.4.1");
        Assertions.assertThat((String)mr.getSyntax().getDescription()).isEqualTo((Object)"Directory String");
        Assertions.assertThat((String)mr.getDescription()).isEqualTo((Object)"An example of matching rule");
        Assertions.assertThat((String)mr.getSyntax().getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.15");
        Assertions.assertThat((boolean)mr.getExtraProperties().containsKey("New extra propertie")).isFalse();
        Assertions.assertThat((boolean)mr.getExtraProperties().containsKey("LDAP Schema Update Procedures")).isTrue();
        Assertions.assertThat((boolean)mr.isObsolete()).isFalse();
    }

    @Test
    public final void testCreatesOverrideBasicMatchingRule() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.3.6.1.4.1.4203.1.2.2").names(Collections.singletonList("authPasswordExactMatch")).description("authentication password exact matching rule").syntaxOID("1.3.6.1.4.1.4203.1.1.2").extraProperties("New extra propertie", new String[0]).implementation((MatchingRuleImpl)new AuthPasswordExactEqualityMatchingRuleImpl()).addToSchemaOverwrite().toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        MatchingRule mr = schema.getMatchingRule("1.3.6.1.4.1.4203.1.2.2");
        Assertions.assertThat((boolean)mr.getExtraProperties().containsKey("New extra propertie")).isTrue();
        Assertions.assertThat((boolean)mr.isObsolete()).isFalse();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public final void testBuilderDoesntAllowEmptyOid() {
        new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("").names(new String[]{"ExampleMatch"}).description("An example of matching rule").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchemaOverwrite().toSchema();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public final void testBuilderDoesntAllowNullOid() {
        new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule((String)null).names(new String[]{"ExampleMatch"}).description("An example of matching rule").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchemaOverwrite().toSchema();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public final void testBuilderDoesntAllowNullSyntax() {
        new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"ExampleMatch"}).description("An example of matching rule").extraProperties("LDAP Schema Update Procedures", new String[0]).implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchemaOverwrite().toSchema();
    }

    @Test
    public final void testBuilderAllowsEmptyName() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").description("An example of matching rule").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchema().toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        MatchingRule mr = schema.getMatchingRule("1.1.4.1");
        Assertions.assertThat((Object)mr).isNotNull();
        Assertions.assertThat((String)mr.getOID()).isEqualTo((Object)"1.1.4.1");
        Assertions.assertThat((String)mr.getSyntax().getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.15");
        Assertions.assertThat((boolean)mr.getExtraProperties().containsKey("New extra propertie")).isFalse();
        Assertions.assertThat((boolean)mr.getExtraProperties().containsKey("LDAP Schema Update Procedures")).isTrue();
        Assertions.assertThat((int)mr.getNames().size()).isEqualTo(0);
        Assertions.assertThat((String)mr.getNameOrOID()).isEqualTo((Object)"1.1.4.1");
    }

    @Test
    public final void testBuilderAllowsMultipleNames() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"my new matching rule"}).names(new String[]{"maching rule test"}).names(new String[]{"exampleMatch"}).description("An example of matching rule").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchema().toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        MatchingRule mr = schema.getMatchingRule("1.1.4.1");
        Assertions.assertThat((Object)mr).isNotNull();
        Assertions.assertThat((String)mr.getOID()).isEqualTo((Object)"1.1.4.1");
        Assertions.assertThat((String)mr.getSyntax().getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.15");
        Assertions.assertThat((boolean)mr.getExtraProperties().containsKey("New extra propertie")).isFalse();
        Assertions.assertThat((boolean)mr.getExtraProperties().containsKey("LDAP Schema Update Procedures")).isTrue();
        Assertions.assertThat((int)mr.getNames().size()).isEqualTo(3);
        Assertions.assertThat((boolean)mr.hasName("my new matching rule")).isTrue();
        Assertions.assertThat((boolean)mr.hasName("maching rule test")).isTrue();
        Assertions.assertThat((boolean)mr.hasName("exampleMatch")).isTrue();
    }

    @Test
    public final void testBuilderRemoveNames() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"my new matching rule"}).names(new String[]{"maching rule test"}).names(new String[]{"exampleMatch"}).removeAllNames().description("An example of matching rule").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchema().toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        MatchingRule mr = schema.getMatchingRule("1.1.4.1");
        Assertions.assertThat((Object)mr).isNotNull();
        Assertions.assertThat((String)mr.getOID()).isEqualTo((Object)"1.1.4.1");
        Assertions.assertThat((String)mr.getSyntax().getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.15");
        Assertions.assertThat((boolean)mr.getExtraProperties().containsKey("New extra propertie")).isFalse();
        Assertions.assertThat((boolean)mr.getExtraProperties().containsKey("LDAP Schema Update Procedures")).isTrue();
        Assertions.assertThat((int)mr.getNames().size()).isEqualTo(0);
        Assertions.assertThat((String)mr.getNameOrOID()).isEqualTo((Object)"1.1.4.1");
    }

    @Test
    public final void testBuilderRemoveSelectedName() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"my new matching rule"}).names(new String[]{"maching rule test"}).names(new String[]{"exampleMatch"}).removeName("maching rule test").description("An example of matching rule").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchema().toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        MatchingRule mr = schema.getMatchingRule("1.1.4.1");
        Assertions.assertThat((Object)mr).isNotNull();
        Assertions.assertThat((String)mr.getOID()).isEqualTo((Object)"1.1.4.1");
        Assertions.assertThat((String)mr.getSyntax().getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.15");
        Assertions.assertThat((boolean)mr.getExtraProperties().containsKey("New extra propertie")).isFalse();
        Assertions.assertThat((boolean)mr.getExtraProperties().containsKey("LDAP Schema Update Procedures")).isTrue();
        Assertions.assertThat((int)mr.getNames().size()).isEqualTo(2);
        Assertions.assertThat((boolean)mr.hasName("my new matching rule")).isTrue();
        Assertions.assertThat((boolean)mr.hasName("exampleMatch")).isTrue();
    }

    @Test
    public final void testBuilderAllowsNoDescription() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"ExampleMatch"}).syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchemaOverwrite().toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        MatchingRule mr = schema.getMatchingRule("ExampleMatch");
        Assertions.assertThat((Object)mr).isNotNull();
        Assertions.assertThat((String)mr.getOID()).isEqualTo((Object)"1.1.4.1");
        Assertions.assertThat((String)mr.getDescription()).isEmpty();
        Assertions.assertThat((String)mr.getDescription()).isEqualTo((Object)"");
        Assertions.assertThat((String)mr.getSyntax().getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.15");
        Assertions.assertThat((boolean)mr.getExtraProperties().containsKey("New extra propertie")).isFalse();
        Assertions.assertThat((boolean)mr.getExtraProperties().containsKey("LDAP Schema Update Procedures")).isTrue();
    }

    @Test
    public final void testBuilderAllowsEmptyDescription() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"ExampleMatch"}).description("").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchemaOverwrite().toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        MatchingRule mr = schema.getMatchingRule("ExampleMatch");
        Assertions.assertThat((Object)mr).isNotNull();
        Assertions.assertThat((String)mr.getOID()).isEqualTo((Object)"1.1.4.1");
        Assertions.assertThat((String)mr.getDescription()).isEmpty();
        Assertions.assertThat((String)mr.getSyntax().getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.15");
        Assertions.assertThat((boolean)mr.getExtraProperties().containsKey("New extra propertie")).isFalse();
        Assertions.assertThat((boolean)mr.getExtraProperties().containsKey("LDAP Schema Update Procedures")).isTrue();
    }

    @Test
    public final void testBuilderAllowsNoExtraProperties() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"ExampleMatch"}).description("Example match description").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchemaOverwrite().toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        MatchingRule mr = schema.getMatchingRule("ExampleMatch");
        Assertions.assertThat((Object)mr).isNotNull();
        Assertions.assertThat((String)mr.getOID()).isEqualTo((Object)"1.1.4.1");
        Assertions.assertThat((String)mr.getDescription()).isEqualTo((Object)"Example match description");
        Assertions.assertThat((String)mr.getSyntax().getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.15");
        Assertions.assertThat((Map)mr.getExtraProperties()).isEmpty();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public final void testBuilderDoesntAllowNullExtraProperties() {
        new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"ExampleMatch"}).description("Example match description").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties(null).implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchemaOverwrite().toSchema();
    }

    @Test
    public final void testBuilderRemoveExtraProperties() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"exampleMatch"}).description("An example of matching rule").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).removeAllExtraProperties().implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchema().toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        MatchingRule mr = schema.getMatchingRule("1.1.4.1");
        Assertions.assertThat((Object)mr).isNotNull();
        Assertions.assertThat((String)mr.getOID()).isEqualTo((Object)"1.1.4.1");
        Assertions.assertThat((String)mr.getSyntax().getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.15");
        Assertions.assertThat((Map)mr.getExtraProperties()).isEmpty();
        Assertions.assertThat((int)mr.getNames().size()).isEqualTo(1);
        Assertions.assertThat((String)((String)mr.getNames().get(0))).isEqualTo((Object)"exampleMatch");
    }

    @Test
    public final void testBuilderAllowsNoImplementation() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"ExampleMatch"}).description("Example match description").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).addToSchemaOverwrite().toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isNotEmpty();
        Assertions.assertThat((boolean)schema.getWarnings().contains("The default matching rule \"2.5.13.17\" will be used instead"));
        MatchingRule mr = schema.getMatchingRule("ExampleMatch");
        Assertions.assertThat((Object)mr).isNotNull();
        Assertions.assertThat((String)mr.getOID()).isEqualTo((Object)"1.1.4.1");
        Assertions.assertThat((String)mr.getDescription()).isEqualTo((Object)"Example match description");
        Assertions.assertThat((String)mr.getSyntax().getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.15");
    }

    @Test
    public final void testBuilderAllowsNullImplementation() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"ExampleMatch"}).description("Example match description").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).implementation(null).addToSchemaOverwrite().toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isNotEmpty();
        Assertions.assertThat((boolean)schema.getWarnings().toString().contains("The default matching rule \"2.5.13.17\" will be used instead")).isTrue();
        MatchingRule mr = schema.getMatchingRule("ExampleMatch");
        Assertions.assertThat((Object)mr).isNotNull();
        Assertions.assertThat((String)mr.getOID()).isEqualTo((Object)"1.1.4.1");
        Assertions.assertThat((String)mr.getDescription()).isEqualTo((Object)"Example match description");
        Assertions.assertThat((String)mr.getSyntax().getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.15");
    }

    @Test
    public final void testAddingAMatchingRuleDefinitionStringNoOverride() {
        SchemaBuilder sb = new SchemaBuilder();
        sb.addSchema(Schema.getCoreSchema(), false);
        String definition = "( 1.1.4.1 NAME 'ExampleMatch' DESC 'An example of Matching Rule' SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 )";
        sb.addMatchingRule("( 1.1.4.1 NAME 'ExampleMatch' DESC 'An example of Matching Rule' SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 )", false);
        Schema schema = sb.toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isNotEmpty();
        Assertions.assertThat((boolean)schema.getWarnings().toString().contains("The default matching rule \"2.5.13.17\" will be used instead")).isTrue();
        Assertions.assertThat((Iterable)schema.getMatchingRules()).isNotEmpty();
        MatchingRule mr = schema.getMatchingRule("ExampleMatch");
        Assertions.assertThat((String)mr.getOID()).isEqualTo((Object)"1.1.4.1");
        Assertions.assertThat((String)mr.toString()).isEqualTo((Object)"( 1.1.4.1 NAME 'ExampleMatch' DESC 'An example of Matching Rule' SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 )");
        Assertions.assertThat((boolean)mr.isObsolete()).isFalse();
    }

    @Test
    public final void testAddingAMatchingRuleDefinitionStringOverride() {
        SchemaBuilder sb = new SchemaBuilder();
        sb.addSchema(Schema.getCoreSchema(), false);
        String definition = "( 2.5.13.0 NAME 'objectIdentifierMatch' OBSOLETE SYNTAX 1.3.6.1.4.1.1466.115.121.1.38 )";
        sb.addMatchingRule("( 2.5.13.0 NAME 'objectIdentifierMatch' OBSOLETE SYNTAX 1.3.6.1.4.1.1466.115.121.1.38 )", true);
        Schema schema = sb.toSchema();
        for (LocalizableMessage warning : schema.getWarnings()) {
            Assertions.assertThat((String)warning.toString()).contains(new CharSequence[]{"OBSOLETE"});
        }
        Assertions.assertThat((Iterable)schema.getMatchingRules()).isNotEmpty();
        MatchingRule mr = schema.getMatchingRule("objectIdentifierMatch");
        Assertions.assertThat((String)mr.getOID()).isEqualTo((Object)"2.5.13.0");
        Assertions.assertThat((String)mr.toString()).isEqualTo((Object)"( 2.5.13.0 NAME 'objectIdentifierMatch' OBSOLETE SYNTAX 1.3.6.1.4.1.1466.115.121.1.38 )");
        Assertions.assertThat((boolean)mr.isObsolete()).isTrue();
    }

    @Test
    public final void testDuplicatesExistingMatchingRule() {
        SchemaBuilder sb = new SchemaBuilder();
        sb.addSchema(Schema.getCoreSchema(), false);
        MatchingRule.Builder nfb = new MatchingRule.Builder("1.1.4.1", sb);
        nfb.description("This is a new matching rule").names(new String[]{"ExampleMatch"}).description("An example of matching rule").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).extraProperties("X-ORIGIN", new String[]{"NO RFC"}).implementation((MatchingRuleImpl)new BooleanEqualityMatchingRuleImpl()).addToSchemaOverwrite();
        Schema schema = sb.toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        MatchingRule mr = schema.getMatchingRule("ExampleMatch");
        Assertions.assertThat((String)mr.getOID()).isEqualTo((Object)"1.1.4.1");
        sb.buildMatchingRule(mr).removeAllNames().names(new String[]{"Dolly"}).oid("2.5.13.0.1").obsolete(true).addToSchemaOverwrite();
        schema = sb.toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        MatchingRule dolly = schema.getMatchingRule("Dolly");
        Assertions.assertThat((String)dolly.getOID()).isEqualTo((Object)"2.5.13.0.1");
        Assertions.assertThat((String)dolly.getSyntax().getDescription()).isEqualTo((Object)"Directory String");
        Assertions.assertThat((String)dolly.getDescription()).isEqualTo((Object)"An example of matching rule");
        Assertions.assertThat((String)dolly.getSyntax().getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.15");
        Assertions.assertThat((boolean)dolly.getExtraProperties().containsKey("New extra propertie")).isFalse();
        Assertions.assertThat((boolean)dolly.getExtraProperties().containsKey("LDAP Schema Update Procedures")).isTrue();
        Assertions.assertThat((boolean)dolly.getExtraProperties().containsKey("X-ORIGIN")).isTrue();
        Assertions.assertThat((boolean)dolly.isObsolete()).isTrue();
    }

    @Test
    public final void testMatchingRuleEqualsTrue() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"ExampleMatch"}).description("An example of matching rule").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchema().toSchema();
        MatchingRule mr1 = schema.getMatchingRule("ExampleMatch");
        Schema schema2 = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"Second"}).description("A second example of matching rule").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchema().toSchema();
        MatchingRule mr2 = schema2.getMatchingRule("Second");
        Assertions.assertThat((boolean)mr2.equals((Object)mr1)).isTrue();
    }

    @Test
    public final void testMatchingRuleEqualsFalse() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"ExampleMatch"}).description("An example of matching rule").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchema().toSchema();
        MatchingRule mr1 = schema.getMatchingRule("ExampleMatch");
        Schema schema2 = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.2").names(new String[]{"Second"}).description("A second example of matching rule").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchema().toSchema();
        MatchingRule mr2 = schema2.getMatchingRule("Second");
        Assertions.assertThat((boolean)mr2.equals((Object)mr1)).isFalse();
    }

    @Test
    public final void testVerifyMatchingRuleDefinition() {
        SchemaBuilder sb = new SchemaBuilder();
        sb.addSchema(Schema.getCoreSchema(), false);
        MatchingRule.Builder nfb = new MatchingRule.Builder("1.1.4.1", sb);
        nfb.description("This is a new matching rule").names(new String[]{"ExampleMatch"}).names(new String[]{"MyExampleMatch"}).description("An example of matching rule").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[]{"RFC 2252"}).extraProperties("X-ORIGIN", new String[]{"NONE"}).obsolete(true).implementation((MatchingRuleImpl)new BooleanEqualityMatchingRuleImpl()).addToSchemaOverwrite();
        Schema schema = sb.toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        String definition = "( 1.1.4.1 NAME ( 'ExampleMatch' 'MyExampleMatch' ) DESC 'An example of matching rule' OBSOLETE SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 LDAP Schema Update Procedures 'RFC 2252' X-ORIGIN 'NONE' )";
        MatchingRule mr = schema.getMatchingRule("ExampleMatch");
        Assertions.assertThat((String)mr.toString()).isEqualTo((Object)"( 1.1.4.1 NAME ( 'ExampleMatch' 'MyExampleMatch' ) DESC 'An example of matching rule' OBSOLETE SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 LDAP Schema Update Procedures 'RFC 2252' X-ORIGIN 'NONE' )");
    }

    @Test
    public final void testMatchingRuleEqualityReturnsTrueBetweenBuilderAndDefinition() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"ExampleMatch"}).description("An example of matching rule").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchema().toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        MatchingRule mr1 = schema.getMatchingRule("ExampleMatch");
        SchemaBuilder sb2 = new SchemaBuilder();
        sb2.addSchema(Schema.getCoreSchema(), false);
        String definition = "( 1.1.4.1 NAME 'ExampleMatch2' DESC 'An example of Matching Rule' SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 )";
        sb2.addMatchingRule("( 1.1.4.1 NAME 'ExampleMatch2' DESC 'An example of Matching Rule' SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 )", false);
        MatchingRule mr2 = sb2.toSchema().getMatchingRule("ExampleMatch2");
        Assertions.assertThat((boolean)mr1.equals((Object)mr2)).isTrue();
    }

    @Test
    public final void testMatchingRuleEqualityReturnsTrueBetweenBuilderAndDefinitionFails() {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"ExampleMatch"}).description("An example of matching rule").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties("LDAP Schema Update Procedures", new String[0]).implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchema().toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        MatchingRule mr1 = schema.getMatchingRule("ExampleMatch");
        SchemaBuilder sb2 = new SchemaBuilder();
        sb2.addSchema(Schema.getCoreSchema(), false);
        String definition = "( 1.1.4.2 NAME 'ExampleMatch2' DESC 'An example of Matching Rule' SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 )";
        sb2.addMatchingRule("( 1.1.4.2 NAME 'ExampleMatch2' DESC 'An example of Matching Rule' SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 )", false);
        MatchingRule mr2 = sb2.toSchema().getMatchingRule("ExampleMatch2");
        Assertions.assertThat((boolean)mr1.equals((Object)mr2)).isFalse();
    }

    @Test
    public final void testCreatesMatchingRulesUsingChainingMethods() {
        TreeMap extraProperties = new TreeMap();
        ArrayList<String> extra = new ArrayList<String>();
        extra.add("Custom");
        extraProperties.put("X-ORIGIN", extra);
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildMatchingRule("1.1.4.1").names(new String[]{"ExampleMatch"}).description("An example of matching rule").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").implementation((MatchingRuleImpl)new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).extraProperties(extraProperties).addToSchema().buildMatchingRule("1.1.4.9999").names(new String[]{"SecondExampleMatch"}).description("Another example of matching rule").extraProperties(extraProperties).syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").implementation((MatchingRuleImpl)new BooleanEqualityMatchingRuleImpl()).addToSchema().toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        MatchingRule mr1 = schema.getMatchingRule("ExampleMatch");
        Assertions.assertThat((String)mr1.getOID()).isEqualTo((Object)"1.1.4.1");
        Assertions.assertThat((String)mr1.getDescription()).isEqualTo((Object)"An example of matching rule");
        MatchingRule mr2 = schema.getMatchingRule("SecondExampleMatch");
        Assertions.assertThat((String)mr2.getOID()).isEqualTo((Object)"1.1.4.9999");
        Assertions.assertThat((String)mr2.getDescription()).isEqualTo((Object)"Another example of matching rule");
        Assertions.assertThat((Map)mr1.getExtraProperties()).isEqualTo((Object)mr2.getExtraProperties());
    }
}

