/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class MatchingRuleTest
extends AbstractSchemaTestCase {
    @DataProvider(name="matchingRuleInvalidAssertionValues")
    public Object[][] createMatchingRuleInvalidAssertionValues() {
        return this.createMatchingRuleInvalidAttributeValues();
    }

    @DataProvider(name="matchingRuleInvalidAttributeValues")
    public abstract Object[][] createMatchingRuleInvalidAttributeValues();

    @DataProvider(name="matchingrules")
    public abstract Object[][] createMatchingRuleTest();

    @Test(dataProvider="matchingrules")
    public void matchingRules(String value1, String value2, ConditionResult result) throws Exception {
        MatchingRule rule = this.getRule();
        ByteString normalizedValue1 = rule.normalizeAttributeValue((ByteSequence)ByteString.valueOfUtf8((CharSequence)value1));
        Assertion assertion = rule.getAssertion((ByteSequence)ByteString.valueOfUtf8((CharSequence)value2));
        ConditionResult liveResult = assertion.matches((ByteSequence)normalizedValue1);
        Assert.assertEquals((Object)liveResult, (Object)result);
    }

    @Test(expectedExceptions={DecodeException.class}, dataProvider="matchingRuleInvalidAssertionValues")
    public void matchingRulesInvalidAssertionValues(String value) throws Exception {
        MatchingRule rule = this.getRule();
        rule.getAssertion((ByteSequence)ByteString.valueOfUtf8((CharSequence)value));
    }

    @Test(expectedExceptions={DecodeException.class}, dataProvider="matchingRuleInvalidAttributeValues")
    public void matchingRulesInvalidAttributeValues(String value) throws Exception {
        MatchingRule rule = this.getRule();
        rule.normalizeAttributeValue((ByteSequence)ByteString.valueOfUtf8((CharSequence)value));
    }

    protected abstract MatchingRule getRule();
}

