/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class JPEGSyntaxTest
extends AbstractSchemaTestCase {
    @DataProvider(name="acceptableValues")
    public Object[][] createAcceptableValues() {
        String nonImage = "AAECAwQFBgcICQ==";
        String jfifImage = "/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDACMYGh4aFiMeHB4nJSMpNFc4NDAwNGpMUD9Xfm+EgnxveneLnMipi5S9lnd6ru2wvc7V4OLgh6f1//PZ/8jb4Nf/2wBDASUnJzQuNGY4OGbXj3qP19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19f/wAARCAABAAEDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwCCiiiuM9g//9k=";
        String exifImage = "/9j/4QD2RXhpZgAATU0AKgAAAAgACQESAAMAAAABAAEAAAEaAAUAAAABAAAAegEbAAUAAAABAAAAggEoAAMAAAABAAIAAAExAAIAAAAQAAAAigEyAAIAAAAUAAAAmgE8AAIAAAAOAAAArgITAAMAAAABAAEAAIdpAAQAAAABAAAAvAAAAAAASAAAAAEAAABIAAAAAQAAUXVpY2tUaW1lIDcuNy4xADIwMTI6MDg6MjAgMTI6MTE6MTIATWFjIE9TIFggMTAuOAAAApAAAAcAAAAEMDIyMJADAAIAAAAUAAAA2gAAAAAyMDEyOjA4OjIwIDEyOjEwOjA2AP/+AAxBcHBsZU1hcmsK/9sAQwAjGBoeGhYjHhweJyUjKTRXODQwMDRqTFA/V35vhIJ8b3p3i5zIqYuUvZZ3eq7tsL3O1eDi4Ien9f/z2f/I2+DX/9sAQwElJyc0LjRmODhm1496j9fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX19fX/8AAEQgAAQABAwEiAAIRAQMRAf/EAB8AAAEFAQEBAQEBAAAAAAAAAAABAgMEBQYHCAkKC//EALUQAAIBAwMCBAMFBQQEAAABfQECAwAEEQUSITFBBhNRYQcicRQygZGhCCNCscEVUtHwJDNicoIJChYXGBkaJSYnKCkqNDU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6g4SFhoeIiYqSk5SVlpeYmZqio6Slpqeoqaqys7S1tre4ubrCw8TFxsfIycrS09TV1tfY2drh4uPk5ebn6Onq8fLz9PX29/j5+v/EAB8BAAMBAQEBAQEBAQEAAAAAAAABAgMEBQYHCAkKC//EALURAAIBAgQEAwQHBQQEAAECdwABAgMRBAUhMQYSQVEHYXETIjKBCBRCkaGxwQkjM1LwFWJy0QoWJDThJfEXGBkaJicoKSo1Njc4OTpDREVGR0hJSlNUVVZXWFlaY2RlZmdoaWpzdHV2d3h5eoKDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uLj5OXm5+jp6vLz9PX29/j5+v/aAAwDAQACEQMRAD8AgooorjPYP//Z";
        String pngImage = "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAMAAAAoyzS7AAAABlBMVEX/JgAAAAAPIsinAAAACklEQVQImWNgAAAAAgAB9HFkpgAAAABJRU5ErkJggg==";
        return new Object[][]{{ByteString.valueOfBase64((String)nonImage), false}, {ByteString.valueOfBase64((String)jfifImage), true}, {ByteString.valueOfBase64((String)exifImage), true}, {ByteString.valueOfBase64((String)pngImage), false}};
    }

    @Test(dataProvider="acceptableValues")
    public void testAcceptableValues(ByteString value, boolean expectedResult) {
        Syntax syntax = this.getSyntax(false);
        LocalizableMessageBuilder reason = new LocalizableMessageBuilder();
        boolean result = syntax.valueIsAcceptable((ByteSequence)value, reason);
        Assert.assertEquals((boolean)result, (boolean)expectedResult, (String)(syntax + ".valueIsAcceptable gave bad result for " + value + "reason : " + reason));
    }

    @Test(dataProvider="acceptableValues")
    public void testAcceptableValuesWhenAllowingMalformedJPEG(ByteString value, boolean notUsedForThisTest) {
        Syntax syntax = this.getSyntax(true);
        LocalizableMessageBuilder reason = new LocalizableMessageBuilder();
        boolean liveResult = syntax.valueIsAcceptable((ByteSequence)value, reason);
        Assert.assertTrue((boolean)liveResult, (String)(syntax + ".valueIsAcceptable gave bad result for " + value + "reason : " + reason));
    }

    private Syntax getSyntax(boolean allowMalformedJpegPhotos) {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema()).setOption(SchemaOptions.ALLOW_MALFORMED_JPEG_PHOTOS, (Object)allowMalformedJpegPhotos);
        return builder.toSchema().getSyntax("1.3.6.1.4.1.1466.115.121.1.28");
    }
}

