/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.schema.IntegerOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.OrderingMatchingRuleTest;
import org.forgerock.opendj.ldap.schema.Schema;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class IntegerOrderingMatchingRuleTest
extends OrderingMatchingRuleTest {
    @Override
    @DataProvider(name="OrderingMatchingRuleInvalidValues")
    public Object[][] createOrderingMatchingRuleInvalidValues() {
        return new Object[][]{{"1-2"}, {"b2"}, {"-"}, {""}, {" 63 "}, {"- 63"}, {"AB"}, {"0xAB"}};
    }

    @Override
    @DataProvider(name="Orderingmatchingrules")
    public Object[][] createOrderingMatchingRuleTestData() {
        return new Object[][]{{"1", "0", 1}, {"1", "1", 0}, {"45", "54", -1}, {"-63", "63", -1}, {"-63", "0", -1}, {"63", "0", 1}, {"0", "-63", 1}, {"-987654321987654321987654321", "-987654321987654321987654322", 1}, {"987654321987654321987654321", "987654321987654321987654322", -1}, {"987654321987654321987654321", "987654321987654321987654321", 0}, {"-987654321987654321987654321", "-1", -1}, {"-987654321987654321987654321", "1", -1}, {"987654321987654321987654321", "-1", 1}, {"987654321987654321987654321", "1", 1}, {"-1", "-987654321987654321987654321", 1}, {"1", "-987654321987654321987654321", 1}, {"-1", "987654321987654321987654322", -1}, {"1", "987654321987654321987654322", -1}};
    }

    @Override
    protected MatchingRule getRule() {
        return Schema.getCoreSchema().getMatchingRule("2.5.13.15");
    }

    private int length(int i) {
        return i;
    }

    private String expected(int ... bytes) {
        ByteStringBuilder builder = new ByteStringBuilder();
        for (int b : bytes) {
            builder.appendByte(b);
        }
        return builder.toByteString().toHexString();
    }

    @DataProvider
    private Object[][] headerEncoding() {
        return new Object[][]{{this.length(1), Sign.POSITIVE, this.expected(129)}, {this.length(16) - 1, Sign.POSITIVE, this.expected(143)}, {this.length(16), Sign.POSITIVE, this.expected(144, 16)}, {this.length(4096) - 1, Sign.POSITIVE, this.expected(159, 255)}, {this.length(4096), Sign.POSITIVE, this.expected(160, 16, 0)}, {this.length(0x100000) - 1, Sign.POSITIVE, this.expected(175, 255, 255)}, {this.length(0x100000), Sign.POSITIVE, this.expected(176, 16, 0, 0)}, {this.length(0x10000000) - 1, Sign.POSITIVE, this.expected(191, 255, 255, 255)}, {this.length(0x10000000), Sign.POSITIVE, this.expected(193, 0, 0, 0, 0)}, {this.length(Integer.MIN_VALUE) - 1, Sign.POSITIVE, this.expected(199, 255, 255, 255, 240)}, {this.length(1), Sign.NEGATIVE, this.expected(126)}, {this.length(16) - 1, Sign.NEGATIVE, this.expected(112)}, {this.length(16), Sign.NEGATIVE, this.expected(111, 239)}, {this.length(4096) - 1, Sign.NEGATIVE, this.expected(96, 0)}, {this.length(4096), Sign.NEGATIVE, this.expected(95, 239, 255)}, {this.length(0x100000) - 1, Sign.NEGATIVE, this.expected(80, 0, 0)}, {this.length(0x100000), Sign.NEGATIVE, this.expected(79, 239, 255, 255)}, {this.length(0x10000000) - 1, Sign.NEGATIVE, this.expected(64, 0, 0, 0)}, {this.length(0x10000000), Sign.NEGATIVE, this.expected(62, 255, 255, 255, 255)}, {this.length(Integer.MIN_VALUE) - 1, Sign.NEGATIVE, this.expected(56, 0, 0, 0, 15)}};
    }

    @Test(dataProvider="headerEncoding")
    public void testHeaderEncoding(int length, Sign sign, String expectedHexString) {
        ByteStringBuilder builder = new ByteStringBuilder();
        IntegerOrderingMatchingRuleImpl.encodeHeader((ByteStringBuilder)builder, (int)length, (byte)sign.mask);
        ByteString actual = builder.toByteString();
        Assertions.assertThat((String)actual.toHexString()).isEqualTo((Object)expectedHexString);
    }

    private static enum Sign {
        POSITIVE(0),
        NEGATIVE(-1);

        private final byte mask;

        private Sign(byte mask) {
            this.mask = mask;
        }
    }
}

