/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxTestCase;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class EnumSyntaxTestCase
extends AbstractSyntaxTestCase {
    @Override
    @DataProvider(name="acceptableValues")
    public Object[][] createAcceptableValues() {
        return new Object[][]{{"arbit-day", false}, {"wednesday", true}};
    }

    @Test
    public void testDecode() throws SchemaException, DecodeException {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.addSyntax("( 3.3.3  DESC 'Day Of The Week'  X-ENUM  ( 'monday' 'tuesday'   'wednesday'  'thursday'  'friday'  'saturday' 'sunday') )", true);
        Schema schema = builder.toSchema();
        Syntax syntax = schema.getSyntax("3.3.3");
        MatchingRule rule = syntax.getOrderingMatchingRule();
        ByteString monday = ByteString.valueOfUtf8((CharSequence)"monday");
        ByteString normMonday = rule.normalizeAttributeValue((ByteSequence)monday);
        ByteString tuesday = ByteString.valueOfUtf8((CharSequence)"tuesday");
        ByteString normTuesday = rule.normalizeAttributeValue((ByteSequence)tuesday);
        ByteString normThursday = rule.normalizeAttributeValue((ByteSequence)ByteString.valueOfUtf8((CharSequence)"thursday"));
        Assert.assertEquals((Object)rule.getGreaterOrEqualAssertion((ByteSequence)monday).matches((ByteSequence)normThursday), (Object)ConditionResult.TRUE);
        Assert.assertEquals((Object)rule.getLessOrEqualAssertion((ByteSequence)monday).matches((ByteSequence)normThursday), (Object)ConditionResult.FALSE);
        Assert.assertEquals((Object)rule.getGreaterOrEqualAssertion((ByteSequence)tuesday).matches((ByteSequence)normMonday), (Object)ConditionResult.FALSE);
        Assert.assertEquals((Object)rule.getLessOrEqualAssertion((ByteSequence)tuesday).matches((ByteSequence)normMonday), (Object)ConditionResult.TRUE);
        Assert.assertEquals((Object)rule.getGreaterOrEqualAssertion((ByteSequence)tuesday).matches((ByteSequence)normTuesday), (Object)ConditionResult.TRUE);
        Assert.assertEquals((Object)rule.getLessOrEqualAssertion((ByteSequence)tuesday).matches((ByteSequence)normTuesday), (Object)ConditionResult.TRUE);
        Assert.assertEquals((Object)rule.getAssertion((ByteSequence)tuesday).matches((ByteSequence)normMonday), (Object)ConditionResult.TRUE);
        Assert.assertEquals((Object)rule.getAssertion((ByteSequence)monday).matches((ByteSequence)normThursday), (Object)ConditionResult.FALSE);
        Assert.assertEquals((Object)rule.getAssertion((ByteSequence)tuesday).matches((ByteSequence)normTuesday), (Object)ConditionResult.FALSE);
        Assert.assertNotNull((Object)schema.getMatchingRule("1.3.6.1.4.1.26027.1.4.8.3.3.3"));
    }

    @Test
    public void testDuplicateEnum() throws SchemaException, DecodeException {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.addSyntax("( 3.3.3  DESC 'Day Of The Week'  X-ENUM  ( 'monday' 'tuesday'   'wednesday'  'thursday'  'friday'  'saturday' 'monday') )", true);
        builder.toSchema();
    }

    @Override
    protected Syntax getRule() throws SchemaException, DecodeException {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.addEnumerationSyntax("3.3.3", "Day Of The Week", false, new String[]{"monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"});
        return builder.toSchema().getSyntax("3.3.3");
    }
}

