/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.LinkedList;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaValidationPolicy;
import org.forgerock.opendj.ldif.LDIFEntryReader;
import org.testng.annotations.Test;

@Test
public class EntrySchemaCheckingTestCase
extends AbstractSchemaTestCase {
    @Test
    public void testAllowAttributeAllowedByDCR() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testallowatallowedbydcroc-oid NAME 'testAllowATAllowedByDCROC' SUP top STRUCTURAL MUST cn X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addDITContentRule("( testallowatallowedbydcroc-oid NAME 'testAllowATAllowedByDCR' MAY description X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=test,o=test", "objectClass: top", "objectClass: testAllowATAllowedByDCROC", "cn: test", "description: foo");
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testAllowAttributeRequiredByDCR() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testallowatrequiredbydcroc-oid NAME 'testAllowATRequiredByDCROC' SUP top STRUCTURAL MUST cn X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addDITContentRule("( testallowatrequiredbydcroc-oid NAME 'testAllowATRequiredByDCR' MUST description X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=test,o=test", "objectClass: top", "objectClass: testAllowATRequiredByDCROC", "cn: test", "description: foo");
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testAuxiliaryClassAllowedByDCR() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testauxiliaryclassallowedbydcroc-oid NAME 'testAuxiliaryClassAllowedByDCROC' SUP top STRUCTURAL MUST cn X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addObjectClass("( testauxiliaryclassallowedbydcrocaux-oid NAME 'testAuxiliaryClassAllowedByDCROCAux' SUP top AUXILIARY MAY description X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addDITContentRule("( testauxiliaryclassallowedbydcroc-oid NAME 'testAuxiliaryClassAllowedByDCR' AUX testAuxiliaryClassAllowedByDCROCAux X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=test,o=test", "objectClass: top", "objectClass: testAuxiliaryClassAllowedByDCROC", "objectClass: testAuxiliaryClassAllowedByDCROCAux", "cn: test");
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testAuxiliaryClassNotAllowedByDCR() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testauxiliaryclassnotallowedbydcroc-oid NAME 'testAuxiliaryClassNotAllowedByDCROC' SUP top STRUCTURAL MUST cn X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addObjectClass("( testauxiliaryclassnotallowedbydcrocaux-oid NAME 'testAuxiliaryClassNotAllowedByDCROCAux' SUP top AUXILIARY MAY description X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addDITContentRule("( testauxiliaryclassnotallowedbydcroc-oid NAME 'testAuxiliaryClassNotAllowedByDCR' X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=test,o=test", "objectClass: top", "objectClass: testAuxiliaryClassNotAllowedByDCROC", "objectClass: testAuxiliaryClassNotAllowedByDCROCAux", "cn: test");
        this.assertDoesNotConformToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
        e.removeAttribute("objectClass", new Object[]{"testAuxiliaryClassNotAllowedByDCROCAux"});
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testDisallowedAttributeType() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testdisallowedattributetypeoc-oid NAME 'testDisallowedAttributeTypeOC' SUP top STRUCTURAL MUST cn X-ORIGIN 'EntrySchemaCheckingTestCase')", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=test,o=test", "objectClass: top", "objectClass: testDisallowedAttributeTypeOC", "cn: test", "description: foo");
        this.assertDoesNotConformToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
        e.removeAttribute("description", new Object[]{"foo"});
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testDITStructureRuleConstraints() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testditstructureruleconstraintssupoc-oid NAME 'testDITStructureRuleConstraintsSupOC' SUP top STRUCTURAL MUST ou X-ORIGIN 'SchemaBackendTestCase')", false).addObjectClass("( testditstructureruleconstraintssuboc-oid NAME 'testDITStructureRuleConstraintsSubOC' SUP top STRUCTURAL MUST cn X-ORIGIN 'SchemaBackendTestCase')", false).addNameForm("( testditstructureruleconstraintsupsnf-oid NAME 'testDITStructureRuleConstraintsSupNF' OC testDITStructureRuleConstraintsSupOC MUST ou X-ORIGIN 'SchemaBackendTestCase' )", false).addNameForm("( testditstructureruleconstraintsubsnf-oid NAME 'testDITStructureRuleConstraintsSubNF' OC testDITStructureRuleConstraintsSubOC MUST cn X-ORIGIN 'SchemaBackendTestCase' )", false).addDITStructureRule("( 999014 NAME 'testDITStructureRuleConstraintsSup' FORM testDITStructureRuleConstraintsSupNF X-ORIGIN 'SchemaBackendTestCase' )", false).addDITStructureRule("( 999015 NAME 'testDITStructureRuleConstraintsSub' FORM testDITStructureRuleConstraintsSubNF SUP 999014 X-ORIGIN 'SchemaBackendTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=child,ou=parent,o=test", "objectClass: top", "objectClass: testDITStructureRuleConstraintsSubOC", "cn: child");
        this.assertDoesNotConformToSchema(e, schema, SchemaValidationPolicy.defaultPolicy().checkDITStructureRules(SchemaValidationPolicy.Action.REJECT, this.newResolver(null)));
        Entry p = this.newEntry(schema, "dn: ou=parent,o=test", "changetype: add", "objectClass: top", "objectClass: testDITStructureRuleConstraintsSupOC", "ou: parent");
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy().checkDITStructureRules(SchemaValidationPolicy.Action.REJECT, this.newResolver(p)));
        e = this.newEntry(schema, "dn: cn=not below valid parent,o=test", "objectClass: top", "objectClass: testDITStructureRuleConstraintsSubOC", "cn: not below valid parent");
        this.assertDoesNotConformToSchema(e, schema, SchemaValidationPolicy.defaultPolicy().checkDITStructureRules(SchemaValidationPolicy.Action.REJECT, this.newResolver(null)));
        e = this.newEntry(schema, "dn: o=invalid entry below parent covered by DSR,ou=parent,o=test", "objectClass: top", "objectClass: organization", "o: invalid entry below parent covered by DSR");
        this.assertDoesNotConformToSchema(e, schema, SchemaValidationPolicy.defaultPolicy().checkDITStructureRules(SchemaValidationPolicy.Action.REJECT, this.newResolver(p)));
    }

    @Test
    public void testDontAllowAttributeProhibitedByDCR() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testdontallowattributeprohibitedbydcroc-oid NAME 'testDontAllowAttributeProhibitedByDCROC' SUP top STRUCTURAL MUST cn MAY description X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addDITContentRule("( testdontallowattributeprohibitedbydcroc-oid NAME 'testDontAllowAttributeProhibitedByDCR' NOT description X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=test,o=test", "objectClass: top", "objectClass: testDontAllowAttributeProhibitedByDCROC", "cn: test", "description: foo");
        this.assertDoesNotConformToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
        e.removeAttribute("description", new Object[]{"foo"});
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testDontRequireAttributeAllowedByDCR() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testdontrequireatallowedbydcroc-oid NAME 'testDontRequireATAllowedByDCROC' SUP top STRUCTURAL MUST cn X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addDITContentRule("( testdontrequireatallowedbydcroc-oid NAME 'testDontRequireATAllowedByDCR' MAY description X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=test,o=test", "objectClass: top", "objectClass: testDontRequireATAllowedByDCROC", "cn: test");
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testDontRequireAttributeRequiredByObsoleteDCR() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testdontrequireatrequiredbyobsoletedcroc-oid NAME 'testDontRequireATRequiredByObsoleteDCROC' SUP top STRUCTURAL MUST cn X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addDITContentRule("( testdontrequireatrequiredbyobsoletedcroc-oid NAME 'testDontRequireATRequiredByObsoleteDCR' OBSOLETE MUST description X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=test,o=test", "objectClass: top", "objectClass: testDontRequireATRequiredByObsoleteDCROC", "cn: test");
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testInvalidSuperiorAttribute() throws Exception {
        Entry e = this.newEntry("dn: uid=test.user,o=test", "objectClass: top", "objectClass: person", "objectClass: organizationalPerson", "sn: User", "cn: Test User", "name: foo");
        this.assertDoesNotConformToSchema(e, SchemaValidationPolicy.defaultPolicy());
        e.removeAttribute("name", new Object[]{"foo"});
        this.assertConformsToSchema(e, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testMissingAttributeRequiredByAuxiliaryClass() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testmissingatrequiredbyauxiliaryoc-oid NAME 'testMissingATRequiredByAuxiliaryOC' SUP top AUXILIARY MUST ( cn $ description ) X-ORIGIN 'EntrySchemaCheckingTestCase')", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=test,o=test", "objectClass: top", "objectClass: device", "objectClass: testMissingATRequiredByAuxiliaryOC", "cn: test");
        this.assertDoesNotConformToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
        e.addAttribute("description", new Object[]{"xxx"});
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testMissingAttributeRequiredByStructuralClass() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testmissingatrequiredbystructuraloc-oid NAME 'testMissingATRequiredByStructuralOC' SUP top STRUCTURAL MUST ( cn $ description ) X-ORIGIN 'EntrySchemaCheckingTestCase')", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=test,o=test", "objectClass: top", "objectClass: testMissingATRequiredByStructuralOC", "cn: test");
        this.assertDoesNotConformToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
        e.addAttribute("description", new Object[]{"xxx"});
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testMultipleStructuralClasses() throws Exception {
        Entry e = this.newEntry("dn: uid=test.user,o=test", "objectClass: top", "objectClass: person", "objectClass: organization", "o: test", "sn: User", "cn: Test User");
        this.assertDoesNotConformToSchema(e, SchemaValidationPolicy.defaultPolicy());
        e.removeAttribute("objectClass", new Object[]{"organization"});
        e.removeAttribute("o", new Object[]{"test"});
        this.assertConformsToSchema(e, SchemaValidationPolicy.ignoreAll().checkAttributeValues(SchemaValidationPolicy.Action.REJECT));
    }

    @Test
    public void testMultipleValuesForMultiValuedAttribute() throws Exception {
        Entry e = this.newEntry("dn: o=test", "objectClass: top", "objectClass: organization", "o: test", "o: foo");
        this.assertConformsToSchema(e, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testMultipleValuesForSingleValuedAttribute() throws Exception {
        Entry e = this.newEntry("dn: dc=example,dc=com", "objectClass: top", "dc: example", "dc: foo");
        this.assertDoesNotConformToSchema(e, SchemaValidationPolicy.ignoreAll().checkAttributeValues(SchemaValidationPolicy.Action.REJECT));
        e.removeAttribute("dc", new Object[]{"foo"});
        this.assertConformsToSchema(e, SchemaValidationPolicy.ignoreAll().checkAttributeValues(SchemaValidationPolicy.Action.REJECT));
    }

    @Test
    public void testMultipleValuesForSingleValuedOperationalAttribute() throws Exception {
        Entry e = this.newEntry("dn: dc=example,dc=com", "objectClass: top", "objectClass: domain", "dc: example", "creatorsName: cn=Directory Manager", "creatorsName: cn=Another Manager");
        this.assertDoesNotConformToSchema(e, SchemaValidationPolicy.ignoreAll().checkAttributeValues(SchemaValidationPolicy.Action.REJECT));
        e.removeAttribute("creatorsName", new Object[]{"cn=Another Manager"});
        this.assertConformsToSchema(e, SchemaValidationPolicy.ignoreAll().checkAttributeValues(SchemaValidationPolicy.Action.REJECT));
    }

    @Test
    public void testMVSatisfiesOptionalMultiValuedNameForm() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testmvsatisfiesoptionalmultivaluednameformoc-oid NAME 'testMVSatisfiesOptionalMultiValuedNameFormOC' SUP top STRUCTURAL MUST cn MAY description X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addNameForm("( testmvsatisfiesoptionalmultivaluednameform-oid NAME 'testMVSatisfiesOptionalMultiValuedNameForm' OC testMVSatisfiesOptionalMultiValuedNameFormOC MUST cn MAY description X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=test+description=foo,o=test", "objectClass: top", "objectClass: testMVSatisfiesOptionalMultiValuedNameFormOC", "cn: test", "description: foo");
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testMVViolatesSingleValuedNameForm() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testmvviolatessinglevaluednameformoc-oid NAME 'testMVViolatesSingleValuedNameFormOC' SUP top STRUCTURAL MUST cn MAY description X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addNameForm("( testmvviolatessinglevaluednameform-oid NAME 'testMVViolatesSingleValuedNameForm' OC testMVViolatesSingleValuedNameFormOC MUST cn X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=test+description=foo,o=test", "objectClass: top", "objectClass: testMVViolatesSingleValuedNameFormOC", "cn: test", "description: foo");
        this.assertDoesNotConformToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
        e.setName("cn=test,o=test");
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testNoStructuralClass() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( domain-oid NAME 'domain' SUP top STRUCTURAL MUST dc X-ORIGIN 'EntrySchemaCheckingTestCase')", false).toSchema();
        Entry e = this.newEntry(schema, "dn: dc=example,dc=com", "objectClass: top", "objectClass: dcObject", "dc: example");
        this.assertDoesNotConformToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
        e.addAttribute("objectClass", new Object[]{"domain"});
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testRequireAttributeRequiredByDCR() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testrequireatrequiredbydcroc-oid NAME 'testRequireATRequiredByDCROC' SUP top STRUCTURAL MUST cn X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addDITContentRule("( testrequireatrequiredbydcroc-oid NAME 'testRequireATRequiredByDCR' MUST description X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=test,o=test", "objectClass: top", "objectClass: testRequireATRequiredByDCROC", "cn: test");
        this.assertDoesNotConformToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
        e.addAttribute("description", new Object[]{"foo"});
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testSatisfiesRequiredMultiValuedNameForm() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testsatisfiesrequiredmultivaluednameformoc-oid NAME 'testSatisfiesRequiredMultiValuedNameFormOC' SUP top STRUCTURAL MUST cn MAY description X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addNameForm("( testsatisfiesrequiredmultivaluednameform-oid NAME 'testSatisfiesRequiredMultiValuedNameForm' OC testSatisfiesRequiredMultiValuedNameFormOC MUST ( cn $ description ) X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=test+description=foo,o=test", "objectClass: top", "objectClass: testSatisfiesRequiredMultiValuedNameFormOC", "cn: test", "description: foo");
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testSatisfiesSingleValuedNameForm() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testsatisfiessinglevaluednameformoc-oid NAME 'testSatisfiesSingleValuedNameFormOC' SUP top STRUCTURAL MUST cn X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addNameForm("( testsatisfiessinglevaluednameform-oid NAME 'testSatisfiesSingleValuedNameForm' OC testSatisfiesSingleValuedNameFormOC MUST cn X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=test,o=test", "objectClass: top", "objectClass: testSatisfiesSingleValuedNameFormOC", "cn: test");
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testSVSatisfiesOptionalMultiValuedNameForm() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testsvsatisfiesoptionalmultivaluednameformoc-oid NAME 'testSVSatisfiesOptionalMultiValuedNameFormOC' SUP top STRUCTURAL MUST cn MAY description X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addNameForm("( testsvsatisfiesoptionalmultivaluednameform-oid NAME 'testSVSatisfiesOptionalMultiValuedNameForm' OC testSVSatisfiesOptionalMultiValuedNameFormOC MUST cn MAY description X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=test,o=test", "objectClass: top", "objectClass: testSVSatisfiesOptionalMultiValuedNameFormOC", "cn: test", "description: foo");
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testSVViolatesOptionalMultiValuedNameForm() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testsvviolatesoptionalmultivaluednameformoc-oid NAME 'testSVViolatesOptionalMultiValuedNameFormOC' SUP top STRUCTURAL MUST cn MAY description X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addNameForm("( testsvviolatesoptionalmultivaluednameform-oid NAME 'testSVViolatesOptionalMultiValuedNameForm' OC testSVViolatesOptionalMultiValuedNameFormOC MUST cn MAY description X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: description=foo,o=test", "objectClass: top", "objectClass: testSVViolatesOptionalMultiValuedNameFormOC", "cn: test", "description: foo");
        this.assertDoesNotConformToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
        e.setName("cn=test+description=foo,o=test");
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testUndefinedAuxiliaryObjectClass() throws Exception {
        Entry e = this.newEntry("dn: cn=test,o=test", "objectClass: top", "objectClass: person", "objectClass: xxxundefinedauxiliaryxxx", "cn: test", "sn: test");
        this.assertDoesNotConformToSchema(e, SchemaValidationPolicy.defaultPolicy());
        e.removeAttribute("objectClass", new Object[]{"xxxundefinedauxiliaryxxx"});
        this.assertConformsToSchema(e, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testUndefinedStructuralObjectClass() throws Exception {
        Entry e = this.newEntry("dn: cn=test,o=test", "objectClass: top", "objectClass: xxxundefinedstructuralxxx", "o: test");
        this.assertDoesNotConformToSchema(e, SchemaValidationPolicy.defaultPolicy());
        e.removeAttribute("objectClass", new Object[]{"xxxundefinedstructuralxxx"});
        e.addAttribute("objectClass", new Object[]{"organization"});
        this.assertConformsToSchema(e, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testUndefinedObjectClassNoStructural() throws Exception {
        Entry e = this.newEntry("dn: o=test", "objectClass: top", "objectClass: xxxundefinedxxx");
        this.assertDoesNotConformToSchema(e, SchemaValidationPolicy.defaultPolicy().requireSingleStructuralObjectClass(SchemaValidationPolicy.Action.IGNORE));
        e.removeAttribute("objectClass", new Object[]{"xxxundefinedxxx"});
        this.assertConformsToSchema(e, SchemaValidationPolicy.defaultPolicy().requireSingleStructuralObjectClass(SchemaValidationPolicy.Action.IGNORE));
    }

    @Test
    public void testValidSingleStructuralClass() throws Exception {
        Entry e = this.newEntry("dn: dc=example,dc=com", "objectClass: top", "objectClass: organization", "o: example");
        this.assertConformsToSchema(e, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testExtensibleObjectAcceptsAnyAttributeIncludingPlaceholderAttribute() throws Exception {
        Entry e2 = this.newEntry("dn: dc=example,dc=com", "objectClass: top", "objectClass: organization", "objectClass: extensibleObject", "o: example", "telephonenumber: 123456");
        this.assertConformsToSchema(e2, SchemaValidationPolicy.defaultPolicy());
        Entry e = this.newEntry("dn: dc=example,dc=com", "objectClass: top", "objectClass: organization", "objectClass: extensibleObject", "o: example", "dummy: unknown attribute!!");
        this.assertConformsToSchema(e, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testValidSingleStructuralClassAndAuxiliaryClass() throws Exception {
        Entry e = this.newEntry("dn: dc=example,dc=com", "objectClass: top", "objectClass: organization", "objectClass: dcObject", "dc: example", "o: Example Org");
        this.assertConformsToSchema(e, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testViolatesRequiredMultiValuedNameForm() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testviolatesrequiredmultivaluednameformoc-oid NAME 'testViolatesRequiredMultiValuedNameFormOC' SUP top STRUCTURAL MUST cn MAY description X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addNameForm("( testviolatesrequiredmultivaluednameform-oid NAME 'testViolatesRequiredMultiValuedNameForm' OC testViolatesRequiredMultiValuedNameFormOC MUST ( cn $ description ) X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: cn=test,o=test", "objectClass: top", "objectClass: testViolatesRequiredMultiValuedNameFormOC", "cn: test", "description: foo");
        this.assertDoesNotConformToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
        e.setName("cn=test+description=foo,o=test");
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testViolatesSingleValuedNameForm() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testviolatessinglevaluednameformoc-oid NAME 'testViolatesSingleValuedNameFormOC' SUP top STRUCTURAL MUST cn MAY description X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addNameForm("( testviolatessinglevaluednameform-oid NAME 'testViolatesSingleValuedNameForm' OC testViolatesSingleValuedNameFormOC MUST cn X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: description=foo,o=test", "objectClass: top", "objectClass: testViolatesSingleValuedNameFormOC", "cn: test", "description: foo");
        this.assertDoesNotConformToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
        e.setName("cn=test,o=test");
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    @Test
    public void testViolatesSingleValuedObsoleteNameForm() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getDefaultSchema()).addObjectClass("( testviolatessinglevaluedobsoletenameformoc-oid NAME 'testViolatesSingleValuedObsoleteNameFormOC' SUP top STRUCTURAL MUST cn MAY description X-ORIGIN 'EntrySchemaCheckingTestCase')", false).addNameForm("( testviolatessinglevaluedobsoletenameform-oid NAME 'testViolatesSingleValuedObsoleteNameForm' OBSOLETE OC testViolatesSingleValuedObsoleteNameFormOC MUST cn X-ORIGIN 'EntrySchemaCheckingTestCase' )", false).toSchema();
        Entry e = this.newEntry(schema, "dn: description=foo,o=test", "objectClass: top", "objectClass: testViolatesSingleValuedObsoleteNameFormOC", "cn: test", "description: foo");
        this.assertConformsToSchema(e, schema, SchemaValidationPolicy.defaultPolicy());
    }

    private void assertConformsToSchema(Entry entry, Schema schema, SchemaValidationPolicy policy) {
        LinkedList errorMessages = new LinkedList();
        ((BooleanAssert)Assertions.assertThat((boolean)schema.validateEntry(entry, policy, errorMessages)).as(((Object)errorMessages).toString())).isTrue();
    }

    private void assertConformsToSchema(Entry entry, SchemaValidationPolicy policy) {
        this.assertConformsToSchema(entry, Schema.getDefaultSchema(), policy);
    }

    private void assertDoesNotConformToSchema(Entry entry, Schema schema, SchemaValidationPolicy policy) {
        LinkedList errorMessages = new LinkedList();
        ((BooleanAssert)Assertions.assertThat((boolean)schema.validateEntry(entry, policy, errorMessages)).as(((Object)errorMessages).toString())).isFalse();
    }

    private void assertDoesNotConformToSchema(Entry entry, SchemaValidationPolicy policy) {
        this.assertDoesNotConformToSchema(entry, Schema.getDefaultSchema(), policy);
    }

    private Entry newEntry(Schema schema, String ... ldif) {
        try {
            return new LDIFEntryReader(ldif).setSchema(schema).readEntry();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Entry newEntry(String ... ldif) {
        return this.newEntry(Schema.getDefaultSchema(), ldif);
    }

    private SchemaValidationPolicy.EntryResolver newResolver(final Entry e) {
        return new SchemaValidationPolicy.EntryResolver(){

            public Entry getEntry(DN dn) throws LdapException {
                if (e == null) {
                    throw LdapException.newLdapException((ResultCode)ResultCode.NO_SUCH_OBJECT, (CharSequence)("no such entry " + dn));
                }
                Assertions.assertThat((Object)dn).isEqualTo((Object)e.getName());
                return e;
            }
        };
    }
}

