/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.fest.assertions.MapAssert;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.ConflictingSchemaElementException;
import org.forgerock.opendj.ldap.schema.DITStructureRule;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.testng.annotations.Test;

public class DITStructureRuleTestCase
extends AbstractSchemaTestCase {
    private static final String NAME_FORM_TEST_OID = "1.2.3.4";

    @Test
    public void testValidDITStructureRule() {
        SchemaBuilder builder = this.getTestSchema().buildDITStructureRule(42).names(new String[]{"DIT structure rule test", "DIT structure rule for person"}).nameForm(NAME_FORM_TEST_OID).description("My DIT structure rule").extraProperties("property name", new String[]{"property value"}).addToSchema();
        Schema schema = builder.buildDITStructureRule(43).names(new String[]{"DIT structure rule child test"}).nameForm(NAME_FORM_TEST_OID).superiorRules(new int[]{42}).description("My DIT structure rule child").extraProperties("property name", new String[]{"property value"}).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        DITStructureRule sr = schema.getDITStructureRule(42);
        Assertions.assertThat((Object)sr).isNotNull();
        Assertions.assertThat((Integer)sr.getRuleID()).isEqualTo(42);
        Assertions.assertThat((List)sr.getNames()).containsOnly(new Object[]{"DIT structure rule test", "DIT structure rule for person"});
        Assertions.assertThat((String)sr.getDescription()).isEqualTo((Object)"My DIT structure rule");
        Assertions.assertThat((String)sr.getNameForm().getOID()).isEqualTo((Object)NAME_FORM_TEST_OID);
        Assertions.assertThat((Map)sr.getExtraProperties()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"property name", Collections.singletonList("property value"))});
        Assertions.assertThat((Collection)sr.getSuperiorRules()).isEmpty();
        Assertions.assertThat((boolean)sr.isObsolete()).isFalse();
        DITStructureRule srChild = schema.getDITStructureRule(43);
        Assertions.assertThat((Object)srChild).isNotNull();
        Assertions.assertThat((Integer)srChild.getRuleID()).isEqualTo(43);
        Assertions.assertThat((List)srChild.getNames()).containsOnly(new Object[]{"DIT structure rule child test"});
        Assertions.assertThat((String)srChild.getDescription()).isEqualTo((Object)"My DIT structure rule child");
        Assertions.assertThat((String)srChild.getNameForm().getOID()).isEqualTo((Object)NAME_FORM_TEST_OID);
        Assertions.assertThat((Map)srChild.getExtraProperties()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"property name", Collections.singletonList("property value"))});
        Assertions.assertThat((Collection)srChild.getSuperiorRules()).containsOnly(new Object[]{sr});
        Assertions.assertThat((boolean)srChild.isObsolete()).isFalse();
    }

    @Test
    public void testCopyConstructor() throws Exception {
        Schema schema = this.getTestSchema().buildDITStructureRule(42).names(new String[]{"DIT structure rule test"}).nameForm(NAME_FORM_TEST_OID).description("My DIT structure rule").extraProperties("X-SCHEMA-FILE", new String[]{"99-user.ldif"}).addToSchema().toSchema();
        Schema schemaCopy = this.getTestSchema().buildDITStructureRule(schema.getDITStructureRule(42)).ruleID(43).names(new String[]{"DIT structure rule test - copy"}).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Collection)schemaCopy.getWarnings()).isEmpty();
        DITStructureRule srCopy = schemaCopy.getDITStructureRule(43);
        Assertions.assertThat((Object)srCopy).isNotNull();
        Assertions.assertThat((Integer)srCopy.getRuleID()).isEqualTo(43);
        Assertions.assertThat((List)srCopy.getNames()).containsOnly(new Object[]{"DIT structure rule test", "DIT structure rule test - copy"});
        Assertions.assertThat((String)srCopy.getNameForm().getOID()).isEqualTo((Object)NAME_FORM_TEST_OID);
        Assertions.assertThat((String)srCopy.getDescription()).isEqualTo((Object)"My DIT structure rule");
        Assertions.assertThat((boolean)srCopy.isObsolete()).isFalse();
        Assertions.assertThat((Map)srCopy.getExtraProperties()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"X-SCHEMA-FILE", Arrays.asList("99-user.ldif"))});
    }

    @Test(expectedExceptions={ConflictingSchemaElementException.class})
    public void testBuilderDoesNotAllowOverwrite() throws Exception {
        SchemaBuilder builder = this.getTestSchema().buildDITStructureRule(42).nameForm(NAME_FORM_TEST_OID).addToSchema();
        builder.buildDITStructureRule(42).nameForm(NAME_FORM_TEST_OID).addToSchema().toSchema();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testBuilderDoesNotAllowNullNameForm() throws Exception {
        this.getTestSchema().buildDITStructureRule(42).nameForm(null).addToSchema();
    }

    @Test
    public void testBuilderRemoveAll() throws Exception {
        DITStructureRule.Builder srBuilder = this.getTestSchema().buildDITStructureRule(42).names(new String[]{"DIT structure rule test", "DIT structure rule for person"}).nameForm(NAME_FORM_TEST_OID).description("My DIT structure rule").superiorRules(new int[]{1, 2, 3, 4}).extraProperties("property name", new String[]{"property value"});
        Schema schema = srBuilder.removeAllNames().removeAllSuperiorRules().removeAllExtraProperties().addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        DITStructureRule sr = schema.getDITStructureRule(42);
        Assertions.assertThat((List)sr.getNames()).isEmpty();
        Assertions.assertThat((Map)sr.getExtraProperties()).isEmpty();
        Assertions.assertThat((Collection)sr.getSuperiorRules()).isEmpty();
    }

    @Test
    public void testBuilderRemove() throws Exception {
        DITStructureRule.Builder srBuilder = this.getTestSchema().buildDITStructureRule(42).names(new String[]{"DIT structure rule test", "should be removed"}).nameForm(NAME_FORM_TEST_OID).description("My DIT structure rule").superiorRules(new int[]{1}).extraProperties("property name", new String[]{"property value"});
        Schema schema = srBuilder.removeName("should be removed").removeSuperiorRule(1).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        DITStructureRule sr = schema.getDITStructureRule(42);
        Assertions.assertThat((List)sr.getNames()).containsOnly(new Object[]{"DIT structure rule test"});
        Assertions.assertThat((Collection)sr.getSuperiorRules()).isEmpty();
    }

    private SchemaBuilder getTestSchema() {
        return new SchemaBuilder(Schema.getCoreSchema()).buildNameForm(NAME_FORM_TEST_OID).structuralObjectClassOID("person").requiredAttributes(new String[]{"sn", "cn"}).addToSchema();
    }
}

