/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.ConflictingSchemaElementException;
import org.forgerock.opendj.ldap.schema.DITContentRule;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.testng.annotations.Test;

public class DITContentRuleTestCase
extends AbstractSchemaTestCase {
    @Test
    public void testValidDITContentRule() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildDITContentRule("2.5.6.14").names(Collections.singletonList("devicecontentrule")).description("Content rule desc").auxiliaryObjectClasses(Collections.emptyList()).optionalAttributes(Collections.emptyList()).prohibitedAttributes(Collections.singletonList("serialNumber")).requiredAttributes(Collections.singletonList("owner")).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        DITContentRule cr = schema.getDITContentRule("devicecontentrule");
        Assertions.assertThat((Object)cr).isNotNull();
        Assertions.assertThat((String)cr.getStructuralClassOID()).isEqualTo((Object)"2.5.6.14");
        Assertions.assertThat((List)cr.getNames()).containsOnly(new Object[]{"devicecontentrule"});
        Assertions.assertThat((Collection)cr.getAuxiliaryClasses()).hasSize(0);
        Assertions.assertThat((Collection)cr.getOptionalAttributes()).hasSize(0);
        Assertions.assertThat((Collection)cr.getProhibitedAttributes()).hasSize(1);
        Assertions.assertThat((Collection)cr.getRequiredAttributes()).hasSize(1);
        Assertions.assertThat((String)cr.getDescription()).isEqualTo((Object)"Content rule desc");
        Assertions.assertThat((boolean)cr.isObsolete()).isFalse();
    }

    @Test
    public void testCopyConstructor() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildDITContentRule("2.5.6.4").names(Collections.singletonList("organizationcontentrule")).description("Content rule desc").auxiliaryObjectClasses(Collections.singletonList("2.5.6.22")).optionalAttributes(Collections.singletonList("searchGuide")).prohibitedAttributes(Collections.singletonList("postOfficeBox")).requiredAttributes(Collections.singletonList("telephoneNumber")).addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        Schema schemaCopy = new SchemaBuilder(Schema.getCoreSchema()).buildDITContentRule(schema.getDITContentRule("organizationcontentrule")).names(new String[]{"organizationcontentrule-copy"}).addToSchema().toSchema();
        Assertions.assertThat((Collection)schemaCopy.getWarnings()).isEmpty();
        DITContentRule crCopy = schemaCopy.getDITContentRule("organizationcontentrule-copy");
        Assertions.assertThat((Object)crCopy).isNotNull();
        Assertions.assertThat((String)crCopy.getStructuralClassOID()).isEqualTo((Object)"2.5.6.4");
        Assertions.assertThat((List)crCopy.getNames()).containsOnly(new Object[]{"organizationcontentrule", "organizationcontentrule-copy"});
        Assertions.assertThat((Collection)crCopy.getAuxiliaryClasses()).hasSize(1);
        Assertions.assertThat((Collection)crCopy.getOptionalAttributes()).hasSize(1);
        Assertions.assertThat((Collection)crCopy.getProhibitedAttributes()).hasSize(1);
        Assertions.assertThat((Collection)crCopy.getRequiredAttributes()).hasSize(1);
        Assertions.assertThat((String)crCopy.getDescription()).isEqualTo((Object)"Content rule desc");
        Assertions.assertThat((boolean)crCopy.isObsolete()).isFalse();
    }

    @Test(expectedExceptions={ConflictingSchemaElementException.class})
    public void testBuilderDoesNotAllowOverwrite() throws Exception {
        SchemaBuilder schemaBuilder = new SchemaBuilder(Schema.getCoreSchema()).buildDITContentRule("2.5.6.9").addToSchema();
        schemaBuilder.buildDITContentRule("2.5.6.9").addToSchema();
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testBuilderDoesNotAllowNullStructuralOCOID() throws Exception {
        new SchemaBuilder(Schema.getCoreSchema()).buildDITContentRule((String)null).addToSchema();
    }

    @Test
    public void testBuilderRemoveAll() throws Exception {
        DITContentRule.Builder crBuilder = new SchemaBuilder(Schema.getCoreSchema()).buildDITContentRule("2.5.6.1").names(Collections.singletonList("shouldBeRemoved")).description("My content rule").auxiliaryObjectClasses(Collections.singletonList("shouldBeRemoved")).optionalAttributes(Collections.singletonList("shouldBeRemoved")).prohibitedAttributes(Collections.singletonList("shouldBeRemoved")).requiredAttributes(Collections.singletonList("shouldBeRemoved"));
        Schema schema = crBuilder.removeAllNames().removeAllAuxiliaryObjectClasses().removeAllOptionalAttributes().removeAllProhibitedAttributes().removeAllRequiredAttributes().addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        DITContentRule cr = schema.getDITContentRule(schema.getObjectClass("2.5.6.1"));
        Assertions.assertThat((List)cr.getNames()).isEmpty();
        Assertions.assertThat((Collection)cr.getAuxiliaryClasses()).isEmpty();
        Assertions.assertThat((Collection)cr.getOptionalAttributes()).isEmpty();
        Assertions.assertThat((Collection)cr.getProhibitedAttributes()).isEmpty();
        Assertions.assertThat((Collection)cr.getRequiredAttributes()).isEmpty();
    }

    @Test
    public void testBuilderRemove() throws Exception {
        DITContentRule.Builder crBuilder = new SchemaBuilder(Schema.getCoreSchema()).buildDITContentRule("2.5.6.1").names(Collections.singletonList("shouldBeRemoved")).description("My content rule").auxiliaryObjectClasses(Collections.singletonList("shouldBeRemoved")).optionalAttributes(Collections.singletonList("shouldBeRemoved")).prohibitedAttributes(Collections.singletonList("shouldBeRemoved")).requiredAttributes(Collections.singletonList("shouldBeRemoved"));
        Schema schema = crBuilder.removeName("shouldBeRemoved").removeAuxiliaryObjectClass("shouldBeRemoved").removeOptionalAttribute("shouldBeRemoved").removeProhibitedAttribute("shouldBeRemoved").removeRequiredAttribute("shouldBeRemoved").addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        DITContentRule cr = schema.getDITContentRule(schema.getObjectClass("2.5.6.1"));
        Assertions.assertThat((List)cr.getNames()).isEmpty();
        Assertions.assertThat((Collection)cr.getAuxiliaryClasses()).isEmpty();
        Assertions.assertThat((Collection)cr.getOptionalAttributes()).isEmpty();
        Assertions.assertThat((Collection)cr.getProhibitedAttributes()).isEmpty();
        Assertions.assertThat((Collection)cr.getRequiredAttributes()).isEmpty();
    }
}

