/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.schema.AbstractSubstringMatchingRuleImplTest;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SubstringMatchingRuleTest;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class CollationSubstringMatchingRuleTest
extends SubstringMatchingRuleTest {
    @Override
    @DataProvider(name="substringInvalidAssertionValues")
    public Object[][] createMatchingRuleInvalidAssertionValues() {
        return new Object[0][];
    }

    @Override
    @DataProvider(name="substringInvalidAttributeValues")
    public Object[][] createMatchingRuleInvalidAttributeValues() {
        return new Object[0][];
    }

    @Override
    @DataProvider(name="substringFinalMatchData")
    public Object[][] createSubstringFinalMatchData() {
        return new Object[][]{{"this is a value", "value", ConditionResult.TRUE}, {"this is a value", "alue", ConditionResult.TRUE}, {"this is a value", "ue", ConditionResult.TRUE}, {"this is a value", "e", ConditionResult.TRUE}, {"this is a value", "valu", ConditionResult.FALSE}, {"this is a value", "this", ConditionResult.FALSE}, {"this is a value", "VALUE", ConditionResult.TRUE}, {"this is a value", "AlUe", ConditionResult.TRUE}, {"this is a value", "UE", ConditionResult.TRUE}, {"this is a value", "E", ConditionResult.TRUE}, {"this is a value", "THIS", ConditionResult.FALSE}, {"this is a value", " ", ConditionResult.TRUE}, {"this is a VALUE", "value", ConditionResult.TRUE}, {"end with space    ", " ", ConditionResult.TRUE}, {"end with space    ", "space", ConditionResult.TRUE}, {"end with space    ", "SPACE", ConditionResult.TRUE}, {"il est passe", "passE", ConditionResult.TRUE}, {"il est passe", "pass\u00e9", ConditionResult.TRUE}, {"il est passe", "pass\u00c9", ConditionResult.TRUE}, {"il est pass\u00c9", "passe", ConditionResult.TRUE}, {"il est pass\u00e9", "passE", ConditionResult.TRUE}};
    }

    @Override
    @DataProvider(name="substringInitialMatchData")
    public Object[][] createSubstringInitialMatchData() {
        return new Object[][]{{"this is a value", "this", ConditionResult.TRUE}, {"this is a value", "th", ConditionResult.TRUE}, {"this is a value", "t", ConditionResult.TRUE}, {"this is a value", "is", ConditionResult.FALSE}, {"this is a value", "a", ConditionResult.FALSE}, {"this is a value", "TH", ConditionResult.TRUE}, {"this is a value", "T", ConditionResult.TRUE}, {"this is a value", "IS", ConditionResult.FALSE}, {"this is a value", "A", ConditionResult.FALSE}, {"this is a value", "VALUE", ConditionResult.FALSE}, {"this is a value", " ", ConditionResult.TRUE}, {"this is a value", "NOT", ConditionResult.FALSE}, {"this is a value", "THIS", ConditionResult.TRUE}, {"il etait passe", "Il \u00e9", ConditionResult.TRUE}, {"il etait passe", "Il \u00c9", ConditionResult.TRUE}, {"il etait passe", "Il E", ConditionResult.TRUE}, {"il \u00e9tait passe", "IL e", ConditionResult.TRUE}};
    }

    @Override
    @DataProvider(name="substringMiddleMatchData")
    public Object[][] createSubstringMiddleMatchData() {
        return new Object[][]{{"this is a value", this.strings("this"), ConditionResult.TRUE}, {"this is a value", this.strings("is"), ConditionResult.TRUE}, {"this is a value", this.strings("a"), ConditionResult.TRUE}, {"this is a value", this.strings("value"), ConditionResult.TRUE}, {"this is a value", this.strings("THIS"), ConditionResult.TRUE}, {"this is a value", this.strings("IS"), ConditionResult.TRUE}, {"this is a value", this.strings("A"), ConditionResult.TRUE}, {"this is a value", this.strings("VALUE"), ConditionResult.TRUE}, {"this is a value", this.strings(" "), ConditionResult.TRUE}, {"this is a value", this.strings("this", "is", "a", "value"), ConditionResult.TRUE}, {"this is a value", this.strings("value", "this"), ConditionResult.FALSE}, {"this is a value", this.strings("this", "this is"), ConditionResult.FALSE}, {"this is a value", this.strings("this", "IS", "a", "VALue"), ConditionResult.TRUE}, {"this is a value", this.strings("his IS", "A val"), ConditionResult.TRUE}, {"this is a value", this.strings("not"), ConditionResult.FALSE}, {"this is a value", this.strings("this", "not"), ConditionResult.FALSE}, {"this is a value", this.strings("    "), ConditionResult.TRUE}, {"il est passe par la", this.strings("est", "pass\u00e9"), ConditionResult.TRUE}, {"il est passe par la", this.strings("pass\u00e9", "Par"), ConditionResult.TRUE}, {"il est passe par la", this.strings("est", "pass\u00c9", "PAR", "La"), ConditionResult.TRUE}, {"il est pass\u00e9 par la", this.strings("il", "Est", "pass\u00c9"), ConditionResult.TRUE}, {"il est pass\u00c9 par la", this.strings("est", "passe"), ConditionResult.TRUE}};
    }

    @Override
    protected MatchingRule getRule() {
        return Schema.getCoreSchema().getMatchingRule("fr.sub");
    }

    @Test
    public void testCreateIndexQuery() throws Exception {
        ByteString value = ByteString.valueOfUtf8((CharSequence)"a*c");
        MatchingRule matchingRule = this.getRule();
        Assertion assertion = matchingRule.getAssertion((ByteSequence)value);
        int subStringLength = 3;
        String indexQuery = (String)assertion.createIndexQuery((IndexQueryFactory)new AbstractSubstringMatchingRuleImplTest.FakeIndexQueryFactory(AbstractSubstringMatchingRuleImplTest.newIndexingOptions(subStringLength), false));
        ByteString binit = matchingRule.normalizeAttributeValue((ByteSequence)ByteString.valueOfUtf8((CharSequence)"a"));
        ByteString bfinal = matchingRule.normalizeAttributeValue((ByteSequence)ByteString.valueOfUtf8((CharSequence)"c"));
        Assert.assertEquals((String)indexQuery, (String)("intersect[rangeMatch(fr.shared, '" + binit.toHexString() + "' <= value < '0054'), rangeMatch(fr.substring:" + subStringLength + ", '" + bfinal.toHexString() + "' <= value < '0056'), rangeMatch(fr.substring:" + subStringLength + ", '" + binit.toHexString() + "' <= value < '0054')]"));
    }
}

