/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.schema.AbstractSubstringMatchingRuleImplTest;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleTest;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class CollationLessThanOrEqualMatchingRuleTest
extends MatchingRuleTest {
    @Override
    @DataProvider(name="matchingRuleInvalidAttributeValues")
    public Object[][] createMatchingRuleInvalidAttributeValues() {
        return new Object[0][];
    }

    @Override
    @DataProvider(name="matchingrules")
    public Object[][] createMatchingRuleTest() {
        return new Object[][]{{"abc", "abd", ConditionResult.TRUE}, {"abc", "acc", ConditionResult.TRUE}, {"abc", "bbc", ConditionResult.TRUE}, {"abc", "abD", ConditionResult.TRUE}, {"def", "d\u00e9g", ConditionResult.TRUE}, {"def", "dEg", ConditionResult.TRUE}, {"dEf", "deg", ConditionResult.TRUE}, {"d\u00e9f", "dEg", ConditionResult.TRUE}, {"passe", "passe", ConditionResult.TRUE}, {"passe ", "passe", ConditionResult.TRUE}, {"passE", "passe", ConditionResult.TRUE}, {"pass\u00e9", "passe", ConditionResult.TRUE}, {"pass\u00e9", "passE", ConditionResult.TRUE}, {"pass\u00e9", "pass\u00c9", ConditionResult.TRUE}, {"passe", "pass\u00e9", ConditionResult.TRUE}, {"passE", "pass\u00e9", ConditionResult.TRUE}, {"pass\u00c9", "pass\u00e9", ConditionResult.TRUE}, {"abd", "abc", ConditionResult.FALSE}, {"acc", "abc", ConditionResult.FALSE}, {"bbc", "abc", ConditionResult.FALSE}, {"abD", "abc", ConditionResult.FALSE}, {"d\u00e9g", "def", ConditionResult.FALSE}, {"dEg", "def", ConditionResult.FALSE}, {"deg", "dEf", ConditionResult.FALSE}, {"dEg", "d\u00e9f", ConditionResult.FALSE}};
    }

    @Override
    protected MatchingRule getRule() {
        return Schema.getCoreSchema().getMatchingRule("fr.lte");
    }

    @Test
    public void testCreateIndexQuery() throws Exception {
        ByteString value = ByteString.valueOfUtf8((CharSequence)"abc");
        MatchingRule matchingRule = this.getRule();
        Assertion assertion = matchingRule.getAssertion((ByteSequence)value);
        String indexQuery = (String)assertion.createIndexQuery((IndexQueryFactory)new AbstractSubstringMatchingRuleImplTest.FakeIndexQueryFactory(AbstractSubstringMatchingRuleImplTest.newIndexingOptions(), false));
        ByteString normalizedValue = matchingRule.normalizeAttributeValue((ByteSequence)value);
        Assert.assertEquals((String)indexQuery, (String)("rangeMatch(fr.shared, '' < value <= '" + normalizedValue.toHexString() + "')"));
    }
}

