/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.schema.AbstractSubstringMatchingRuleImplTest;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleTest;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class CollationGreaterThanMatchingRuleTest
extends MatchingRuleTest {
    @Override
    @DataProvider(name="matchingRuleInvalidAttributeValues")
    public Object[][] createMatchingRuleInvalidAttributeValues() {
        return new Object[0][];
    }

    @Override
    @DataProvider(name="matchingrules")
    public Object[][] createMatchingRuleTest() {
        return new Object[][]{{"abc", "abd", ConditionResult.FALSE}, {"abc", "acc", ConditionResult.FALSE}, {"abc", "bbc", ConditionResult.FALSE}, {"abc", "abD", ConditionResult.FALSE}, {"def", "d\u00e9g", ConditionResult.FALSE}, {"def", "dEg", ConditionResult.FALSE}, {"dEf", "deg", ConditionResult.FALSE}, {"d\u00e9f", "dEg", ConditionResult.FALSE}, {"passe", "passe", ConditionResult.FALSE}, {"passe ", "passe", ConditionResult.FALSE}, {"passE", "passe", ConditionResult.FALSE}, {"pass\u00e9", "passe", ConditionResult.FALSE}, {"pass\u00e9", "passE", ConditionResult.FALSE}, {"pass\u00e9", "pass\u00c9", ConditionResult.FALSE}, {"passe", "pass\u00e9", ConditionResult.FALSE}, {"passE", "pass\u00e9", ConditionResult.FALSE}, {"pass\u00c9", "pass\u00e9", ConditionResult.FALSE}, {"abd", "abc", ConditionResult.TRUE}, {"acc", "abc", ConditionResult.TRUE}, {"bbc", "abc", ConditionResult.TRUE}, {"abD", "abc", ConditionResult.TRUE}, {"d\u00e9g", "def", ConditionResult.TRUE}, {"dEg", "def", ConditionResult.TRUE}, {"deg", "dEf", ConditionResult.TRUE}, {"dEg", "d\u00e9f", ConditionResult.TRUE}};
    }

    @Override
    protected MatchingRule getRule() {
        return Schema.getCoreSchema().getMatchingRule("fr.gt");
    }

    @Test
    public void testCreateIndexQuery() throws Exception {
        ByteString value = ByteString.valueOfUtf8((CharSequence)"abc");
        MatchingRule matchingRule = this.getRule();
        Assertion assertion = matchingRule.getAssertion((ByteSequence)value);
        String indexQuery = (String)assertion.createIndexQuery((IndexQueryFactory)new AbstractSubstringMatchingRuleImplTest.FakeIndexQueryFactory(AbstractSubstringMatchingRuleImplTest.newIndexingOptions(), false));
        ByteString normalizedValue = matchingRule.normalizeAttributeValue((ByteSequence)value);
        Assert.assertEquals((String)indexQuery, (String)("rangeMatch(fr.shared, '" + normalizedValue.toHexString() + "' < value < '')"));
    }
}

