/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.List;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.schema.AbstractSubstringMatchingRuleImplTest;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleTest;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class CollationEqualityMatchingRuleTest
extends MatchingRuleTest {
    @Override
    @DataProvider(name="matchingRuleInvalidAttributeValues")
    public Object[][] createMatchingRuleInvalidAttributeValues() {
        return new Object[0][];
    }

    @Override
    @DataProvider(name="matchingrules")
    public Object[][] createMatchingRuleTest() {
        return new Object[][]{{"passe", "passe", ConditionResult.TRUE}, {"passe ", "passe", ConditionResult.TRUE}, {"passE", "passe", ConditionResult.TRUE}, {"pass\u00e9", "passe", ConditionResult.TRUE}, {"pass\u00e9", "passE", ConditionResult.TRUE}, {"pass\u00e9", "pass\u00c9", ConditionResult.TRUE}, {"passe", "pass\u00e9", ConditionResult.TRUE}, {"passE", "pass\u00e9", ConditionResult.TRUE}, {"pass\u00c9", "pass\u00e9", ConditionResult.TRUE}, {"abc", "abd", ConditionResult.FALSE}, {"abc", "acc", ConditionResult.FALSE}, {"abc", "bbc", ConditionResult.FALSE}, {"abc", "abD", ConditionResult.FALSE}, {"def", "d\u00e9g", ConditionResult.FALSE}, {"def", "dEg", ConditionResult.FALSE}, {"dEf", "deg", ConditionResult.FALSE}, {"d\u00e9f", "dEg", ConditionResult.FALSE}, {"abd", "abc", ConditionResult.FALSE}, {"acc", "abc", ConditionResult.FALSE}, {"bbc", "abc", ConditionResult.FALSE}, {"abD", "abc", ConditionResult.FALSE}, {"d\u00e9g", "def", ConditionResult.FALSE}, {"dEg", "def", ConditionResult.FALSE}, {"deg", "dEf", ConditionResult.FALSE}, {"dEg", "d\u00e9f", ConditionResult.FALSE}};
    }

    @Override
    protected MatchingRule getRule() {
        return Schema.getCoreSchema().getMatchingRule("fr.eq");
    }

    @Test
    public void testMatchingRuleNames() throws Exception {
        MatchingRule rule = Schema.getCoreSchema().getMatchingRule("fr.eq");
        Assertions.assertThat((List)rule.getNames()).containsOnly(new Object[]{"fr.eq", "fr.3", "fr-FR.eq", "fr-FR.3"});
        MatchingRule rule2 = Schema.getCoreSchema().getMatchingRule("fr-FR.eq");
        Assertions.assertThat((List)rule2.getNames()).containsOnly(new Object[]{"fr.eq", "fr.3", "fr-FR.eq", "fr-FR.3"});
        MatchingRule rule3 = Schema.getCoreSchema().getMatchingRule("ar.3");
        Assertions.assertThat((List)rule3.getNames()).containsOnly(new Object[]{"ar.eq", "ar.3"});
        MatchingRule rule4 = Schema.getCoreSchema().getMatchingRule("ar");
        Assertions.assertThat((List)rule4.getNames()).containsOnly(new Object[]{"ar"});
    }

    @Test
    public void testCreateIndexQuery() throws Exception {
        ByteString value = ByteString.valueOfUtf8((CharSequence)"abc");
        MatchingRule matchingRule = this.getRule();
        Assertion assertion = matchingRule.getAssertion((ByteSequence)value);
        String indexQuery = (String)assertion.createIndexQuery((IndexQueryFactory)new AbstractSubstringMatchingRuleImplTest.FakeIndexQueryFactory(AbstractSubstringMatchingRuleImplTest.newIndexingOptions(), false));
        ByteString normalizedValue = matchingRule.normalizeAttributeValue((ByteSequence)value);
        Assert.assertEquals((String)indexQuery, (String)("exactMatch(fr.shared, value=='" + normalizedValue.toHexString() + "')"));
    }
}

