/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class CertificateSyntaxTest
extends AbstractSchemaTestCase {
    @DataProvider(name="acceptableValues")
    public Object[][] createAcceptableValues() {
        String validcert1 = "MIICpTCCAg6gAwIBAgIJALeoA6I3ZC/cMA0GCSqGSIb3DQEBBQUAMFYxCzAJBgNVBAYTAlVTMRMwEQYDVQQHEwpDdXBlcnRpb25lMRwwGgYDVQQLExNQcm9kdWN0IERldmVsb3BtZW50MRQwEgYDVQQDEwtCYWJzIEplbnNlbjAeFw0xMjA1MDIxNjM0MzVaFw0xMjEyMjExNjM0MzVaMFYxCzAJBgNVBAYTAlVTMRMwEQYDVQQHEwpDdXBlcnRpb25lMRwwGgYDVQQLExNQcm9kdWN0IERldmVsb3BtZW50MRQwEgYDVQQDEwtCYWJzIEplbnNlbjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEApysa0c9qc8FB8gIJ8zAb1pbJ4HzC7iRlVGhRJjFORkGhyvU4P5o2wL0iz/uko6rL9/pFhIlIMbwbV8smmKeNUPitwiKOjoFDmtimcZ4bx5UTAYLbbHMpEdwSpMC5iF2UioM7qdiwpAfZBd6Z69vqNxuUJ6tP+hxtr/aSgMH2i8ECAwEAAaN7MHkwCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdT3BlblNTTCBHZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFLlZD3aKDa8jdhzoByOFMAJDs2osMB8GA1UdIwQYMBaAFLlZD3aKDa8jdhzoByOFMAJDs2osMA0GCSqGSIb3DQEBBQUAA4GBAE5vccY8Ydd7by2bbwiDKgQqVyoKrkUg6CD0WRmc2pBeYX2z94/PWO5L3Fx+eIZh2wTxScF+FdRWJzLbUaBuClrxuy0Y5ifjaxuJ8LFNbZtsp1ldW3i84+F5+SYT+xI67ZcoAtwx/VFVI9s5I/Gkmu9f9nxjPpK71AIUXiE3Qcck";
        String invalidcert1 = "MIICpTCCAg6gAwIBBQIJALeoA6I3ZC/cMA0GCSqGSIb3DQEBBQUAMFYxCzAJBgNVBAYTAlVTMRMwEQYDVQQHEwpDdXBlcnRpb25lMRwwGgYDVQQLExNQcm9kdWN0IERldmVsb3BtZW50MRQwEgYDVQQDEwtCYWJzIEplbnNlbjAeFw0xMjA1MDIxNjM0MzVaFw0xMjEyMjExNjM0MzVaMFYxCzAJBgNVBAYTAlVTMRMwEQYDVQQHEwpDdXBlcnRpb25lMRwwGgYDVQQLExNQcm9kdWN0IERldmVsb3BtZW50MRQwEgYDVQQDEwtCYWJzIEplbnNlbjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEApysa0c9qc8FB8gIJ8zAb1pbJ4HzC7iRlVGhRJjFORkGhyvU4P5o2wL0iz/uko6rL9/pFhIlIMbwbV8smmKeNUPitwiKOjoFDmtimcZ4bx5UTAYLbbHMpEdwSpMC5iF2UioM7qdiwpAfZBd6Z69vqNxuUJ6tP+hxtr/aSgMH2i8ECAwEAAaN7MHkwCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdT3BlblNTTCBHZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFLlZD3aKDa8jdhzoByOFMAJDs2osMB8GA1UdIwQYMBaAFLlZD3aKDa8jdhzoByOFMAJDs2osMA0GCSqGSIb3DQEBBQUAA4GBAE5vccY8Ydd7by2bbwiDKgQqVyoKrkUg6CD0WRmc2pBeYX2z94/PWO5L3Fx+eIZh2wTxScF+FdRWJzLbUaBuClrxuy0Y5ifjaxuJ8LFNbZtsp1ldW3i84+F5+SYT+xI67ZcoAtwx/VFVI9s5I/Gkmu9f9nxjPpK71AIUXiE3Qcck";
        String brokencert1 = "MIICpTCCAg6gAwIBAgIJALeoA6I3ZC/cMA0GCSqGSIb3DQEBBQUAMFYxCzAJBgNV";
        return new Object[][]{{ByteString.valueOfBase64((String)validcert1), true}, {ByteString.valueOfUtf8((CharSequence)validcert1), false}, {ByteString.valueOfBase64((String)invalidcert1), false}, {ByteString.valueOfBase64((String)brokencert1), false}, {ByteString.valueOfUtf8((CharSequence)"invalid"), false}};
    }

    @Test(dataProvider="acceptableValues")
    public void testAcceptableValues(ByteString value, boolean result) {
        Syntax syntax = this.getRule();
        LocalizableMessageBuilder reason = new LocalizableMessageBuilder();
        boolean liveResult = syntax.valueIsAcceptable((ByteSequence)value, reason);
        Assert.assertEquals((boolean)liveResult, (boolean)result, (String)(syntax + ".valueIsAcceptable gave bad result for " + value + "reason : " + reason));
    }

    @Test(dataProvider="acceptableValues")
    public void testAllowMalformedCertificates(ByteString value, Boolean result) {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema()).setOption(SchemaOptions.ALLOW_MALFORMED_CERTIFICATES, (Object)true);
        Syntax syntax = builder.toSchema().getSyntax("1.3.6.1.4.1.1466.115.121.1.8");
        LocalizableMessageBuilder reason = new LocalizableMessageBuilder();
        boolean liveResult = syntax.valueIsAcceptable((ByteSequence)value, reason);
        Assert.assertTrue((boolean)liveResult, (String)(syntax + ".valueIsAcceptable gave bad result for " + value + "reason : " + reason));
    }

    protected Syntax getRule() {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema()).setOption(SchemaOptions.ALLOW_MALFORMED_CERTIFICATES, (Object)false);
        return builder.toSchema().getSyntax("1.3.6.1.4.1.1466.115.121.1.8");
    }
}

