/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class CertificateExactMatchingRuleImplTest
extends AbstractSchemaTestCase {
    @DataProvider(name="certificateExactMatchingRules")
    public Object[][] createCertificateExactMatchingRuleTest() {
        String validcert1 = "MIICpTCCAg6gAwIBAgIJALeoA6I3ZC/cMA0GCSqGSIb3DQEBBQUAMFYxCzAJBgNVBAYTAlVTMRMwEQYDVQQHEwpDdXBlcnRpb25lMRwwGgYDVQQLExNQcm9kdWN0IERldmVsb3BtZW50MRQwEgYDVQQDEwtCYWJzIEplbnNlbjAeFw0xMjA1MDIxNjM0MzVaFw0xMjEyMjExNjM0MzVaMFYxCzAJBgNVBAYTAlVTMRMwEQYDVQQHEwpDdXBlcnRpb25lMRwwGgYDVQQLExNQcm9kdWN0IERldmVsb3BtZW50MRQwEgYDVQQDEwtCYWJzIEplbnNlbjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEApysa0c9qc8FB8gIJ8zAb1pbJ4HzC7iRlVGhRJjFORkGhyvU4P5o2wL0iz/uko6rL9/pFhIlIMbwbV8smmKeNUPitwiKOjoFDmtimcZ4bx5UTAYLbbHMpEdwSpMC5iF2UioM7qdiwpAfZBd6Z69vqNxuUJ6tP+hxtr/aSgMH2i8ECAwEAAaN7MHkwCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdT3BlblNTTCBHZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFLlZD3aKDa8jdhzoByOFMAJDs2osMB8GA1UdIwQYMBaAFLlZD3aKDa8jdhzoByOFMAJDs2osMA0GCSqGSIb3DQEBBQUAA4GBAE5vccY8Ydd7by2bbwiDKgQqVyoKrkUg6CD0WRmc2pBeYX2z94/PWO5L3Fx+eIZh2wTxScF+FdRWJzLbUaBuClrxuy0Y5ifjaxuJ8LFNbZtsp1ldW3i84+F5+SYT+xI67ZcoAtwx/VFVI9s5I/Gkmu9f9nxjPpK71AIUXiE3Qcck";
        String incompleteCert = "MIICpTCCAg6gAwIBAgIJALeoA6I3ZC/cMA0GCSqGSIb3DQEBBQUAMFYxCzAJBgNV";
        String assertion = "{ serialNumber 13233831500277100508, issuer rdnSequence:\"CN=Babs Jensen,OU=Product Development,L=Cupertione,C=US\" }";
        String assertionWithSpaces = "{    serialNumber     13233831500277100508,  issuer  rdnSequence:\"CN=Babs Jensen,OU=Product Development, L=Cupertione,C=US\" }";
        String assertionDNencoded = "{ serialNumber 13233831500277100508, issuer rdnSequence:\"cn=BABS Jensen,ou=Product Development,L=Cupertione,c=#5553\" }";
        String assertionWrong = "{ serialNumber 13233831511277100508, issuer rdnSequence:\"CN=Babs Jensen,OU=Product Development,L=Cupertione,C=US\" }";
        return new Object[][]{{ByteString.valueOfBase64((String)validcert1), ByteString.valueOfUtf8((CharSequence)assertion), ConditionResult.TRUE}, {ByteString.valueOfBase64((String)validcert1), ByteString.valueOfUtf8((CharSequence)assertionWithSpaces), ConditionResult.TRUE}, {ByteString.valueOfBase64((String)validcert1), ByteString.valueOfUtf8((CharSequence)assertionDNencoded), ConditionResult.TRUE}, {ByteString.valueOfBase64((String)validcert1), ByteString.valueOfUtf8((CharSequence)assertionWrong), ConditionResult.FALSE}, {ByteString.valueOfBase64((String)incompleteCert), ByteString.valueOfBase64((String)incompleteCert), ConditionResult.TRUE}, {ByteString.valueOfBase64((String)validcert1), ByteString.valueOfBase64((String)validcert1), ConditionResult.TRUE}};
    }

    @DataProvider(name="certificateExactMatchValidAssertionValues")
    public Object[][] createCertificateExactMatchingRuleValidAssertionValues() {
        return new Object[][]{{"{serialNumber 123,issuer rdnSequence:\"c=DE\"}"}, {"{serialNumber 123,issuer rdnSequence:\"\"}"}, {"{serialNumber 0123,issuer rdnSequence:\"cn=issuer\"}"}, {"{  serialNumber  123,  issuer  rdnSequence:\"c=DE\"  }"}, {"{serialNumber 123,issuer rdnSequence:\"cn=escaped\"\"dquotes\"}"}, {"{serialNumber 123,issuer rdnSequence:\"cn=\u00d6\u00c4\"}"}};
    }

    @DataProvider(name="certificateExactMatchInvalidAssertionValues")
    public Object[][] createCertificateExactMatchingRuleInvalidAssertionValues() {
        return new Object[][]{{"{serialnumber 123,issuer rdnSequence:\"c=DE\"}"}, {"{serialNumber 123,issuer rdnSequence:\"invalid\"}"}, {"{serialNumber 0123,issuer rdnSequence: \"cn=issuer\"}"}, {"{  serialNumber  123  ,  issuer  rdnSequence:\"c=DE\"  }  trailing"}};
    }

    @DataProvider(name="certificateExactMatchInvalidAttributeValues")
    public Object[][] createCertificateExactMatchingRuleInvalidAttributeValues() throws Exception {
        String invalidcert1 = "MIICpTCCAg6gAwIBBQIJALeoA6I3ZC/cMA0GCSqGSIb3DQEBBQUAMFYxCzAJBgNVBAYTAlVTMRMwEQYDVQQHEwpDdXBlcnRpb25lMRwwGgYDVQQLExNQcm9kdWN0IERldmVsb3BtZW50MRQwEgYDVQQDEwtCYWJzIEplbnNlbjAeFw0xMjA1MDIxNjM0MzVaFw0xMjEyMjExNjM0MzVaMFYxCzAJBgNVBAYTAlVTMRMwEQYDVQQHEwpDdXBlcnRpb25lMRwwGgYDVQQLExNQcm9kdWN0IERldmVsb3BtZW50MRQwEgYDVQQDEwtCYWJzIEplbnNlbjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEApysa0c9qc8FB8gIJ8zAb1pbJ4HzC7iRlVGhRJjFORkGhyvU4P5o2wL0iz/uko6rL9/pFhIlIMbwbV8smmKeNUPitwiKOjoFDmtimcZ4bx5UTAYLbbHMpEdwSpMC5iF2UioM7qdiwpAfZBd6Z69vqNxuUJ6tP+hxtr/aSgMH2i8ECAwEAAaN7MHkwCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdT3BlblNTTCBHZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFLlZD3aKDa8jdhzoByOFMAJDs2osMB8GA1UdIwQYMBaAFLlZD3aKDa8jdhzoByOFMAJDs2osMA0GCSqGSIb3DQEBBQUAA4GBAE5vccY8Ydd7by2bbwiDKgQqVyoKrkUg6CD0WRmc2pBeYX2z94/PWO5L3Fx+eIZh2wTxScF+FdRWJzLbUaBuClrxuy0Y5ifjaxuJ8LFNbZtsp1ldW3i84+F5+SYT+xI67ZcoAtwx/VFVI9s5I/Gkmu9f9nxjPpK71AIUXiE3Qcck";
        String brokencert1 = "MIICpTCCAg6gAwIBAgIJALeoA6I3ZC/cMA0GCSqGSIb3DQEBBQUAMFYxCzAJBgNV";
        return new Object[][]{{ByteString.valueOfBase64((String)invalidcert1)}, {ByteString.valueOfBase64((String)brokencert1)}};
    }

    protected MatchingRule getRule() {
        return CoreSchema.getCertificateExactMatchingRule();
    }

    @Test(dataProvider="certificateExactMatchingRules")
    public void certificateExactMatchingRules(ByteString attributeValue, ByteString assertionValue, ConditionResult result) throws DecodeException {
        MatchingRule rule = this.getRule();
        Assert.assertEquals((Object)rule.getAssertion((ByteSequence)assertionValue).matches((ByteSequence)rule.normalizeAttributeValue((ByteSequence)attributeValue)), (Object)result);
    }

    @Test(dataProvider="certificateExactMatchValidAssertionValues")
    public void certificateExactMatchingRuleValidAssertionValues(String value) throws DecodeException {
        MatchingRule rule = this.getRule();
        rule.getAssertion((ByteSequence)ByteString.valueOfUtf8((CharSequence)value));
    }

    @Test(dataProvider="certificateExactMatchInvalidAssertionValues", expectedExceptions={DecodeException.class})
    public void certificateExactMatchingRuleInvalidAssertionValues(String value) throws DecodeException {
        MatchingRule rule = this.getRule();
        rule.getAssertion((ByteSequence)ByteString.valueOfUtf8((CharSequence)value));
    }

    @Test(dataProvider="certificateExactMatchInvalidAttributeValues")
    public void certificateExactMatchingRuleInvalidAttributeValues(ByteString value) throws DecodeException {
        MatchingRule rule = this.getRule();
        Assertion normalizedAssertionValue = rule.getAssertion((ByteSequence)value);
        Assert.assertEquals((Object)normalizedAssertionValue.matches((ByteSequence)value), (Object)ConditionResult.TRUE);
    }
}

