/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AuthPasswordSyntaxImpl;
import org.forgerock.testng.ForgeRockTestCase;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class AuthPasswordSyntaxImplTest
extends ForgeRockTestCase {
    @DataProvider
    public Object[][] validEncodedPasswords() {
        return new Object[][]{{"0$0$0", "0", "0", "0"}, {" 0$0$0", "0", "0", "0"}, {"0 $0$0", "0", "0", "0"}, {"0$ 0$0", "0", "0", "0"}, {"0$0 $0", "0", "0", "0"}, {"0$0$ 0", "0", "0", "0"}, {"0$0$0 ", "0", "0", "0"}};
    }

    @Test(dataProvider="validEncodedPasswords")
    public void decodeValidPassword(String encodedPassword, String expectedScheme, String expectedAuthInfo, String expectedAuthValue) throws Exception {
        Assertions.assertThat((Object[])AuthPasswordSyntaxImpl.decodeAuthPassword((String)encodedPassword)).isEqualTo((Object[])new String[]{expectedScheme, expectedAuthInfo, expectedAuthValue});
    }

    @DataProvider
    public Object[][] invalidEncodedPasswords() {
        return new Object[][]{{"", "zero-length scheme element"}, {"$", "zero-length scheme element"}, {"0$$", "zero-length authInfo element"}, {"0$0$", "zero-length authValue element"}, {"a", "invalid scheme character"}, {"0 #", "illegal character between the scheme and authInfo element"}, {"0$0#", "invalid authInfo character"}, {"0$0 #", "illegal character between the authInfo and authValue element"}, {"0$0$\n", "invalid authValue character"}, {"0$0$0$", "invalid trailing character"}};
    }

    @Test(dataProvider="invalidEncodedPasswords")
    public void decodeInvalidPassword(String encodedPassword, String errorMsg) throws Exception {
        try {
            AuthPasswordSyntaxImpl.decodeAuthPassword((String)encodedPassword);
            Assert.fail((String)"Expected DirectoryException");
        }
        catch (DecodeException e) {
            Assertions.assertThat((String)e.getMessage()).contains(errorMsg);
        }
    }
}

