/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSchemaElement;
import org.forgerock.opendj.ldap.schema.AbstractSchemaElementTestCase;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.AttributeUsage;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AttributeTypeTest
extends AbstractSchemaElementTestCase {
    private final Schema schema;

    public AttributeTypeTest() throws Exception {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.buildAttributeType("1.2.1").names((Collection)EMPTY_NAMES).obsolete(true).syntax("1.3.6.1.4.1.1466.115.121.1.27").singleValue(true).usage(AttributeUsage.USER_APPLICATIONS).addToSchema();
        builder.addAttributeType("( 1.2.2 OBSOLETE SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE  COLLECTIVE X-ORIGIN ( 'Sun Java System Identity Management' 'user defined' ) X-SCHEMA-FILE '98sunEmp.ldif')", false);
        builder.buildAttributeType("1.2.3").names(new String[]{"testType3"}).superiorType("1.2.2").syntax("1.3.6.1.4.1.1466.115.121.1.27").collective(true).usage(AttributeUsage.USER_APPLICATIONS).addToSchema();
        builder.addAttributeType("( 1.2.4 NAME 'testType4' SUP 1.2.3 SINGLE-VALUE COLLECTIVE )", false);
        builder.buildAttributeType("1.2.5").names(new String[]{"testType5", "testnamealias5", "anothernamealias5"}).equalityMatchingRule("2.5.13.11").substringMatchingRule("2.5.13.12").approximateMatchingRule("1.3.6.1.4.1.26027.1.4.1").syntax("1.3.6.1.4.1.1466.115.121.1.27").noUserModification(true).usage(AttributeUsage.DSA_OPERATION).addToSchema();
        builder.addAttributeType("( 1.2.6 NAME ( 'testType6' 'testnamealias6' 'anothernamealias6' )  SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SUP anothernamealias5 USAGE dSAOperation NO-USER-MODIFICATION )", false);
        this.schema = builder.toSchema();
        this.ensureSchemaHasOnlyOneObsoleteWarning(this.schema);
    }

    private void ensureSchemaHasOnlyOneObsoleteWarning(Schema aSchema) {
        Collection schemaWarnings = aSchema.getWarnings();
        if (schemaWarnings.isEmpty()) {
            Assertions.fail((String)"Expected one warning for the obsolete attribute type 1.2.2");
        } else if (schemaWarnings.size() != 1 || !((LocalizableMessage)schemaWarnings.iterator().next()).toString().contains("OBSOLETE")) {
            Assertions.fail((String)("Base schema is not valid, it contains unexpected schema warnings. Warnings=" + schemaWarnings));
        }
    }

    @Override
    @DataProvider(name="equalsTestData")
    public Object[][] createEqualsTestData() throws SchemaException, DecodeException {
        return new Object[][]{{this.schema.getAttributeType("1.2.3"), this.schema.getAttributeType("1.2.3"), true}, {this.schema.getAttributeType("1.2.4"), this.schema.getAttributeType("1.2.3"), false}};
    }

    @Test
    public void testADSyntax() throws Exception {
        SchemaBuilder builder = new SchemaBuilder(this.schema);
        builder.addAttributeType("(1.2.8.5 NAME 'testtype' DESC 'full type'  SUP '1.2.5'  EQUALITY 'caseIgnoreMatch'  SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' USAGE dSAOperation )", false);
        Schema finalSchema = builder.toSchema();
        this.ensureSchemaHasOnlyOneObsoleteWarning(finalSchema);
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void testADSyntaxQuoteMismatch() throws Exception {
        SchemaBuilder builder = new SchemaBuilder(this.schema);
        builder.addAttributeType("(1.2.8.5 NAME 'testtype' DESC 'full type'  SUP '1.2.5  EQUALITY 'caseIgnoreMatch'  SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' USAGE dSAOperation )", false);
        Assert.assertFalse((boolean)builder.toSchema().getWarnings().isEmpty());
    }

    @Test
    public void testCollectiveOperational() throws Exception {
        SchemaBuilder builder = new SchemaBuilder(this.schema);
        builder.addAttributeType("(1.2.8.5 NAME 'testtype' DESC 'full type' OBSOLETE  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE COLLECTIVE USAGE directoryOperation )", false);
        Assert.assertFalse((boolean)builder.toSchema().getWarnings().isEmpty());
    }

    @Test
    public void testConstructorDefaultMatchingRules() throws Exception {
        AttributeType type = this.schema.getAttributeType("1.2.1");
        Syntax syntax = this.schema.getSyntax("1.3.6.1.4.1.1466.115.121.1.27");
        Assert.assertEquals((Object)type.getApproximateMatchingRule(), (Object)syntax.getApproximateMatchingRule());
        Assert.assertEquals((Object)type.getEqualityMatchingRule(), (Object)syntax.getEqualityMatchingRule());
        Assert.assertEquals((Object)type.getOrderingMatchingRule(), (Object)syntax.getOrderingMatchingRule());
        Assert.assertEquals((Object)type.getSubstringMatchingRule(), (Object)syntax.getSubstringMatchingRule());
    }

    @Test
    public void testConstructorDefaultUsage() throws Exception {
        AttributeType d = this.schema.getAttributeType("1.2.2");
        Assert.assertEquals((Object)d.getUsage(), (Object)AttributeUsage.USER_APPLICATIONS);
    }

    @Test(dependsOnMethods={"testConstructorMatchingRules"})
    public void testConstructorInheritsMatchingRules() throws Exception {
        AttributeType parent = this.schema.getAttributeType("1.2.5");
        AttributeType child = this.schema.getAttributeType("1.2.6");
        Assert.assertEquals((Object)parent.getApproximateMatchingRule(), (Object)child.getApproximateMatchingRule());
        Assert.assertEquals((Object)parent.getEqualityMatchingRule(), (Object)child.getEqualityMatchingRule());
        Assert.assertEquals((Object)parent.getSyntax().getOrderingMatchingRule(), (Object)child.getOrderingMatchingRule());
        Assert.assertEquals((Object)parent.getSubstringMatchingRule(), (Object)child.getSubstringMatchingRule());
    }

    @Test(dependsOnMethods={"testConstructorSyntax"})
    public void testConstructorInheritsSyntax() throws Exception {
        AttributeType parent = this.schema.getAttributeType("1.2.3");
        AttributeType child = this.schema.getAttributeType("1.2.4");
        Assert.assertEquals((Object)parent.getSyntax(), (Object)child.getSyntax());
        parent = this.schema.getAttributeType("1.2.2");
        child = this.schema.getAttributeType("1.2.3");
        Assert.assertFalse((boolean)parent.getSyntax().equals((Object)child.getSyntax()));
        child = this.schema.getAttributeType("1.2.6");
        Assert.assertEquals((String)child.getSyntax().getOID(), (String)"1.3.6.1.4.1.1466.115.121.1.15");
    }

    @Test
    public void testConstructorMatchingRules() throws Exception {
        AttributeType type = this.schema.getAttributeType("1.2.5");
        Assert.assertEquals((String)type.getEqualityMatchingRule().getOID(), (String)"2.5.13.11");
        Assert.assertEquals((String)type.getOrderingMatchingRule().getOID(), (String)type.getSyntax().getOrderingMatchingRule().getOID());
        Assert.assertEquals((String)type.getSubstringMatchingRule().getOID(), (String)"2.5.13.12");
        Assert.assertEquals((String)type.getApproximateMatchingRule().getOID(), (String)"1.3.6.1.4.1.26027.1.4.1");
    }

    @Test
    public final void testConstructorPrimaryName() throws Exception {
        AttributeType d = this.schema.getAttributeType("1.2.3");
        Assert.assertTrue((boolean)d.hasName("testType3"));
        Assert.assertFalse((boolean)d.hasName("xxx"));
        d = this.schema.getAttributeType("1.2.4");
        Assert.assertTrue((boolean)d.hasName("testType4"));
        Assert.assertFalse((boolean)d.hasName("xxx"));
    }

    @Test
    public void testConstructorSyntax() throws Exception {
        AttributeType d = this.schema.getAttributeType("1.2.2");
        Assert.assertEquals((String)d.getSyntax().getOID(), (String)"1.3.6.1.4.1.1466.115.121.1.15");
    }

    @Test
    public final void testConstructorTypeNames() throws Exception {
        AttributeType d = this.schema.getAttributeType("1.2.5");
        Assert.assertTrue((boolean)d.hasName("testType5"));
        Assert.assertTrue((boolean)d.hasName("testnamealias5"));
        Assert.assertTrue((boolean)d.hasName("anothernamealias5"));
        d = this.schema.getAttributeType("1.2.6");
        Assert.assertTrue((boolean)d.hasName("testType6"));
        Assert.assertTrue((boolean)d.hasName("testnamealias6"));
        Assert.assertTrue((boolean)d.hasName("anothernamealias6"));
    }

    @Test
    public void testGetAttributeUsage() throws Exception {
        AttributeType type = this.schema.getAttributeType("1.2.1");
        Assert.assertEquals((Object)type.getUsage(), (Object)AttributeUsage.USER_APPLICATIONS);
        type = this.schema.getAttributeType("1.2.6");
        Assert.assertEquals((Object)type.getUsage(), (Object)AttributeUsage.DSA_OPERATION);
    }

    @Test
    public final void testGetNameOrOIDReturnsOID() throws Exception {
        AttributeType d = this.schema.getAttributeType("1.2.1");
        Assert.assertEquals((String)d.getNameOrOID(), (String)"1.2.1");
        d = this.schema.getAttributeType("1.2.2");
        Assert.assertEquals((String)d.getNameOrOID(), (String)"1.2.2");
    }

    @Test
    public final void testGetNameOrOIDReturnsPrimaryName() throws Exception {
        AttributeType d = this.schema.getAttributeType("1.2.3");
        Assert.assertEquals((String)d.getNameOrOID(), (String)"testType3");
        d = this.schema.getAttributeType("1.2.4");
        Assert.assertEquals((String)d.getNameOrOID(), (String)"testType4");
    }

    @Test
    public final void testGetNormalizedNames() throws Exception {
        AttributeType d = this.schema.getAttributeType("1.2.5");
        Iterator i = d.getNames().iterator();
        Assert.assertEquals((String)((String)i.next()), (String)"testType5");
        Assert.assertEquals((String)((String)i.next()), (String)"testnamealias5");
        Assert.assertEquals((String)((String)i.next()), (String)"anothernamealias5");
        d = this.schema.getAttributeType("1.2.6");
        i = d.getNames().iterator();
        Assert.assertEquals((String)((String)i.next()), (String)"testType6");
        Assert.assertEquals((String)((String)i.next()), (String)"testnamealias6");
        Assert.assertEquals((String)((String)i.next()), (String)"anothernamealias6");
    }

    @Test
    public final void testGetOID() throws Exception {
        AttributeType d = this.schema.getAttributeType("1.2.3");
        Assert.assertEquals((String)d.getOID(), (String)"1.2.3");
        d = this.schema.getAttributeType("1.2.4");
        Assert.assertEquals((String)d.getOID(), (String)"1.2.4");
    }

    @Test
    public void testGetSuperiorType() throws Exception {
        AttributeType type = this.schema.getAttributeType("1.2.3");
        Assert.assertEquals((String)type.getSuperiorType().getOID(), (String)"1.2.2");
        type = this.schema.getAttributeType("1.2.4");
        Assert.assertEquals((String)type.getSuperiorType().getOID(), (String)"1.2.3");
    }

    @Test
    public final void testHasNameOrOID() throws Exception {
        AttributeType d = this.schema.getAttributeType("1.2.3");
        Assert.assertTrue((boolean)d.hasNameOrOID("testType3"));
        Assert.assertTrue((boolean)d.hasNameOrOID("1.2.3"));
        Assert.assertFalse((boolean)d.hasNameOrOID("x.y.z"));
        d = this.schema.getAttributeType("1.2.4");
        Assert.assertTrue((boolean)d.hasNameOrOID("testType4"));
        Assert.assertTrue((boolean)d.hasNameOrOID("1.2.4"));
        Assert.assertFalse((boolean)d.hasNameOrOID("x.y.z"));
    }

    @Test
    public void testInheritFromNonCollective() throws Exception {
        SchemaBuilder builder = new SchemaBuilder(this.schema);
        builder.addAttributeType("(1.2.8.5 NAME 'testtype' DESC 'full type'  OBSOLETE SUP 1.2.5  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE COLLECTIVE USAGE userApplications )", false);
        Assert.assertFalse((boolean)builder.toSchema().getWarnings().isEmpty());
    }

    @Test
    public void testInheritFromUserAppUsage() throws Exception {
        SchemaBuilder builder = new SchemaBuilder(this.schema);
        builder.addAttributeType("(1.2.8.5 NAME 'testtype' DESC 'full type'  OBSOLETE SUP 1.2.1  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE NO-USER-MODIFICATION USAGE directoryOperation )", false);
        Assert.assertFalse((boolean)builder.toSchema().getWarnings().isEmpty());
    }

    @Test
    public void testIsCollective() throws Exception {
        AttributeType type = this.schema.getAttributeType("1.2.2");
        Assert.assertTrue((boolean)type.isCollective());
        type = this.schema.getAttributeType("1.2.3");
        Assert.assertTrue((boolean)type.isCollective());
        type = this.schema.getAttributeType("1.2.6");
        Assert.assertFalse((boolean)type.isCollective());
        type = this.schema.getAttributeType("1.2.5");
        Assert.assertFalse((boolean)type.isCollective());
    }

    @Test
    public void testIsNoUserModification() throws Exception {
        AttributeType type = this.schema.getAttributeType("1.2.5");
        Assert.assertTrue((boolean)type.isNoUserModification());
        type = this.schema.getAttributeType("1.2.6");
        Assert.assertTrue((boolean)type.isNoUserModification());
        type = this.schema.getAttributeType("1.2.3");
        Assert.assertFalse((boolean)type.isNoUserModification());
        type = this.schema.getAttributeType("1.2.4");
        Assert.assertFalse((boolean)type.isNoUserModification());
    }

    @Test
    public final void testIsObsolete() throws Exception {
        AttributeType d = this.schema.getAttributeType("1.2.3");
        Assert.assertFalse((boolean)d.isObsolete());
        d = this.schema.getAttributeType("1.2.4");
        Assert.assertFalse((boolean)d.isObsolete());
        d = this.schema.getAttributeType("1.2.1");
        Assert.assertTrue((boolean)d.isObsolete());
        d = this.schema.getAttributeType("1.2.2");
        Assert.assertTrue((boolean)d.isObsolete());
    }

    @Test
    public void testIsSingleValue() throws Exception {
        AttributeType type = this.schema.getAttributeType("1.2.1");
        Assert.assertTrue((boolean)type.isSingleValue());
        type = this.schema.getAttributeType("1.2.2");
        Assert.assertTrue((boolean)type.isSingleValue());
        type = this.schema.getAttributeType("1.2.5");
        Assert.assertFalse((boolean)type.isSingleValue());
        type = this.schema.getAttributeType("1.2.6");
        Assert.assertFalse((boolean)type.isSingleValue());
    }

    @Test(expectedExceptions={LocalizedIllegalArgumentException.class})
    public void attributeTypeDefinitionsRequireSyntaxOrSuperiorWhenStrict1() throws Exception {
        new SchemaBuilder(Schema.getCoreSchema()).setOption(SchemaOptions.ALLOW_ATTRIBUTE_TYPES_WITH_NO_SUP_OR_SYNTAX, (Object)false).addAttributeType("(1.2.1)", true);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void attributeTypeDefinitionsRequireSyntaxOrSuperiorWhenStrict2() throws Exception {
        new SchemaBuilder(Schema.getCoreSchema()).setOption(SchemaOptions.ALLOW_ATTRIBUTE_TYPES_WITH_NO_SUP_OR_SYNTAX, (Object)false).buildAttributeType("1.2.1").addToSchema();
    }

    @Test
    public void attributeTypeDefinitionsDoNotRequireSyntaxOrSuperiorWhenTolerant1() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).addAttributeType("(1.2.1)", true).toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Comparable)schema.getAttributeType("1.2.1").getSuperiorType()).isNull();
        Assertions.assertThat((Object)schema.getAttributeType("1.2.1").getSyntax()).isSameAs((Object)schema.getDefaultSyntax());
    }

    @Test
    public void attributeTypeDefinitionsDoNotRequireSyntaxOrSuperiorWhenTolerant2() throws Exception {
        Schema schema = new SchemaBuilder(Schema.getCoreSchema()).buildAttributeType("1.2.1").addToSchema().toSchema();
        Assertions.assertThat((Iterable)schema.getWarnings()).isEmpty();
        Assertions.assertThat((Comparable)schema.getAttributeType("1.2.1").getSuperiorType()).isNull();
        Assertions.assertThat((Object)schema.getAttributeType("1.2.1").getSyntax()).isSameAs((Object)schema.getDefaultSyntax());
    }

    @Test
    public void testNoUserModNonOperational() throws Exception {
        SchemaBuilder builder = new SchemaBuilder(this.schema);
        builder.addAttributeType("(1.2.8.5 NAME 'testtype' DESC 'full type' OBSOLETE  EQUALITY caseIgnoreMatch ORDERING caseIgnoreOrderingMatch SUBSTR caseIgnoreSubstringsMatch SYNTAX 1.3.6.1.4.1.1466.115.121.1.15 SINGLE-VALUE NO-USER-MODIFICATION USAGE userApplications )", false);
        Assert.assertFalse((boolean)builder.toSchema().getWarnings().isEmpty());
    }

    @Override
    protected AbstractSchemaElement getElement(String description, Map<String, List<String>> extraProperties) throws SchemaException {
        SchemaBuilder builder = new SchemaBuilder(Schema.getCoreSchema());
        builder.buildAttributeType("1.2.3").names(new String[]{"testType"}).description(description).syntax("1.3.6.1.4.1.1466.115.121.1.27").usage(AttributeUsage.DSA_OPERATION).extraProperties(extraProperties).addToSchema();
        return builder.toSchema().getAttributeType("1.2.3");
    }

    @Test
    public void testDuplicateNamesGenerateWarnings() {
        Schema dupSchema = new SchemaBuilder(this.schema).buildAttributeType("1.2.10").names(new String[]{"testType3"}).syntax("1.3.6.1.4.1.1466.115.121.1.27").addToSchema().toSchema();
        Assertions.assertThat((Iterable)dupSchema.getWarnings()).contains((Object[])new LocalizableMessage[]{CoreMessages.WARN_ATTR_TYPES_DUPLICATED_NAME.get((Object)"1.2.3, 1.2.10", (Object)"testtype3", (Object)"testtype3", (Object)"1.2.3")});
    }
}

