/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.fest.assertions.MapAssert;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.AttributeUsage;
import org.forgerock.opendj.ldap.schema.ConflictingSchemaElementException;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AttributeTypeBuilderTestCase
extends AbstractSchemaTestCase {
    @DataProvider
    Object[][] validAttributeTypes() {
        return new Object[][]{{"1.2.3.4", Collections.singletonList("MyAttributeType"), "MyAttributeType description.", false, "2.5.4.0", "2.5.13.34", "1.3.6.1.1.16.3", "2.5.13.12", "1.3.6.1.4.1.26027.1.4.1", null, false, false, false, AttributeUsage.USER_APPLICATIONS, "New extra property", "New extra value", false}, {"2.5.4.41", Collections.singletonList("name"), "MyAttributeType description.", false, null, "2.5.13.34", null, "2.5.13.12", "1.3.6.1.4.1.26027.1.4.1", "1.3.6.1.4.1.1466.115.121.1.15", false, false, false, AttributeUsage.USER_APPLICATIONS, "New extra property", "New extra value", true}, {"1.2.3.4", Collections.emptyList(), "MyAttributeType description.", false, null, "2.5.13.11", "2.5.13.3", null, null, "1.3.6.1.4.1.1466.115.121.1.15", false, false, false, AttributeUsage.USER_APPLICATIONS, "New extra property", "New extra value", false}, {"1.2.3.4", Collections.singletonList("MyAttributeType"), "", false, null, "2.5.13.11", null, null, null, "1.3.6.1.4.1.1466.115.121.1.15", false, false, true, AttributeUsage.DIRECTORY_OPERATION, "New extra property", "New extra value", false}};
    }

    @Test(dataProvider="validAttributeTypes")
    public void testValidAttributeTypeBuilder(String oid, List<String> names, String description, boolean obsolete, String superiorType, String equalityMatchingRule, String orderingMatchingRule, String substringMatchingRule, String approximateMatchingRule, String syntax, boolean singleValue, boolean collective, boolean noUserModification, AttributeUsage attributeUsage, String extraPropertyName, String extraPropertyValue, boolean overwrite) throws Exception {
        AttributeType.Builder atBuilder = new SchemaBuilder(Schema.getCoreSchema()).buildAttributeType(oid).names(names).description(description).obsolete(obsolete).superiorType(superiorType).equalityMatchingRule(equalityMatchingRule).orderingMatchingRule(orderingMatchingRule).substringMatchingRule(substringMatchingRule).approximateMatchingRule(approximateMatchingRule).syntax(syntax).singleValue(singleValue).collective(collective).noUserModification(noUserModification).usage(attributeUsage).extraProperties(extraPropertyName, new String[]{extraPropertyValue});
        Schema schema = overwrite ? atBuilder.addToSchemaOverwrite().toSchema() : atBuilder.addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        AttributeType at = schema.getAttributeType(oid);
        Assertions.assertThat((Object)at).isNotNull();
        Assertions.assertThat((String)at.getOID()).isEqualTo((Object)oid);
        Assertions.assertThat((List)at.getNames()).containsOnly(names.toArray());
        Assertions.assertThat((String)at.getDescription()).isEqualTo((Object)description);
        Assertions.assertThat((boolean)at.isObsolete()).isEqualTo(obsolete);
        Assertions.assertThat((Map)at.getExtraProperties()).includes(new MapAssert.Entry[]{MapAssert.entry((Object)extraPropertyName, Collections.singletonList(extraPropertyValue))});
    }

    @Test
    public void testAttributeTypeBuilderDefaultValues() throws Exception {
        String testOID = "1.1.1.42";
        SchemaBuilder sb = new SchemaBuilder(Schema.getCoreSchema());
        AttributeType.Builder ocBuilder = sb.buildAttributeType("1.1.1.42").names(new String[]{"defaultAttributeType"}).syntax("1.3.6.1.4.1.1466.115.121.1.38").usage(AttributeUsage.USER_APPLICATIONS);
        Schema schema = ocBuilder.addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        AttributeType at = schema.getAttributeType("1.1.1.42");
        Assertions.assertThat((Object)at).isNotNull();
        Assertions.assertThat((String)at.getOID()).isEqualTo((Object)"1.1.1.42");
        Assertions.assertThat((List)at.getNames()).containsOnly(new Object[]{"defaultAttributeType"});
        Assertions.assertThat((String)at.getDescription()).isEqualTo((Object)"");
        Assertions.assertThat((boolean)at.isObsolete()).isFalse();
        Assertions.assertThat((Object)at.getSuperiorType()).isNull();
        Assertions.assertThat((String)at.getSyntax().getOID()).isEqualTo((Object)"1.3.6.1.4.1.1466.115.121.1.38");
        Assertions.assertThat((boolean)at.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)at.isCollective()).isFalse();
        Assertions.assertThat((boolean)at.isNoUserModification()).isFalse();
        Assertions.assertThat((Map)at.getExtraProperties()).isEmpty();
    }

    @Test
    public void testAttributeTypeBuilderCopyConstructor() throws Exception {
        SchemaBuilder sb = new SchemaBuilder(Schema.getCoreSchema());
        AttributeType.Builder atBuilder = sb.buildAttributeType("1.1.1.42").names(new String[]{"AttributeTypeToDuplicate"}).description("Attribute type to duplicate").usage(AttributeUsage.USER_APPLICATIONS).syntax("1.3.6.1.4.1.1466.115.121.1.38");
        Schema schema = atBuilder.addToSchema().toSchema();
        Assertions.assertThat((Collection)schema.getWarnings()).isEmpty();
        sb.buildAttributeType(schema.getAttributeType("AttributeTypeToDuplicate")).oid("1.1.1.43").removeAllNames().names(new String[]{"DuplicatedAttributeType", "Copy"}).obsolete(true).addToSchemaOverwrite();
        Schema schemaCopy = sb.toSchema();
        Assertions.assertThat((Collection)schemaCopy.getWarnings()).isEmpty();
        AttributeType atCopy = schemaCopy.getAttributeType("Copy");
        Assertions.assertThat((Object)atCopy).isNotNull();
        Assertions.assertThat((String)atCopy.getOID()).isEqualTo((Object)"1.1.1.43");
        Assertions.assertThat((String)atCopy.getDescription()).isEqualTo((Object)"Attribute type to duplicate");
        Assertions.assertThat((boolean)atCopy.isObsolete()).isTrue();
        Assertions.assertThat((List)atCopy.getNames()).containsOnly(new Object[]{"DuplicatedAttributeType", "Copy"});
        Assertions.assertThat((Map)atCopy.getExtraProperties()).isEmpty();
    }

    @Test(expectedExceptions={ConflictingSchemaElementException.class})
    public void testAttributeTypeBuilderDoesNotAllowOverwrite() throws Exception {
        AttributeType.Builder atBuilder = new SchemaBuilder(Schema.getCoreSchema()).buildAttributeType("2.5.4.25").description("MyAttributeType description").names(new String[]{"internationalISDNNumber"}).syntax("1.3.6.1.4.1.1466.115.121.1.38").usage(AttributeUsage.DSA_OPERATION).extraProperties("New extra property", new String[]{"New extra value"});
        atBuilder.addToSchema().toSchema();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAttributeTypeBuilderDoesNotAllowEmptyOID() throws Exception {
        AttributeType.Builder atBuilder = new SchemaBuilder(Schema.getCoreSchema()).buildAttributeType("").description("MyAttributeType description").names(new String[]{"MyAttributeType"}).syntax("OID").usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties("New extra property", new String[]{"New extra value"});
        atBuilder.addToSchema().toSchema();
    }
}

