/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ApproximateMatchingRuleTest
extends AbstractSchemaTestCase {
    MatchingRule metaphone = Schema.getCoreSchema().getMatchingRule("ds-mr-double-metaphone-approx");

    @Test(dataProvider="approximatematchingrules")
    public void approximateMatchingRules(MatchingRule rule, String value1, String value2, ConditionResult result) throws Exception {
        ByteString normalizedValue1 = rule.normalizeAttributeValue((ByteSequence)ByteString.valueOfUtf8((CharSequence)value1));
        ConditionResult liveResult = rule.getAssertion((ByteSequence)ByteString.valueOfUtf8((CharSequence)value2)).matches((ByteSequence)normalizedValue1);
        Assert.assertEquals((Object)result, (Object)liveResult);
    }

    @DataProvider(name="approximatematchingrules")
    public Object[][] createapproximateMatchingRuleTest() {
        return new Object[][]{{this.metaphone, "celebre", "selebre", ConditionResult.TRUE}, {this.metaphone, "cygale", "sigale", ConditionResult.TRUE}, {this.metaphone, "cigale", "sigale", ConditionResult.TRUE}, {this.metaphone, "accacia", "akacia", ConditionResult.TRUE}, {this.metaphone, "cigale", "sigale", ConditionResult.TRUE}, {this.metaphone, "bertucci", "bertuchi", ConditionResult.TRUE}, {this.metaphone, "manger", "manjer", ConditionResult.TRUE}, {this.metaphone, "gyei", "kei", ConditionResult.TRUE}, {this.metaphone, "agnostique", "aknostic", ConditionResult.TRUE}, {this.metaphone, "ghang", "kang", ConditionResult.TRUE}, {this.metaphone, "affiche", "afiche", ConditionResult.TRUE}, {this.metaphone, "succeed", "sukid", ConditionResult.TRUE}, {this.metaphone, "McCarthur", "macarthur", ConditionResult.TRUE}, {this.metaphone, "czet", "set", ConditionResult.TRUE}, {this.metaphone, "re\u00c7u", "ressu", ConditionResult.TRUE}, {this.metaphone, "ni\u00d1o", "nino", ConditionResult.TRUE}, {this.metaphone, "bateaux", "bateau", ConditionResult.TRUE}, {this.metaphone, "witz", "wits", ConditionResult.TRUE}, {this.metaphone, "barre", "bare", ConditionResult.TRUE}, {this.metaphone, "write", "rite", ConditionResult.TRUE}, {this.metaphone, "the", "ze", ConditionResult.FALSE}, {this.metaphone, "motion", "mochion", ConditionResult.TRUE}, {this.metaphone, "bois", "boi", ConditionResult.TRUE}, {this.metaphone, "schi", "chi", ConditionResult.TRUE}, {this.metaphone, "escalier", "eskalier", ConditionResult.TRUE}, {this.metaphone, "science", "sience", ConditionResult.TRUE}, {this.metaphone, "school", "skool", ConditionResult.TRUE}, {this.metaphone, "swap", "sap", ConditionResult.TRUE}, {this.metaphone, "szize", "size", ConditionResult.TRUE}, {this.metaphone, "shoek", "choek", ConditionResult.FALSE}, {this.metaphone, "sugar", "chugar", ConditionResult.TRUE}, {this.metaphone, "isle", "ile", ConditionResult.TRUE}, {this.metaphone, "yle", "ysle", ConditionResult.TRUE}, {this.metaphone, "focaccia", "focashia", ConditionResult.TRUE}, {this.metaphone, "machine", "mashine", ConditionResult.TRUE}, {this.metaphone, "michael", "mikael", ConditionResult.TRUE}, {this.metaphone, "abba", "aba", ConditionResult.TRUE}, {this.metaphone, "caesar", "saesar", ConditionResult.TRUE}, {this.metaphone, "femme", "fame", ConditionResult.TRUE}, {this.metaphone, "panne", "pane", ConditionResult.TRUE}, {this.metaphone, "josa", "josa", ConditionResult.TRUE}, {this.metaphone, "jose", "hose", ConditionResult.TRUE}, {this.metaphone, "hello", "hello", ConditionResult.TRUE}, {this.metaphone, "hello", "ello", ConditionResult.FALSE}, {this.metaphone, "bag", "bak", ConditionResult.TRUE}, {this.metaphone, "bagg", "bag", ConditionResult.TRUE}, {this.metaphone, "tagliaro", "takliaro", ConditionResult.TRUE}, {this.metaphone, "biaggi", "biaji", ConditionResult.TRUE}, {this.metaphone, "bioggi", "bioji", ConditionResult.TRUE}, {this.metaphone, "rough", "rouf", ConditionResult.TRUE}, {this.metaphone, "ghislane", "jislane", ConditionResult.TRUE}, {this.metaphone, "ghaslane", "kaslane", ConditionResult.TRUE}, {this.metaphone, "odd", "ot", ConditionResult.TRUE}, {this.metaphone, "edgar", "etkar", ConditionResult.TRUE}, {this.metaphone, "edge", "eje", ConditionResult.TRUE}, {this.metaphone, "accord", "akord", ConditionResult.TRUE}, {this.metaphone, "noize", "noise", ConditionResult.TRUE}, {this.metaphone, "orchid", "orkid", ConditionResult.TRUE}, {this.metaphone, "chemistry", "kemistry", ConditionResult.TRUE}, {this.metaphone, "chianti", "kianti", ConditionResult.TRUE}, {this.metaphone, "bacher", "baker", ConditionResult.TRUE}, {this.metaphone, "achtung", "aktung", ConditionResult.TRUE}, {this.metaphone, "Writing", "riting", ConditionResult.TRUE}, {this.metaphone, "xeon", "zeon", ConditionResult.TRUE}, {this.metaphone, "lonely", "loneli", ConditionResult.TRUE}, {this.metaphone, "bellaton", "belatton", ConditionResult.TRUE}, {this.metaphone, "pate", "patte", ConditionResult.TRUE}, {this.metaphone, "voiture", "vouatur", ConditionResult.TRUE}, {this.metaphone, "garbage", "garbedge", ConditionResult.TRUE}, {this.metaphone, "algorithme", "algorizm", ConditionResult.TRUE}, {this.metaphone, "testing", "testng", ConditionResult.TRUE}, {this.metaphone, "announce", "annonce", ConditionResult.TRUE}, {this.metaphone, "automaticly", "automatically", ConditionResult.TRUE}, {this.metaphone, "modifyd", "modified", ConditionResult.TRUE}, {this.metaphone, "bouteille", "butaille", ConditionResult.TRUE}, {this.metaphone, "xeon", "zeon", ConditionResult.TRUE}, {this.metaphone, "achtung", "aktung", ConditionResult.TRUE}, {this.metaphone, "throttle", "throddle", ConditionResult.TRUE}, {this.metaphone, "thimble", "thimblle", ConditionResult.TRUE}, {this.metaphone, "", "", ConditionResult.TRUE}};
    }
}

