/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.AbstractSubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.MatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.forgerock.opendj.ldap.spi.Indexer;
import org.forgerock.opendj.ldap.spi.IndexingOptions;
import org.forgerock.util.Utils;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AbstractSubstringMatchingRuleImplTest
extends AbstractSchemaTestCase {
    private int subStringLength = 3;

    private MatchingRuleImpl getRule() {
        return new FakeSubstringMatchingRuleImpl();
    }

    static IndexingOptions newIndexingOptions() {
        return AbstractSubstringMatchingRuleImplTest.newIndexingOptions(3);
    }

    static IndexingOptions newIndexingOptions(int subStringLength) {
        IndexingOptions options = (IndexingOptions)Mockito.mock(IndexingOptions.class);
        Mockito.when((Object)options.substringKeySize()).thenReturn((Object)subStringLength);
        return options;
    }

    @DataProvider
    public Object[][] invalidAssertions() {
        return new Object[][]{{""}, {"abc"}, {"**"}, {"\\g"}, {"\\0"}, {"\\00"}, {"\\0g"}, {this.gen()}};
    }

    @Test(dataProvider="invalidAssertions", expectedExceptions={DecodeException.class})
    public void testInvalidAssertion(String assertionValue) throws Exception {
        this.getRule().getAssertion(null, (ByteSequence)ByteString.valueOfUtf8((CharSequence)assertionValue));
    }

    @DataProvider
    public Object[][] validAssertions() {
        return new Object[][]{{"this is a string", "*", ConditionResult.TRUE}, {"this is a string", "that*", ConditionResult.FALSE}, {"this is a string", "*that", ConditionResult.FALSE}, {"this is a string", "this*is*a*string", ConditionResult.TRUE}, {"this is a string", "this*my*string", ConditionResult.FALSE}, {"this is a string", "string*a*is*this", ConditionResult.FALSE}, {"this is a string", "string*a*is*this", ConditionResult.FALSE}, {"this is a string", "*\\00", ConditionResult.FALSE}, {"this is a string", this.gen() + "*", ConditionResult.FALSE}, {"tt", "this*", ConditionResult.FALSE}, {"tt", "*this", ConditionResult.FALSE}};
    }

    private String gen() {
        char[] array = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder sb = new StringBuilder();
        for (char c : array) {
            sb.append("\\").append(c).append(c);
        }
        return sb.toString();
    }

    private String subStringIndexID(String matchingRule) {
        return matchingRule + ":" + this.subStringLength;
    }

    @Test(dataProvider="validAssertions")
    public void testValidAssertions(String attrValue, String assertionValue, ConditionResult expected) throws Exception {
        MatchingRuleImpl rule = this.getRule();
        ByteString normValue = rule.normalizeAttributeValue(null, (ByteSequence)ByteString.valueOfUtf8((CharSequence)attrValue));
        Assertion assertion = rule.getAssertion(null, (ByteSequence)ByteString.valueOfUtf8((CharSequence)assertionValue));
        Assert.assertEquals((Object)assertion.matches((ByteSequence)normValue), (Object)expected);
    }

    @Test
    public void testSubstringCreateIndexQueryForFinalWithMultipleSubqueries() throws Exception {
        Assertion assertion = this.getRule().getSubstringAssertion(null, null, Collections.EMPTY_LIST, (ByteSequence)ByteString.valueOfUtf8((CharSequence)"this"));
        Assert.assertEquals((String)((String)assertion.createIndexQuery((IndexQueryFactory)new FakeIndexQueryFactory(AbstractSubstringMatchingRuleImplTest.newIndexingOptions(this.subStringLength)))), (String)("intersect[exactMatch(" + this.subStringIndexID("2.5.13.7") + ", value=='his'), exactMatch(" + this.subStringIndexID("2.5.13.7") + ", value=='thi')]"));
    }

    @Test
    public void testSubstringCreateIndexQueryForAllNoSubqueries() throws Exception {
        Assertion assertion = this.getRule().getSubstringAssertion(null, (ByteSequence)ByteString.valueOfUtf8((CharSequence)"abc"), Arrays.asList(this.toByteStrings("def", "ghi")), (ByteSequence)ByteString.valueOfUtf8((CharSequence)"jkl"));
        Assert.assertEquals((String)((String)assertion.createIndexQuery((IndexQueryFactory)new FakeIndexQueryFactory(AbstractSubstringMatchingRuleImplTest.newIndexingOptions(this.subStringLength)))), (String)("intersect[rangeMatch(2.5.13.5, 'abc' <= value < 'abd'), exactMatch(" + this.subStringIndexID("2.5.13.7") + ", value=='def'), exactMatch(" + this.subStringIndexID("2.5.13.7") + ", value=='ghi'), exactMatch(" + this.subStringIndexID("2.5.13.7") + ", value=='jkl'), exactMatch(" + this.subStringIndexID("2.5.13.7") + ", value=='abc')]"));
    }

    @Test
    public void testSubstringCreateIndexQueryWithInitial() throws Exception {
        Assertion assertion = this.getRule().getSubstringAssertion(null, (ByteSequence)ByteString.valueOfUtf8((CharSequence)"aa"), Collections.EMPTY_LIST, null);
        Assert.assertEquals((String)((String)assertion.createIndexQuery((IndexQueryFactory)new FakeIndexQueryFactory(AbstractSubstringMatchingRuleImplTest.newIndexingOptions(this.subStringLength)))), (String)("intersect[rangeMatch(2.5.13.5, 'aa' <= value < 'ab'), rangeMatch(" + this.subStringIndexID("2.5.13.7") + ", 'aa' <= value < 'ab')]"));
    }

    @Test
    public void testSubstringCreateIndexQueryWithInitialOverflowsInRange() throws Exception {
        ByteString lower = ByteString.wrap((byte[])new byte[]{97, -1});
        Assertion assertion = this.getRule().getSubstringAssertion(null, (ByteSequence)lower, Collections.EMPTY_LIST, null);
        Assert.assertEquals((String)((String)assertion.createIndexQuery((IndexQueryFactory)new FakeIndexQueryFactory(AbstractSubstringMatchingRuleImplTest.newIndexingOptions(this.subStringLength)))), (String)("intersect[rangeMatch(2.5.13.5, '" + lower + "' <= value < 'b\u0000'), rangeMatch(" + this.subStringIndexID("2.5.13.7") + ", '" + lower + "' <= value < 'b\u0000')]"));
    }

    @Test
    public void testIndexer() throws Exception {
        IndexingOptions options = AbstractSubstringMatchingRuleImplTest.newIndexingOptions();
        Indexer indexer = (Indexer)this.getRule().createIndexers(options).iterator().next();
        Assertions.assertThat((String)indexer.getIndexID()).isEqualTo((Object)("2.5.13.7:" + options.substringKeySize()));
        TreeSet keys = new TreeSet();
        indexer.createKeys(Schema.getCoreSchema(), (ByteSequence)ByteString.valueOfUtf8((CharSequence)"ABCDE"), keys);
        Assertions.assertThat(keys).containsOnly((Object[])this.toByteStrings("ABC", "BCD", "CDE", "DE", "E"));
    }

    private ByteString[] toByteStrings(String ... strings) {
        ByteString[] results = new ByteString[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            results[i] = ByteString.valueOfUtf8((CharSequence)strings[i]);
        }
        return results;
    }

    static class FakeIndexQueryFactory
    implements IndexQueryFactory<String> {
        private final IndexingOptions options;
        private final boolean normalizedValuesAreReadable;

        public FakeIndexQueryFactory(IndexingOptions options) {
            this(options, true);
        }

        public FakeIndexQueryFactory(IndexingOptions options, boolean normalizedValuesAreReadable) {
            this.options = options;
            this.normalizedValuesAreReadable = normalizedValuesAreReadable;
        }

        public String createExactMatchQuery(String indexID, ByteSequence key) {
            String keyValue = this.normalizedValuesAreReadable ? key.toString() : key.toByteString().toHexString();
            return "exactMatch(" + indexID + ", value=='" + keyValue + "')";
        }

        public String createMatchAllQuery() {
            return "matchAll()";
        }

        public String createRangeMatchQuery(String indexID, ByteSequence lower, ByteSequence upper, boolean lowerIncluded, boolean upperIncluded) {
            StringBuilder sb = new StringBuilder("rangeMatch");
            sb.append("(");
            sb.append(indexID);
            sb.append(", '");
            if (this.normalizedValuesAreReadable) {
                sb.append(lower);
            } else if (!lower.isEmpty()) {
                sb.append(lower.toByteString().toHexString());
            }
            sb.append("' <");
            if (lowerIncluded) {
                sb.append("=");
            }
            sb.append(" value <");
            if (upperIncluded) {
                sb.append("=");
            }
            sb.append(" '");
            if (this.normalizedValuesAreReadable) {
                sb.append(upper);
            } else if (!upper.isEmpty()) {
                sb.append(upper.toByteString().toHexString());
            }
            sb.append("')");
            return sb.toString();
        }

        public String createIntersectionQuery(Collection<String> subqueries) {
            return "intersect[" + Utils.joinAsString((String)", ", subqueries) + "]";
        }

        public String createUnionQuery(Collection<String> subqueries) {
            return "union[" + Utils.joinAsString((String)", ", subqueries) + "]";
        }

        public IndexingOptions getIndexingOptions() {
            return this.options;
        }
    }

    private static class FakeSubstringMatchingRuleImpl
    extends AbstractSubstringMatchingRuleImpl {
        FakeSubstringMatchingRuleImpl() {
            super("2.5.13.7", "2.5.13.5");
        }

        public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
            return value.toByteString();
        }
    }
}

