/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSchemaElement;
import org.forgerock.opendj.ldap.schema.AbstractSchemaTestCase;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class AbstractSchemaElementTestCase
extends AbstractSchemaTestCase {
    protected static final Map<String, List<String>> EMPTY_PROPS = Collections.emptyMap();
    protected static final List<String> EMPTY_NAMES = Collections.emptyList();

    @DataProvider(name="equalsTestData")
    public abstract Object[][] createEqualsTestData() throws SchemaException, DecodeException;

    @Test(dataProvider="equalsTestData")
    public final void testEquals(AbstractSchemaElement e1, AbstractSchemaElement e2, boolean result) throws Exception {
        Assert.assertEquals((boolean)e1.equals((Object)e2), (boolean)result);
        Assert.assertEquals((boolean)e2.equals((Object)e1), (boolean)result);
    }

    @Test
    public final void testGetDescription() throws Exception {
        AbstractSchemaElement e = this.getElement("hello", EMPTY_PROPS);
        Assert.assertEquals((String)e.getDescription(), (String)"hello");
    }

    @Test
    public final void testGetDescriptionDefault() throws Exception {
        AbstractSchemaElement e = this.getElement("", EMPTY_PROPS);
        Assert.assertEquals((String)e.getDescription(), (String)"");
    }

    @Test
    public final void testGetExtraProperty() throws Exception {
        ArrayList<String> values = new ArrayList<String>();
        values.add("one");
        values.add("two");
        Map<String, List<String>> props = Collections.singletonMap("test", values);
        AbstractSchemaElement e = this.getElement("", props);
        int i = 0;
        for (String value : (List)e.getExtraProperties().get("test")) {
            Assert.assertEquals((String)value, (String)((String)values.get(i)));
            ++i;
        }
    }

    @Test
    public final void testGetExtraPropertyDefault() throws Exception {
        AbstractSchemaElement e = this.getElement("", EMPTY_PROPS);
        Assert.assertNull(e.getExtraProperties().get("test"));
    }

    @Test(dataProvider="equalsTestData")
    public final void testHashCode(AbstractSchemaElement e1, AbstractSchemaElement e2, boolean result) throws Exception {
        Assert.assertEquals((e1.hashCode() == e2.hashCode() ? 1 : 0) != 0, (boolean)result);
    }

    protected abstract AbstractSchemaElement getElement(String var1, Map<String, List<String>> var2) throws SchemaException;
}

