/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.RequestsTestCase;
import org.forgerock.opendj.ldap.requests.WhoAmIExtendedRequest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class WhoAmIExtendedRequestTestCase
extends RequestsTestCase {
    private static final WhoAmIExtendedRequest NEW_WHOAMIEXTENDED_REQUEST = Requests.newWhoAmIExtendedRequest();

    @DataProvider(name="whoAmIExtendedRequests")
    private Object[][] getWhoAmIExtendedRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected WhoAmIExtendedRequest[] newInstance() {
        return new WhoAmIExtendedRequest[]{NEW_WHOAMIEXTENDED_REQUEST};
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfWhoAmIExtendedRequest((WhoAmIExtendedRequest)((WhoAmIExtendedRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableWhoAmIExtendedRequest((WhoAmIExtendedRequest)((WhoAmIExtendedRequest)original));
    }

    @Test(dataProvider="whoAmIExtendedRequests")
    public void testModifiableRequest(WhoAmIExtendedRequest original) {
        WhoAmIExtendedRequest copy = (WhoAmIExtendedRequest)this.copyOf((Request)original);
        Assertions.assertThat((String)copy.getOID()).isEqualTo((Object)original.getOID());
        Assertions.assertThat((Object)copy.getResultDecoder()).isEqualTo((Object)original.getResultDecoder());
        Assertions.assertThat((Object)copy.getValue()).isEqualTo((Object)original.getValue());
    }

    @Test(dataProvider="whoAmIExtendedRequests")
    public void testUnmodifiableRequest(WhoAmIExtendedRequest original) {
        WhoAmIExtendedRequest unmodifiable = (WhoAmIExtendedRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((String)unmodifiable.getOID()).isEqualTo((Object)original.getOID());
        Assertions.assertThat((Object)unmodifiable.getResultDecoder()).isEqualTo((Object)original.getResultDecoder());
        Assertions.assertThat((Object)unmodifiable.getValue()).isEqualTo((Object)original.getValue());
    }

    @Test(dataProvider="whoAmIExtendedRequests")
    public void testUnmodifiableRequestHasResult(WhoAmIExtendedRequest original) {
        WhoAmIExtendedRequest unmodifiable = (WhoAmIExtendedRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((boolean)unmodifiable.hasValue()).isFalse();
    }

    @Test(dataProvider="whoAmIExtendedRequests")
    public void testModifiableRequestDecode(WhoAmIExtendedRequest original) throws DecodeException {
        GenericControl control = GenericControl.newControl((String)"1.2.3".intern());
        WhoAmIExtendedRequest copy = (WhoAmIExtendedRequest)this.copyOf((Request)original);
        copy.addControl((Control)control);
        Assertions.assertThat((boolean)original.getControls().contains(control)).isFalse();
        WhoAmIExtendedRequest decoded = (WhoAmIExtendedRequest)WhoAmIExtendedRequest.DECODER.decodeExtendedRequest((ExtendedRequest)copy, new DecodeOptions());
        Assertions.assertThat((boolean)decoded.getControls().contains(control)).isTrue();
    }
}

