/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.RequestsTestCase;
import org.forgerock.opendj.ldap.requests.StartTLSExtendedRequest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class StartTLSExtendedRequestTestCase
extends RequestsTestCase {
    @DataProvider(name="StartTLSExtendedRequests")
    private Object[][] getPlainSASLBindRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected StartTLSExtendedRequest[] newInstance() {
        try {
            return new StartTLSExtendedRequest[]{Requests.newStartTLSExtendedRequest((SSLContext)SSLContext.getDefault())};
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfStartTLSExtendedRequest((StartTLSExtendedRequest)((StartTLSExtendedRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableStartTLSExtendedRequest((StartTLSExtendedRequest)((StartTLSExtendedRequest)original));
    }

    @Test(dataProvider="StartTLSExtendedRequests")
    public void testModifiableRequest(StartTLSExtendedRequest original) throws NoSuchAlgorithmException {
        StartTLSExtendedRequest copy = (StartTLSExtendedRequest)this.copyOf((Request)original);
        copy.setSSLContext(SSLContext.getInstance("TLS"));
        Assertions.assertThat((String)copy.getSSLContext().getProtocol()).isEqualTo((Object)"TLS");
        Assertions.assertThat((String)original.getSSLContext().getProtocol()).isEqualTo((Object)"Default");
    }

    @Test(dataProvider="StartTLSExtendedRequests")
    public void testUnmodifiableRequest(StartTLSExtendedRequest original) {
        StartTLSExtendedRequest unmodifiable = (StartTLSExtendedRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((Object)unmodifiable.getSSLContext()).isEqualTo((Object)original.getSSLContext());
        Assertions.assertThat((String)original.getSSLContext().getProtocol()).isEqualTo((Object)"Default");
        Assertions.assertThat((String)unmodifiable.getOID()).isEqualTo((Object)original.getOID());
    }

    @Test(dataProvider="StartTLSExtendedRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableAddEnabledCipherSuite(StartTLSExtendedRequest original) throws NoSuchAlgorithmException {
        StartTLSExtendedRequest unmodifiable = (StartTLSExtendedRequest)this.unmodifiableOf((Request)original);
        unmodifiable.addEnabledCipherSuite(new String[]{"suite"});
    }

    @Test(dataProvider="StartTLSExtendedRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableAddEnabledProtocol(StartTLSExtendedRequest original) throws NoSuchAlgorithmException {
        StartTLSExtendedRequest unmodifiable = (StartTLSExtendedRequest)this.unmodifiableOf((Request)original);
        unmodifiable.addEnabledProtocol(new String[]{"SSL", "TLS"});
    }

    @Test(dataProvider="StartTLSExtendedRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetAuthenticationID(StartTLSExtendedRequest original) throws NoSuchAlgorithmException {
        StartTLSExtendedRequest unmodifiable = (StartTLSExtendedRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setSSLContext(SSLContext.getInstance("SSL"));
    }

    @Test(dataProvider="StartTLSExtendedRequests")
    public void testModifiableRequestDecode(StartTLSExtendedRequest original) throws DecodeException, NoSuchAlgorithmException {
        GenericControl control = GenericControl.newControl((String)"1.2.3".intern());
        StartTLSExtendedRequest copy = (StartTLSExtendedRequest)this.copyOf((Request)original);
        copy.addControl((Control)control);
        copy.addEnabledCipherSuite(new String[]{"TLSv1"});
        copy.addEnabledProtocol(new String[]{"TLS"});
        copy.setSSLContext(SSLContext.getInstance("TLS"));
        Assertions.assertThat((boolean)original.getControls().contains(control)).isFalse();
        Assertions.assertThat((boolean)original.getEnabledCipherSuites().contains("TLSv1")).isFalse();
        Assertions.assertThat((String)original.getSSLContext().getProtocol()).isNotEqualTo((Object)"TLS");
        Assertions.assertThat((boolean)copy.getEnabledCipherSuites().contains("TLSv1")).isTrue();
        Assertions.assertThat((String)copy.getSSLContext().getProtocol()).isEqualTo((Object)"TLS");
        StartTLSExtendedRequest decoded = (StartTLSExtendedRequest)StartTLSExtendedRequest.DECODER.decodeExtendedRequest((ExtendedRequest)copy, new DecodeOptions());
        Assertions.assertThat((boolean)decoded.getControls().contains(control)).isTrue();
    }
}

