/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.requests.BindRequestTestCase;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SimpleBindRequestTestCase
extends BindRequestTestCase {
    private static final SimpleBindRequest NEW_SIMPLE_BIND_REQUEST = Requests.newSimpleBindRequest();
    private static final SimpleBindRequest NEW_SIMPLE_BIND_REQUEST2 = Requests.newSimpleBindRequest((String)"username", (char[])"password".toCharArray());

    @DataProvider(name="simpleBindRequests")
    private Object[][] getSimpleBindRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected SimpleBindRequest[] newInstance() {
        return new SimpleBindRequest[]{NEW_SIMPLE_BIND_REQUEST, NEW_SIMPLE_BIND_REQUEST2};
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfSimpleBindRequest((SimpleBindRequest)((SimpleBindRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableSimpleBindRequest((SimpleBindRequest)((SimpleBindRequest)original));
    }

    @Test(dataProvider="simpleBindRequests")
    public void testModifiableRequest(SimpleBindRequest original) {
        String name = "user.0";
        String password = "pass99";
        SimpleBindRequest copy = (SimpleBindRequest)this.copyOf((Request)original);
        copy.setName("user.0");
        copy.setPassword("pass99".getBytes());
        Assertions.assertThat((String)copy.getName()).isEqualTo((Object)"user.0");
        Assertions.assertThat((byte[])copy.getPassword()).isEqualTo("pass99".getBytes());
        Assertions.assertThat((byte)copy.getAuthenticationType()).isEqualTo(original.getAuthenticationType());
        Assertions.assertThat((String)original.getName()).isNotEqualTo((Object)copy.getName());
        Assertions.assertThat((byte[])original.getPassword()).isNotEqualTo(copy.getPassword());
    }

    @Test(dataProvider="simpleBindRequests")
    public void testUnmodifiableRequest(SimpleBindRequest original) {
        SimpleBindRequest unmodifiable = (SimpleBindRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((byte)unmodifiable.getAuthenticationType()).isEqualTo(original.getAuthenticationType());
        Assertions.assertThat((String)unmodifiable.getName()).isEqualTo((Object)original.getName());
        Assertions.assertThat((byte[])unmodifiable.getPassword()).isEqualTo(original.getPassword());
    }

    @Test(dataProvider="simpleBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetName2(SimpleBindRequest original) {
        SimpleBindRequest unmodifiable = (SimpleBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setName("uid=scarter,ou=people,dc=example,dc=com");
    }

    @Test(dataProvider="simpleBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetPassword(SimpleBindRequest original) {
        SimpleBindRequest unmodifiable = (SimpleBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setPassword("password".toCharArray());
    }

    @Test(dataProvider="simpleBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetPassword2(SimpleBindRequest original) {
        SimpleBindRequest unmodifiable = (SimpleBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setPassword("password".getBytes());
    }
}

