/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DereferenceAliasesPolicy;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.RequestsTestCase;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SearchRequestTestCase
extends RequestsTestCase {
    private static final SearchRequest NEW_SEARCH_REQUEST = Requests.newSearchRequest((String)"uid=user.0,ou=people,o=test", (SearchScope)SearchScope.BASE_OBJECT, (String)"(uid=user)", (String[])new String[]{"uid", "ou"});
    private static final SearchRequest NEW_SEARCH_REQUEST2 = Requests.newSearchRequest((String)"uid=user.0,ou=people,o=test", (SearchScope)SearchScope.SINGLE_LEVEL, (String)"(uid=user)", (String[])new String[]{"uid", "ou"});

    @DataProvider(name="SearchRequests")
    private Object[][] getSearchRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected SearchRequest[] newInstance() {
        return new SearchRequest[]{NEW_SEARCH_REQUEST, NEW_SEARCH_REQUEST2};
    }

    @Test
    public void createRequestForSingleEntrySearch() throws Exception {
        SearchRequest request = Requests.newSingleEntrySearchRequest((DN)DN.valueOf((String)"uid=user.0,ou=people,o=test"), (SearchScope)SearchScope.BASE_OBJECT, (Filter)Filter.equality((String)"uid", (Object)"user"), (String[])new String[]{"uid"});
        Assertions.assertThat((int)request.getSizeLimit()).isEqualTo(1);
        Assertions.assertThat((boolean)request.isSingleEntrySearch()).isTrue();
    }

    @Test
    public void createRequestForSingleEntrySearchWithStrings() throws Exception {
        SearchRequest request = Requests.newSingleEntrySearchRequest((String)"uid=user.0,ou=people,o=test", (SearchScope)SearchScope.BASE_OBJECT, (String)"(uid=user)", (String[])new String[]{"uid"});
        Assertions.assertThat((int)request.getSizeLimit()).isEqualTo(1);
        Assertions.assertThat((boolean)request.isSingleEntrySearch()).isTrue();
    }

    @Test
    public void createRequestWithBaseObjectScope() throws Exception {
        SearchRequest request = Requests.newSearchRequest((DN)DN.valueOf((String)"uid=user.0,ou=people,o=test"), (SearchScope)SearchScope.BASE_OBJECT, (Filter)Filter.equality((String)"uid", (Object)"user"), (String[])new String[]{"uid"});
        Assertions.assertThat((boolean)request.isSingleEntrySearch()).isTrue();
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfSearchRequest((SearchRequest)((SearchRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableSearchRequest((SearchRequest)((SearchRequest)original));
    }

    @Test(dataProvider="SearchRequests")
    public void testModifiableRequest(SearchRequest original) {
        String name = "uid=bjensen";
        Filter filter = Filter.format((String)"(&(uid=%s)(age>=%s))", (Object[])new Object[]{"bjensen", 21});
        SearchScope scope = SearchScope.BASE_OBJECT;
        DereferenceAliasesPolicy policy = DereferenceAliasesPolicy.ALWAYS;
        int timeLimit = 10;
        int sizeLimit = 15;
        SearchRequest copy = (SearchRequest)this.copyOf((Request)original);
        copy.setName("uid=bjensen");
        copy.setFilter(filter);
        copy.setScope(scope);
        copy.setDereferenceAliasesPolicy(policy);
        copy.setSizeLimit(15);
        copy.setTimeLimit(10);
        copy.setTypesOnly(true);
        Assertions.assertThat((String)copy.getName().toString()).isEqualTo((Object)"uid=bjensen");
        Assertions.assertThat((Object)copy.getFilter()).isEqualTo((Object)filter);
        Assertions.assertThat((Object)copy.getScope()).isEqualTo((Object)scope);
        Assertions.assertThat((Object)copy.getDereferenceAliasesPolicy()).isEqualTo((Object)policy);
        Assertions.assertThat((int)copy.getTimeLimit()).isEqualTo(10);
        Assertions.assertThat((int)copy.getSizeLimit()).isEqualTo(15);
        Assertions.assertThat((boolean)copy.isTypesOnly()).isTrue();
    }

    @Test(dataProvider="SearchRequests")
    public void testUnmodifiableRequest(SearchRequest original) {
        SearchRequest unmodifiable = (SearchRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((String)unmodifiable.getName().toString()).isEqualTo((Object)original.getName().toString());
        Assertions.assertThat((Object)unmodifiable.getFilter()).isEqualTo((Object)original.getFilter());
        Assertions.assertThat((Object)unmodifiable.getScope()).isEqualTo((Object)original.getScope());
        Assertions.assertThat((Object)unmodifiable.getDereferenceAliasesPolicy()).isEqualTo((Object)original.getDereferenceAliasesPolicy());
        Assertions.assertThat((int)unmodifiable.getTimeLimit()).isEqualTo(original.getTimeLimit());
        Assertions.assertThat((int)unmodifiable.getSizeLimit()).isEqualTo(original.getSizeLimit());
    }

    @Test(dataProvider="SearchRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetDereferenceAliasesPolicy(SearchRequest original) {
        SearchRequest unmodifiable = (SearchRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setDereferenceAliasesPolicy(DereferenceAliasesPolicy.ALWAYS);
    }

    @Test(dataProvider="SearchRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetFilter(SearchRequest original) {
        SearchRequest unmodifiable = (SearchRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setFilter(Filter.format((String)"(&(cn=%s)(age>=%s))", (Object[])new Object[]{"bjensen", 21}));
    }

    @Test(dataProvider="SearchRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetFilter2(SearchRequest original) {
        SearchRequest unmodifiable = (SearchRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setFilter("(&(cn=bjensen)(age>=21))");
    }

    @Test(dataProvider="SearchRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetName(SearchRequest original) {
        SearchRequest unmodifiable = (SearchRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setName("uid=scarter,ou=people,dc=example,dc=com");
    }

    @Test(dataProvider="SearchRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetName2(SearchRequest original) {
        SearchRequest unmodifiable = (SearchRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setName(DN.valueOf((String)"uid=scarter,ou=people,dc=example,dc=com"));
    }

    @Test(dataProvider="SearchRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetScope(SearchRequest original) {
        SearchRequest unmodifiable = (SearchRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setScope(SearchScope.BASE_OBJECT);
    }

    @Test(dataProvider="SearchRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetSizeLimit(SearchRequest original) {
        SearchRequest unmodifiable = (SearchRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setSizeLimit(10);
    }

    @Test(dataProvider="SearchRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetTimeLimit(SearchRequest original) {
        SearchRequest unmodifiable = (SearchRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setTimeLimit(200);
    }

    @Test(dataProvider="SearchRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetTypesOnly(SearchRequest original) {
        SearchRequest unmodifiable = (SearchRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setTypesOnly(false);
    }
}

