/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.TestCaseUtils;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.testng.ForgeRockTestCase;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"precommit", "requests", "sdk"})
public abstract class RequestsTestCase
extends ForgeRockTestCase {
    private static final GenericControl NEW_CONTROL = GenericControl.newControl((String)"1.2.3".intern());
    private static final GenericControl NEW_CONTROL2 = GenericControl.newControl((String)"3.4.5".intern());
    private static final GenericControl NEW_CONTROL3 = GenericControl.newControl((String)"6.7.8".intern());
    private static final GenericControl NEW_CONTROL4 = GenericControl.newControl((String)"8.9.0".intern());

    @BeforeClass
    public void startServer() throws Exception {
        TestCaseUtils.startServer();
    }

    protected abstract Request[] newInstance();

    protected abstract Request copyOf(Request var1);

    protected abstract Request unmodifiableOf(Request var1);

    @DataProvider(name="createModifiableInstance")
    final Object[][] createModifiableInstance() throws Exception {
        Request[] requestArray = this.newInstance();
        Object[][] objectArray = new Object[requestArray.length][1];
        for (int i = 0; i < requestArray.length; ++i) {
            objectArray[i][0] = requestArray[i];
        }
        return objectArray;
    }

    @DataProvider(name="createCopyOfInstance")
    final Object[][] createCopyOfInstance() throws Exception {
        Request[] requestArray = this.newInstance();
        Object[][] objectArray = new Object[requestArray.length][2];
        for (int i = 0; i < requestArray.length; ++i) {
            objectArray[i][0] = requestArray[i];
            objectArray[i][1] = this.copyOf(requestArray[i]);
        }
        return objectArray;
    }

    @DataProvider(name="createUnmodifiableInstance")
    final Object[][] createUnmodifiableInstance() throws Exception {
        Request[] requestArray = this.newInstance();
        Object[][] objectArray = new Object[requestArray.length][2];
        for (int i = 0; i < requestArray.length; ++i) {
            objectArray[i][0] = requestArray[i];
            objectArray[i][1] = this.unmodifiableOf(requestArray[i]);
        }
        return objectArray;
    }

    @Test(dataProvider="createModifiableInstance")
    public void testAddControl(Request request) throws DecodeException {
        Assertions.assertThat((boolean)request.containsControl(NEW_CONTROL.getOID())).isFalse();
        request.addControl((Control)NEW_CONTROL);
        Assertions.assertThat((boolean)request.containsControl(NEW_CONTROL.getOID())).isTrue();
        Assert.assertTrue((request.getControls().size() > 0 ? 1 : 0) != 0);
        MyDecoder decoder = new MyDecoder();
        Control control = request.getControl((ControlDecoder)decoder, new DecodeOptions());
        Assert.assertNotNull((Object)control);
    }

    @Test(dataProvider="createUnmodifiableInstance", expectedExceptions={UnsupportedOperationException.class})
    public void testAddControlUnmodifiable(Request original, Request unmodifiable) {
        Assertions.assertThat((boolean)unmodifiable.containsControl(NEW_CONTROL2.getOID())).isFalse();
        Assertions.assertThat((boolean)original.containsControl(NEW_CONTROL2.getOID())).isFalse();
        original.addControl((Control)NEW_CONTROL2);
        Assertions.assertThat((boolean)original.containsControl(NEW_CONTROL2.getOID())).isTrue();
        Assertions.assertThat((boolean)unmodifiable.containsControl(NEW_CONTROL2.getOID())).isTrue();
        unmodifiable.addControl((Control)NEW_CONTROL3);
    }

    @Test(dataProvider="createCopyOfInstance")
    public void testAddControlToCopy(Request original, Request copy) {
        Assertions.assertThat((boolean)original.containsControl(NEW_CONTROL3.getOID())).isFalse();
        Assertions.assertThat((boolean)copy.containsControl(NEW_CONTROL3.getOID())).isFalse();
        original.addControl((Control)NEW_CONTROL3);
        Assertions.assertThat((boolean)original.containsControl(NEW_CONTROL3.getOID())).isTrue();
        Assert.assertTrue((original.getControls().size() > 0 ? 1 : 0) != 0);
        Assertions.assertThat((boolean)copy.containsControl(NEW_CONTROL3.getOID())).isFalse();
        copy.addControl((Control)NEW_CONTROL4);
        Assertions.assertThat((boolean)original.containsControl(NEW_CONTROL4.getOID())).isFalse();
        Assertions.assertThat((boolean)copy.containsControl(NEW_CONTROL4.getOID())).isTrue();
    }

    @Test(dataProvider="createCopyOfInstance")
    public void testCopyToStringShouldContainClassName(Request original, Request copy) {
        String className = copy.getClass().getSimpleName().replace("Impl", "");
        Assertions.assertThat((boolean)copy.toString().startsWith(className)).isTrue();
    }

    private static class MyDecoder
    implements ControlDecoder<Control> {
        private MyDecoder() {
        }

        public Control decodeControl(Control control, DecodeOptions options) throws DecodeException {
            return control;
        }

        public String getOID() {
            return "1.2.3".intern();
        }
    }
}

