/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.StaticUtils;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.requests.PlainSASLBindRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.RequestsTestCase;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PlainSASLBindRequestTestCase
extends RequestsTestCase {
    private static final PlainSASLBindRequest NEW_PLAIN_SASL_BIND_REQUEST = Requests.newPlainSASLBindRequest((String)"id1", (byte[])StaticUtils.EMPTY_BYTES);
    private static final PlainSASLBindRequest NEW_PLAIN_SASL_BIND_REQUEST2 = Requests.newPlainSASLBindRequest((String)"id2", (byte[])StaticUtils.getBytes((CharSequence)"password"));

    @DataProvider(name="plainSASLBindRequests")
    private Object[][] getPlainSASLBindRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected PlainSASLBindRequest[] newInstance() {
        return new PlainSASLBindRequest[]{NEW_PLAIN_SASL_BIND_REQUEST, NEW_PLAIN_SASL_BIND_REQUEST2};
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfPlainSASLBindRequest((PlainSASLBindRequest)((PlainSASLBindRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiablePlainSASLBindRequest((PlainSASLBindRequest)((PlainSASLBindRequest)original));
    }

    @Test(dataProvider="plainSASLBindRequests")
    public void testModifiableRequest(PlainSASLBindRequest original) {
        String authID = "u:user.0";
        String azID = "dn:user.0,dc=com";
        String password = "pass";
        PlainSASLBindRequest copy = (PlainSASLBindRequest)this.copyOf((Request)original);
        copy.setAuthenticationID("u:user.0");
        copy.setAuthorizationID("dn:user.0,dc=com");
        copy.setPassword("pass".toCharArray());
        Assertions.assertThat((String)copy.getAuthenticationID()).isEqualTo((Object)"u:user.0");
        Assertions.assertThat((String)copy.getAuthorizationID()).isEqualTo((Object)"dn:user.0,dc=com");
        Assertions.assertThat((String)original.getAuthenticationID()).isNotEqualTo((Object)copy.getAuthenticationID());
        Assertions.assertThat((String)original.getAuthorizationID()).isNotEqualTo((Object)copy.getAuthorizationID());
    }

    @Test(dataProvider="plainSASLBindRequests")
    public void testUnmodifiableRequest(PlainSASLBindRequest original) {
        PlainSASLBindRequest unmodifiable = (PlainSASLBindRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((String)unmodifiable.getName()).isEqualTo((Object)original.getName());
        Assertions.assertThat((String)unmodifiable.getAuthorizationID()).isEqualTo((Object)original.getAuthorizationID());
        Assertions.assertThat((String)unmodifiable.getAuthenticationID()).isEqualTo((Object)original.getAuthenticationID());
        Assertions.assertThat((String)unmodifiable.getSASLMechanism()).isEqualTo((Object)original.getSASLMechanism());
    }

    @Test(dataProvider="plainSASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetAuthenticationID(PlainSASLBindRequest original) {
        PlainSASLBindRequest unmodifiable = (PlainSASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setAuthenticationID("dn: uid=scarter,ou=people,dc=example,dc=com");
    }

    @Test(dataProvider="plainSASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetAuthorizationID(PlainSASLBindRequest original) {
        PlainSASLBindRequest unmodifiable = (PlainSASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setAuthorizationID("dn: uid=scarter,ou=people,dc=example,dc=com");
    }

    @Test(dataProvider="plainSASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetPassword(PlainSASLBindRequest original) {
        PlainSASLBindRequest unmodifiable = (PlainSASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setPassword("password".toCharArray());
    }

    @Test(dataProvider="plainSASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetPassword2(PlainSASLBindRequest original) {
        PlainSASLBindRequest unmodifiable = (PlainSASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setPassword("password".getBytes());
    }
}

