/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.PasswordModifyExtendedRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.RequestsTestCase;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PasswordModifyExtendedRequestTestCase
extends RequestsTestCase {
    @DataProvider(name="passwordModifyExtendedRequests")
    private Object[][] getPasswordModifyExtendedRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected PasswordModifyExtendedRequest[] newInstance() {
        return new PasswordModifyExtendedRequest[]{Requests.newPasswordModifyExtendedRequest()};
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfPasswordModifyExtendedRequest((PasswordModifyExtendedRequest)((PasswordModifyExtendedRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiablePasswordModifyExtendedRequest((PasswordModifyExtendedRequest)((PasswordModifyExtendedRequest)original));
    }

    @Test(dataProvider="passwordModifyExtendedRequests")
    public void testModifiableRequest(PasswordModifyExtendedRequest original) {
        String password = "password";
        String oldPassword = "oldPassword";
        String userIdentity = "user.0";
        PasswordModifyExtendedRequest copy = (PasswordModifyExtendedRequest)this.copyOf((Request)original);
        copy.setNewPassword("password".toCharArray());
        copy.setOldPassword("oldPassword".toCharArray());
        copy.setUserIdentity((Object)ByteString.valueOfUtf8((CharSequence)"user.0"));
        Assertions.assertThat((byte[])copy.getNewPassword()).isEqualTo("password".getBytes());
        Assertions.assertThat((byte[])original.getNewPassword()).isNull();
        Assertions.assertThat((byte[])copy.getOldPassword()).isEqualTo("oldPassword".getBytes());
        Assertions.assertThat((byte[])original.getOldPassword()).isNull();
        Assertions.assertThat((String)copy.getUserIdentityAsString()).isEqualTo((Object)"user.0");
        Assertions.assertThat((String)original.getUserIdentityAsString()).isNull();
    }

    @Test(dataProvider="passwordModifyExtendedRequests")
    public void testModifiableRequestDecode(PasswordModifyExtendedRequest original) throws DecodeException {
        String password = "";
        String oldPassword = "old";
        String userIdentity = "uid=scarter,ou=people,dc=example,dc=com";
        GenericControl control = GenericControl.newControl((String)"1.2.3".intern());
        PasswordModifyExtendedRequest copy = (PasswordModifyExtendedRequest)this.copyOf((Request)original);
        copy.setNewPassword("".toCharArray());
        copy.setUserIdentity((Object)"uid=scarter,ou=people,dc=example,dc=com");
        copy.setOldPassword("old".getBytes());
        copy.addControl((Control)control);
        PasswordModifyExtendedRequest decoded = (PasswordModifyExtendedRequest)PasswordModifyExtendedRequest.DECODER.decodeExtendedRequest((ExtendedRequest)copy, new DecodeOptions());
        Assertions.assertThat((byte[])decoded.getNewPassword()).isEqualTo("".getBytes());
        Assertions.assertThat((byte[])decoded.getOldPassword()).isEqualTo("old".getBytes());
        Assertions.assertThat((Object)decoded.getUserIdentity()).isEqualTo((Object)ByteString.valueOfUtf8((CharSequence)"uid=scarter,ou=people,dc=example,dc=com"));
        Assertions.assertThat((boolean)decoded.getControls().contains(control)).isTrue();
    }

    @Test(dataProvider="passwordModifyExtendedRequests")
    public void testUnmodifiableRequest(PasswordModifyExtendedRequest original) {
        PasswordModifyExtendedRequest unmodifiable = (PasswordModifyExtendedRequest)this.unmodifiableOf((Request)original);
        original.setUserIdentity((Object)"uid=scarter,ou=people,dc=example,dc=com");
        original.setOldPassword("old".getBytes());
        Assertions.assertThat((String)unmodifiable.getOID()).isEqualTo((Object)original.getOID());
        Assertions.assertThat((Object)unmodifiable.getUserIdentity()).isEqualTo((Object)original.getUserIdentity());
        Assertions.assertThat((String)unmodifiable.getUserIdentityAsString()).isEqualTo((Object)original.getUserIdentityAsString());
        original.setNewPassword("carter".getBytes());
        Assertions.assertThat((byte[])unmodifiable.getNewPassword()).isEqualTo(original.getNewPassword());
        Assertions.assertThat((byte[])unmodifiable.getOldPassword()).isEqualTo(original.getOldPassword());
    }

    @Test(dataProvider="passwordModifyExtendedRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetNewPassword(PasswordModifyExtendedRequest original) {
        PasswordModifyExtendedRequest unmodifiable = (PasswordModifyExtendedRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setNewPassword("password".toCharArray());
    }

    @Test(dataProvider="passwordModifyExtendedRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetNewPassword2(PasswordModifyExtendedRequest original) {
        PasswordModifyExtendedRequest unmodifiable = (PasswordModifyExtendedRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setNewPassword("password".getBytes());
    }

    @Test(dataProvider="passwordModifyExtendedRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetOldPassword(PasswordModifyExtendedRequest original) {
        PasswordModifyExtendedRequest unmodifiable = (PasswordModifyExtendedRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setOldPassword("password".toCharArray());
    }

    @Test(dataProvider="passwordModifyExtendedRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetOldPassword2(PasswordModifyExtendedRequest original) {
        PasswordModifyExtendedRequest unmodifiable = (PasswordModifyExtendedRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setOldPassword("password".getBytes());
    }

    @Test(dataProvider="passwordModifyExtendedRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetUserIdentity(PasswordModifyExtendedRequest original) {
        PasswordModifyExtendedRequest unmodifiable = (PasswordModifyExtendedRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setUserIdentity((Object)"uid=scarter,ou=people,dc=example,dc=com");
    }
}

