/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.RequestsTestCase;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ModifyRequestTestCase
extends RequestsTestCase {
    private static final ModifyRequest ADD_MODIFICATION = Requests.newModifyRequest((DN)DN.valueOf((String)"uid=Modifyrequest1")).addModification(ModificationType.ADD, "userpassword", new Object[]{"password"});
    private static final ModifyRequest ADD_MODIFICATION2 = Requests.newModifyRequest((String)"cn=Modifyrequesttestcase").addModification(ModificationType.ADD, "userpassword", new Object[]{"password"});
    private static final ModifyRequest NEW_MODIFY_REQUEST = Requests.newModifyRequest((String[])new String[]{"dn: ou=People,o=test", "changetype: modify", "add: userpassword", "userpassword: password"});

    @DataProvider(name="ModifyRequests")
    private Object[][] getModifyRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected ModifyRequest[] newInstance() {
        return new ModifyRequest[]{ADD_MODIFICATION, ADD_MODIFICATION2, NEW_MODIFY_REQUEST};
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfModifyRequest((ModifyRequest)((ModifyRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableModifyRequest((ModifyRequest)((ModifyRequest)original));
    }

    @Test(dataProvider="ModifyRequests")
    public void testModifiableRequest(ModifyRequest original) {
        String newDN = "cn=Ted,ou=People,dc=example,dc=com";
        ModifyRequest copy = (ModifyRequest)this.copyOf((Request)original);
        copy.setName(DN.valueOf((String)"cn=Ted,ou=People,dc=example,dc=com"));
        Assertions.assertThat((String)copy.getName().toString()).isEqualTo((Object)"cn=Ted,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)copy.toString()).contains("dn=cn=Ted,ou=People,dc=example,dc=com");
    }

    @Test(dataProvider="ModifyRequests")
    public void testUnmodifiableRequest(ModifyRequest original) {
        ModifyRequest unmodifiable = (ModifyRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((String)unmodifiable.getName().toString()).isEqualTo((Object)original.getName().toString());
        Assertions.assertThat((int)unmodifiable.getModifications().size()).isEqualTo(original.getModifications().size());
    }

    @Test(dataProvider="ModifyRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableAddModification(ModifyRequest original) {
        ModifyRequest unmodifiable = (ModifyRequest)this.unmodifiableOf((Request)original);
        unmodifiable.addModification(ModificationType.ADD, "member", new Object[]{DN.valueOf((String)"uid=scarter,ou=people,dc=example,dc=com")});
    }

    @Test(dataProvider="ModifyRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableAddModification2(ModifyRequest original) {
        ModifyRequest unmodifiable = (ModifyRequest)this.unmodifiableOf((Request)original);
        unmodifiable.addModification(new Modification(ModificationType.ADD, (Attribute)new LinkedAttribute("description", (Object)"value1")));
    }

    @Test(dataProvider="ModifyRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetName(ModifyRequest original) {
        ModifyRequest unmodifiable = (ModifyRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setName(DN.valueOf((String)"uid=scarter,ou=people,dc=example,dc=com"));
    }

    @Test(dataProvider="ModifyRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetName2(ModifyRequest original) {
        ModifyRequest unmodifiable = (ModifyRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setName("uid=scarter,ou=people,dc=example,dc=com");
    }
}

