/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.RequestsTestCase;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ModifyDNRequestTestCase
extends RequestsTestCase {
    private static final ModifyDNRequest NEW_MODIFY_DN_REQUEST = Requests.newModifyDNRequest((String)"uid=user.100,ou=people,o=test", (String)"uid=100.user");
    private static final ModifyDNRequest NEW_MODIFY_DN_REQUEST2 = Requests.newModifyDNRequest((String)"cn=ModifyDNrequesttestcase", (String)"cn=xyz");

    @DataProvider(name="ModifyDNRequests")
    private Object[][] getModifyDNRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected ModifyDNRequest[] newInstance() {
        return new ModifyDNRequest[]{NEW_MODIFY_DN_REQUEST, NEW_MODIFY_DN_REQUEST2};
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfModifyDNRequest((ModifyDNRequest)((ModifyDNRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableModifyDNRequest((ModifyDNRequest)((ModifyDNRequest)original));
    }

    @Test(dataProvider="ModifyDNRequests")
    public void testModifiableRequest(ModifyDNRequest original) {
        String newDN = "cn=Ted,ou=People,dc=example,dc=com";
        String superior = "ou=People,dc=example,dc=org";
        ModifyDNRequest copy = (ModifyDNRequest)this.copyOf((Request)original);
        copy.setName(DN.valueOf((String)"cn=Ted,ou=People,dc=example,dc=com"));
        copy.setDeleteOldRDN(true);
        copy.setNewSuperior("ou=People,dc=example,dc=org");
        Assertions.assertThat((String)copy.getName().toString()).isEqualTo((Object)"cn=Ted,ou=People,dc=example,dc=com");
        Assertions.assertThat((String)copy.getNewSuperior().toString()).isEqualTo((Object)"ou=People,dc=example,dc=org");
        Assertions.assertThat((Iterable)original.getNewSuperior()).isNull();
        Assertions.assertThat((String)copy.toString()).contains("deleteOldRDN=true");
    }

    @Test(dataProvider="ModifyDNRequests")
    public void testUnmodifiableRequest(ModifyDNRequest original) {
        ModifyDNRequest unmodifiable = (ModifyDNRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((String)unmodifiable.getName().toString()).isEqualTo((Object)original.getName().toString());
        Assertions.assertThat((Iterable)original.getNewSuperior()).isNull();
        Assertions.assertThat((Iterable)unmodifiable.getNewSuperior()).isNull();
    }

    @Test(dataProvider="ModifyDNRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetDeleteOldRDN(ModifyDNRequest original) {
        ModifyDNRequest unmodifiable = (ModifyDNRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setDeleteOldRDN(true);
    }

    @Test(dataProvider="ModifyDNRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetName(ModifyDNRequest original) {
        ModifyDNRequest unmodifiable = (ModifyDNRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setName(DN.valueOf((String)"uid=scarter,ou=people,dc=example,dc=com"));
    }

    @Test(dataProvider="ModifyDNRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetName2(ModifyDNRequest original) {
        ModifyDNRequest unmodifiable = (ModifyDNRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setName("uid=scarter,ou=people,dc=example,dc=com");
    }

    @Test(dataProvider="ModifyDNRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetNewRDN(ModifyDNRequest original) {
        ModifyDNRequest unmodifiable = (ModifyDNRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setNewRDN("dc=org");
    }

    @Test(dataProvider="ModifyDNRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetNewRDN2(ModifyDNRequest original) {
        ModifyDNRequest unmodifiable = (ModifyDNRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setNewRDN(RDN.valueOf((String)"dc=org"));
    }

    @Test(dataProvider="ModifyDNRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetNewSuperior(ModifyDNRequest original) {
        ModifyDNRequest unmodifiable = (ModifyDNRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setNewSuperior("ou=people2,dc=example,dc=com");
    }

    @Test(dataProvider="ModifyDNRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetNewSuperior2(ModifyDNRequest original) {
        ModifyDNRequest unmodifiable = (ModifyDNRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setNewSuperior(DN.valueOf((String)"ou=people2,dc=example,dc=com"));
    }
}

