/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericExtendedRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.RequestsTestCase;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class GenericExtendedRequestTestCase
extends RequestsTestCase {
    private static final GenericExtendedRequest NEW_GENERICEXTENDED_REQUEST = Requests.newGenericExtendedRequest((String)"Generic1");
    private static final GenericExtendedRequest NEW_GENERICEXTENDED_REQUEST2 = Requests.newGenericExtendedRequest((String)"Generic2");
    private static final GenericExtendedRequest NEW_GENERICEXTENDED_REQUEST3 = Requests.newGenericExtendedRequest((String)"Generic3");

    @DataProvider(name="GenericExtendedRequests")
    private Object[][] getGenericExtendedRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected GenericExtendedRequest[] newInstance() {
        return new GenericExtendedRequest[]{NEW_GENERICEXTENDED_REQUEST, NEW_GENERICEXTENDED_REQUEST2, NEW_GENERICEXTENDED_REQUEST3};
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfGenericExtendedRequest((GenericExtendedRequest)((GenericExtendedRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableGenericExtendedRequest((GenericExtendedRequest)((GenericExtendedRequest)original));
    }

    @Test(dataProvider="GenericExtendedRequests")
    public void testModifiableRequest(GenericExtendedRequest original) {
        String newOID = "1.2.3.99";
        String newValue = "newValue";
        GenericExtendedRequest copy = (GenericExtendedRequest)this.copyOf((Request)original);
        copy.setOID("1.2.3.99");
        copy.setValue((Object)"newValue");
        Assertions.assertThat((String)copy.getOID()).isEqualTo((Object)"1.2.3.99");
        Assertions.assertThat((String)original.getOID()).isNotEqualTo((Object)"1.2.3.99");
    }

    @Test(dataProvider="GenericExtendedRequests")
    public void testUnmodifiableRequest(GenericExtendedRequest original) {
        GenericExtendedRequest unmodifiable = (GenericExtendedRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((String)unmodifiable.getOID()).isEqualTo((Object)original.getOID());
        Assertions.assertThat((Object)unmodifiable.getValue()).isEqualTo((Object)original.getValue());
        Assertions.assertThat((Object)unmodifiable.getResultDecoder()).isEqualTo((Object)original.getResultDecoder());
    }

    @Test(dataProvider="GenericExtendedRequests")
    public void testModifiableRequestDecode(GenericExtendedRequest original) throws DecodeException {
        String oid = "1.2.3.4";
        String value = "myValue";
        GenericControl control = GenericControl.newControl((String)"1.2.3".intern());
        GenericExtendedRequest copy = (GenericExtendedRequest)this.copyOf((Request)original);
        copy.setOID("1.2.3.4");
        copy.setValue((Object)"myValue");
        copy.addControl((Control)control);
        GenericExtendedRequest decoded = (GenericExtendedRequest)GenericExtendedRequest.DECODER.decodeExtendedRequest((ExtendedRequest)copy, new DecodeOptions());
        Assertions.assertThat((String)decoded.getOID()).isEqualTo((Object)"1.2.3.4");
        Assertions.assertThat((Object)decoded.getValue()).isEqualTo((Object)ByteString.valueOfUtf8((CharSequence)"myValue"));
        Assertions.assertThat((boolean)decoded.getControls().contains(control)).isTrue();
    }
}

