/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.StaticUtils;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.requests.BindRequestTestCase;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class GenericBindRequestTestCase
extends BindRequestTestCase {
    private static final GenericBindRequest NEW_GENERIC_BIND_REQUEST = Requests.newGenericBindRequest((byte)-93, (byte[])StaticUtils.EMPTY_BYTES);
    private static final GenericBindRequest NEW_GENERIC_BIND_REQUEST2 = Requests.newGenericBindRequest((byte)-128, (byte[])StaticUtils.getBytes((CharSequence)"password"));
    private static final GenericBindRequest NEW_GENERIC_BIND_REQUEST3 = Requests.newGenericBindRequest((String)"username", (byte)-128, (byte[])StaticUtils.getBytes((CharSequence)"password"));

    @DataProvider(name="GenericBindRequests")
    private Object[][] getGenericBindRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected GenericBindRequest[] newInstance() {
        return new GenericBindRequest[]{NEW_GENERIC_BIND_REQUEST, NEW_GENERIC_BIND_REQUEST2, NEW_GENERIC_BIND_REQUEST3};
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfGenericBindRequest((GenericBindRequest)((GenericBindRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableGenericBindRequest((GenericBindRequest)((GenericBindRequest)original));
    }

    @Test(dataProvider="GenericBindRequests")
    public void testModifiableRequest(GenericBindRequest original) {
        String password = "pass";
        String newName = "uid:user.0";
        GenericBindRequest copy = (GenericBindRequest)this.copyOf((Request)original);
        copy.setAuthenticationType((byte)0);
        copy.setAuthenticationValue("pass".getBytes());
        copy.setName("uid:user.0");
        Assertions.assertThat((byte)copy.getAuthenticationType()).isEqualTo((byte)0);
        Assertions.assertThat((byte)original.getAuthenticationType()).isNotEqualTo((byte)0);
        Assertions.assertThat((byte[])copy.getAuthenticationValue()).isEqualTo("pass".getBytes());
    }

    @Test(dataProvider="GenericBindRequests")
    public void testUnmodifiableRequest(GenericBindRequest original) {
        GenericBindRequest unmodifiable = (GenericBindRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((byte)unmodifiable.getAuthenticationType()).isEqualTo(original.getAuthenticationType());
        Assertions.assertThat((byte[])unmodifiable.getAuthenticationValue()).isEqualTo(original.getAuthenticationValue());
    }

    @Test(dataProvider="GenericBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetName(GenericBindRequest original) {
        GenericBindRequest unmodifiable = (GenericBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setName("");
    }

    @Test(dataProvider="GenericBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetAuthenticationType(GenericBindRequest original) {
        GenericBindRequest unmodifiable = (GenericBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setAuthenticationType((byte)-93);
    }

    @Test(dataProvider="GenericBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetAuthenticationValue(GenericBindRequest original) {
        GenericBindRequest unmodifiable = (GenericBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setAuthenticationValue(null);
    }
}

