/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.StaticUtils;
import java.util.Arrays;
import java.util.Collection;
import javax.security.auth.Subject;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.BindRequestTestCase;
import org.forgerock.opendj.ldap.requests.GSSAPISASLBindRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class GSSAPISASLBindRequestTestCase
extends BindRequestTestCase {
    private static final GSSAPISASLBindRequest NEW_GSSAPISASL_BIND_REQUEST = Requests.newGSSAPISASLBindRequest((String)"id1", (byte[])StaticUtils.EMPTY_BYTES);
    private static final GSSAPISASLBindRequest NEW_GSSAPISASL_BIND_REQUEST2 = Requests.newGSSAPISASLBindRequest((String)"id2", (byte[])StaticUtils.getBytes((CharSequence)"password"));

    @DataProvider(name="GSSAPISASLBindRequests")
    private Object[][] getGSSAPISASLBindRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected GSSAPISASLBindRequest[] newInstance() {
        return new GSSAPISASLBindRequest[]{NEW_GSSAPISASL_BIND_REQUEST, NEW_GSSAPISASL_BIND_REQUEST2};
    }

    @Override
    @Test(enabled=false)
    public void testBindClient(BindRequest request) throws Exception {
        super.testBindClient(request);
    }

    @Test(dataProvider="GSSAPISASLBindRequests")
    public void testQOP(GSSAPISASLBindRequest request) throws Exception {
        String[] options = new String[]{"auth", "auth-int", "auth-conf"};
        request.addQOP(options);
        Assert.assertEquals((Collection)request.getQOPs(), Arrays.asList(options));
    }

    @Test(dataProvider="GSSAPISASLBindRequests")
    public void testServerAuth(GSSAPISASLBindRequest request) throws Exception {
        request.setServerAuth(true);
        Assert.assertEquals((boolean)request.isServerAuth(), (boolean)true);
    }

    @Test(dataProvider="GSSAPISASLBindRequests")
    public void testSendBuffer(GSSAPISASLBindRequest request) throws Exception {
        request.setMaxSendBufferSize(512);
        Assert.assertEquals((int)request.getMaxSendBufferSize(), (int)512);
    }

    @Test(dataProvider="GSSAPISASLBindRequests")
    public void testRecieveBuffer(GSSAPISASLBindRequest request) throws Exception {
        request.setMaxReceiveBufferSize(512);
        Assert.assertEquals((int)request.getMaxReceiveBufferSize(), (int)512);
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfGSSAPISASLBindRequest((GSSAPISASLBindRequest)((GSSAPISASLBindRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableGSSAPISASLBindRequest((GSSAPISASLBindRequest)((GSSAPISASLBindRequest)original));
    }

    @Test(dataProvider="GSSAPISASLBindRequests")
    public void testModifiableRequest(GSSAPISASLBindRequest original) {
        String authID = "u:user.0";
        String azID = "dn:user.0,dc=com";
        String password = "pass";
        int maxRBufferSize = 1024;
        int maxSBufferSize = 2048;
        String realm = "my.domain.com";
        Subject subject = new Subject();
        subject.setReadOnly();
        GSSAPISASLBindRequest copy = (GSSAPISASLBindRequest)this.copyOf((Request)original);
        copy.setAuthenticationID("u:user.0");
        copy.setAuthorizationID("dn:user.0,dc=com");
        copy.setPassword("pass".toCharArray());
        copy.setMaxReceiveBufferSize(1024);
        copy.setMaxSendBufferSize(2048);
        copy.setRealm("my.domain.com");
        copy.setServerAuth(true);
        copy.setSubject(subject);
        Assertions.assertThat((String)copy.getAuthenticationID()).isEqualTo((Object)"u:user.0");
        Assertions.assertThat((String)copy.getAuthorizationID()).isEqualTo((Object)"dn:user.0,dc=com");
        Assertions.assertThat((int)copy.getMaxReceiveBufferSize()).isEqualTo(1024);
        Assertions.assertThat((int)copy.getMaxSendBufferSize()).isEqualTo(2048);
        Assertions.assertThat((String)copy.getRealm()).isEqualTo((Object)"my.domain.com");
        Assertions.assertThat((String)original.getRealm()).isNotEqualTo((Object)"my.domain.com");
        Assertions.assertThat((Object)copy.getSubject()).isEqualTo((Object)subject);
        Assertions.assertThat((Object)original.getSubject()).isNotEqualTo((Object)subject);
    }

    @Test(dataProvider="GSSAPISASLBindRequests")
    public void testUnmodifiableRequest(GSSAPISASLBindRequest original) {
        GSSAPISASLBindRequest unmodifiable = (GSSAPISASLBindRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((String)unmodifiable.getAuthorizationID()).isEqualTo((Object)original.getAuthorizationID());
        Assertions.assertThat((int)unmodifiable.getMaxReceiveBufferSize()).isEqualTo(original.getMaxReceiveBufferSize());
        Assertions.assertThat((int)unmodifiable.getMaxSendBufferSize()).isEqualTo(original.getMaxSendBufferSize());
        Assertions.assertThat((String)unmodifiable.getRealm()).isEqualTo((Object)original.getRealm());
        Assertions.assertThat((Object)unmodifiable.getSubject()).isEqualTo((Object)original.getSubject());
        Assertions.assertThat((String)unmodifiable.getSASLMechanism()).isEqualTo((Object)original.getSASLMechanism());
    }

    @Test(dataProvider="GSSAPISASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableAddAdditionalAuthParam(GSSAPISASLBindRequest original) {
        GSSAPISASLBindRequest unmodifiable = (GSSAPISASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.addAdditionalAuthParam("id2", "value");
    }

    @Test(dataProvider="GSSAPISASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableAddQOP(GSSAPISASLBindRequest original) {
        GSSAPISASLBindRequest unmodifiable = (GSSAPISASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.addQOP(new String[]{"auth", "auth-conf"});
    }

    @Test(dataProvider="GSSAPISASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetAuthenticationID(GSSAPISASLBindRequest original) {
        GSSAPISASLBindRequest unmodifiable = (GSSAPISASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setAuthenticationID("dn: uid=scarter,ou=people,dc=example,dc=com");
    }

    @Test(dataProvider="GSSAPISASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetAuthorizationID(GSSAPISASLBindRequest original) {
        GSSAPISASLBindRequest unmodifiable = (GSSAPISASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setAuthorizationID("dn: uid=scarter,ou=people,dc=example,dc=com");
    }

    @Test(dataProvider="GSSAPISASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetMaxReceiveBufferSize(GSSAPISASLBindRequest original) {
        GSSAPISASLBindRequest unmodifiable = (GSSAPISASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setMaxReceiveBufferSize(1048);
    }

    @Test(dataProvider="GSSAPISASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetMaxSendBufferSize(GSSAPISASLBindRequest original) {
        GSSAPISASLBindRequest unmodifiable = (GSSAPISASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setMaxSendBufferSize(1048);
    }

    @Test(dataProvider="GSSAPISASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetPassword(GSSAPISASLBindRequest original) {
        GSSAPISASLBindRequest unmodifiable = (GSSAPISASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setPassword("password".getBytes());
    }

    @Test(dataProvider="GSSAPISASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetPassword2(GSSAPISASLBindRequest original) {
        GSSAPISASLBindRequest unmodifiable = (GSSAPISASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setPassword("password".toCharArray());
    }

    @Test(dataProvider="GSSAPISASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetRealm(GSSAPISASLBindRequest original) {
        GSSAPISASLBindRequest unmodifiable = (GSSAPISASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setRealm("my.domain");
    }

    @Test(dataProvider="GSSAPISASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetServerAuth(GSSAPISASLBindRequest original) {
        GSSAPISASLBindRequest unmodifiable = (GSSAPISASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setServerAuth(true);
    }
}

