/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.requests.BindRequestTestCase;
import org.forgerock.opendj.ldap.requests.ExternalSASLBindRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ExternalSASLBindRequestTestCase
extends BindRequestTestCase {
    private static final ExternalSASLBindRequest NEW_EXTERNAL_SASL_BIND_REQUEST = Requests.newExternalSASLBindRequest();

    @DataProvider(name="ExternalSASLBindRequests")
    private Object[][] getExternalSASLBindRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected ExternalSASLBindRequest[] newInstance() {
        return new ExternalSASLBindRequest[]{NEW_EXTERNAL_SASL_BIND_REQUEST};
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfExternalSASLBindRequest((ExternalSASLBindRequest)((ExternalSASLBindRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableExternalSASLBindRequest((ExternalSASLBindRequest)((ExternalSASLBindRequest)original));
    }

    @Test(dataProvider="ExternalSASLBindRequests")
    public void testModifiableRequest(ExternalSASLBindRequest original) {
        String authID = "u:user.0";
        ExternalSASLBindRequest copy = (ExternalSASLBindRequest)this.copyOf((Request)original);
        copy.setAuthorizationID("u:user.0");
        Assertions.assertThat((String)copy.getAuthorizationID()).isEqualTo((Object)"u:user.0");
        Assertions.assertThat((String)copy.getSASLMechanism()).isEqualTo((Object)original.getSASLMechanism());
    }

    @Test(dataProvider="ExternalSASLBindRequests")
    public void testUnmodifiableRequest(ExternalSASLBindRequest original) {
        ExternalSASLBindRequest unmodifiable = (ExternalSASLBindRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((String)unmodifiable.getAuthorizationID()).isEqualTo((Object)original.getAuthorizationID());
        Assertions.assertThat((byte)unmodifiable.getAuthenticationType()).isEqualTo(original.getAuthenticationType());
        Assertions.assertThat((String)unmodifiable.getSASLMechanism()).isEqualTo((Object)original.getSASLMechanism());
    }

    @Test(dataProvider="ExternalSASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetAuthorizationID(ExternalSASLBindRequest original) {
        ExternalSASLBindRequest unmodifiable = (ExternalSASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setAuthorizationID("dn: uid=scarter,ou=people,dc=example,dc=com");
    }
}

