/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.StaticUtils;
import java.util.Arrays;
import java.util.Collection;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.requests.BindRequestTestCase;
import org.forgerock.opendj.ldap.requests.DigestMD5SASLBindRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DigestMD5SASLBindRequestTestCase
extends BindRequestTestCase {
    private static final DigestMD5SASLBindRequest NEW_DIGEST_MD5SASL_BIND_REQUEST = Requests.newDigestMD5SASLBindRequest((String)"id1", (byte[])StaticUtils.EMPTY_BYTES);
    private static final DigestMD5SASLBindRequest NEW_DIGEST_MD5SASL_BIND_REQUEST2 = Requests.newDigestMD5SASLBindRequest((String)"id2", (byte[])StaticUtils.getBytes((CharSequence)"password"));

    @DataProvider(name="DigestMD5SASLBindRequests")
    private Object[][] getDigestMD5SASLBindRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected DigestMD5SASLBindRequest[] newInstance() {
        return new DigestMD5SASLBindRequest[]{NEW_DIGEST_MD5SASL_BIND_REQUEST, NEW_DIGEST_MD5SASL_BIND_REQUEST2};
    }

    @Test(dataProvider="DigestMD5SASLBindRequests")
    public void testQOP(DigestMD5SASLBindRequest request) throws Exception {
        String[] options = new String[]{"auth", "auth-int", "auth-conf"};
        request.addQOP(options);
        Assert.assertEquals((Collection)request.getQOPs(), Arrays.asList(options));
    }

    @Test(dataProvider="DigestMD5SASLBindRequests")
    public void testStrength(DigestMD5SASLBindRequest request) throws Exception {
        request.setCipher("3des");
        Assert.assertEquals((String)request.getCipher(), (String)"3des");
        request.setCipher("medium");
        Assert.assertEquals((String)request.getCipher(), (String)"medium");
    }

    @Test(dataProvider="DigestMD5SASLBindRequests")
    public void testServerAuth(DigestMD5SASLBindRequest request) throws Exception {
        request.setServerAuth(true);
        Assert.assertEquals((boolean)request.isServerAuth(), (boolean)true);
    }

    @Test(dataProvider="DigestMD5SASLBindRequests")
    public void testSendBuffer(DigestMD5SASLBindRequest request) throws Exception {
        request.setMaxSendBufferSize(1024);
        Assert.assertEquals((int)request.getMaxSendBufferSize(), (int)1024);
    }

    @Test(dataProvider="DigestMD5SASLBindRequests")
    public void testRecieveBuffer(DigestMD5SASLBindRequest request) throws Exception {
        request.setMaxReceiveBufferSize(1024);
        Assert.assertEquals((int)request.getMaxReceiveBufferSize(), (int)1024);
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfDigestMD5SASLBindRequest((DigestMD5SASLBindRequest)((DigestMD5SASLBindRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableDigestMD5SASLBindRequest((DigestMD5SASLBindRequest)((DigestMD5SASLBindRequest)original));
    }

    @Test(dataProvider="DigestMD5SASLBindRequests")
    public void testModifiableRequest(DigestMD5SASLBindRequest original) {
        String authID = "u:user.0";
        String azID = "dn:user.0,dc=com";
        String cipher = "low";
        String password = "pass";
        int maxRBufferSize = 1024;
        int maxSBufferSize = 2048;
        String realm = "my.domain.com";
        DigestMD5SASLBindRequest copy = (DigestMD5SASLBindRequest)this.copyOf((Request)original);
        copy.setAuthenticationID("u:user.0");
        copy.setAuthorizationID("dn:user.0,dc=com");
        copy.setCipher("low");
        copy.setPassword("pass".toCharArray());
        copy.setMaxReceiveBufferSize(1024);
        copy.setMaxSendBufferSize(2048);
        copy.setRealm("my.domain.com");
        copy.setServerAuth(true);
        Assertions.assertThat((String)copy.getAuthenticationID()).isEqualTo((Object)"u:user.0");
        Assertions.assertThat((String)copy.getAuthorizationID()).isEqualTo((Object)"dn:user.0,dc=com");
        Assertions.assertThat((String)copy.getCipher()).isEqualTo((Object)"low");
        Assertions.assertThat((int)copy.getMaxReceiveBufferSize()).isEqualTo(1024);
        Assertions.assertThat((int)copy.getMaxSendBufferSize()).isEqualTo(2048);
        Assertions.assertThat((String)copy.getRealm()).isEqualTo((Object)"my.domain.com");
        Assertions.assertThat((String)original.getRealm()).isNotEqualTo((Object)"my.domain.com");
    }

    @Test(dataProvider="DigestMD5SASLBindRequests")
    public void testUnmodifiableRequest(DigestMD5SASLBindRequest original) {
        DigestMD5SASLBindRequest unmodifiable = (DigestMD5SASLBindRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((String)unmodifiable.getAuthorizationID()).isEqualTo((Object)original.getAuthorizationID());
        Assertions.assertThat((String)unmodifiable.getCipher()).isEqualTo((Object)original.getCipher());
        Assertions.assertThat((int)unmodifiable.getMaxReceiveBufferSize()).isEqualTo(original.getMaxReceiveBufferSize());
        Assertions.assertThat((int)unmodifiable.getMaxSendBufferSize()).isEqualTo(original.getMaxSendBufferSize());
        Assertions.assertThat((String)unmodifiable.getRealm()).isEqualTo((Object)original.getRealm());
    }

    @Test(dataProvider="DigestMD5SASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableAddAdditionalAuthParam(DigestMD5SASLBindRequest original) {
        DigestMD5SASLBindRequest unmodifiable = (DigestMD5SASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.addAdditionalAuthParam("id2", "value");
    }

    @Test(dataProvider="DigestMD5SASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableAddQOP(DigestMD5SASLBindRequest original) {
        DigestMD5SASLBindRequest unmodifiable = (DigestMD5SASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.addQOP(new String[]{"auth", "auth-conf"});
    }

    @Test(dataProvider="DigestMD5SASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetAuthenticationID(DigestMD5SASLBindRequest original) {
        DigestMD5SASLBindRequest unmodifiable = (DigestMD5SASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setAuthenticationID("dn: uid=scarter,ou=people,dc=example,dc=com");
    }

    @Test(dataProvider="DigestMD5SASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetAuthorizationID(DigestMD5SASLBindRequest original) {
        DigestMD5SASLBindRequest unmodifiable = (DigestMD5SASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setAuthorizationID("dn: uid=scarter,ou=people,dc=example,dc=com");
    }

    @Test(dataProvider="DigestMD5SASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetCipher(DigestMD5SASLBindRequest original) {
        DigestMD5SASLBindRequest unmodifiable = (DigestMD5SASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setCipher("low");
    }

    @Test(dataProvider="DigestMD5SASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetMaxReceiveBufferSize(DigestMD5SASLBindRequest original) {
        DigestMD5SASLBindRequest unmodifiable = (DigestMD5SASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setMaxReceiveBufferSize(1048);
    }

    @Test(dataProvider="DigestMD5SASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetMaxSendBufferSize(DigestMD5SASLBindRequest original) {
        DigestMD5SASLBindRequest unmodifiable = (DigestMD5SASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setMaxSendBufferSize(1048);
    }

    @Test(dataProvider="DigestMD5SASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetPassword(DigestMD5SASLBindRequest original) {
        DigestMD5SASLBindRequest unmodifiable = (DigestMD5SASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setPassword("password".getBytes());
    }

    @Test(dataProvider="DigestMD5SASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetPassword2(DigestMD5SASLBindRequest original) {
        DigestMD5SASLBindRequest unmodifiable = (DigestMD5SASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setPassword("passworda".toCharArray());
    }

    @Test(dataProvider="DigestMD5SASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetRealm(DigestMD5SASLBindRequest original) {
        DigestMD5SASLBindRequest unmodifiable = (DigestMD5SASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setRealm("my.domain");
    }

    @Test(dataProvider="DigestMD5SASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetServerAuth(DigestMD5SASLBindRequest original) {
        DigestMD5SASLBindRequest unmodifiable = (DigestMD5SASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setServerAuth(true);
    }
}

