/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.RequestsTestCase;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DeleteRequestTestCase
extends RequestsTestCase {
    private static final DeleteRequest NEW_DELETE_REQUEST = Requests.newDeleteRequest((DN)DN.valueOf((String)"uid=Deleterequest1"));
    private static final DeleteRequest NEW_DELETE_REQUEST2 = Requests.newDeleteRequest((String)"cn=Deleterequesttestcase");
    private static final DeleteRequest NEW_DELETE_REQUEST3 = Requests.newDeleteRequest((String)"uid=user.999,ou=people,o=test");

    @DataProvider(name="deleteRequests")
    private Object[][] getDeleteRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected DeleteRequest[] newInstance() {
        return new DeleteRequest[]{NEW_DELETE_REQUEST, NEW_DELETE_REQUEST2, NEW_DELETE_REQUEST3};
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfDeleteRequest((DeleteRequest)((DeleteRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableDeleteRequest((DeleteRequest)((DeleteRequest)original));
    }

    @Test(dataProvider="deleteRequests")
    public void testModifiableRequest(DeleteRequest original) {
        String newValue = "uid=newName";
        DeleteRequest copy = (DeleteRequest)this.copyOf((Request)original);
        copy.setName("uid=newName");
        Assertions.assertThat((String)copy.getName().toString()).isEqualTo((Object)"uid=newName");
        Assertions.assertThat((String)original.getName().toString()).isNotEqualTo((Object)"uid=newName");
    }

    @Test(dataProvider="deleteRequests")
    public void testUnmodifiableRequest(DeleteRequest original) {
        DeleteRequest unmodifiable = (DeleteRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((String)unmodifiable.getName().toString()).isEqualTo((Object)original.getName().toString());
    }

    @Test(dataProvider="deleteRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetName(DeleteRequest original) {
        DeleteRequest unmodifiable = (DeleteRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setName("uid=scarter,ou=people,dc=example,dc=com");
    }

    @Test(dataProvider="deleteRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetName2(DeleteRequest original) {
        DeleteRequest unmodifiable = (DeleteRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setName(DN.valueOf((String)"uid=scarter,ou=people,dc=example,dc=com"));
    }
}

