/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.RequestsTestCase;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class CompareRequestTestCase
extends RequestsTestCase {
    private static final CompareRequest NEW_COMPARE_REQUEST2 = Requests.newCompareRequest((String)"uid=user.0,ou=people,o=test", (String)"uid", (Object)"user.0");
    private static final CompareRequest NEW_COMPARE_REQUEST = Requests.newCompareRequest((String)"uid=user.0,ou=people,o=test", (String)"cn", (Object)"user.0");

    @DataProvider(name="compareRequests")
    private Object[][] getCompareRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected CompareRequest[] newInstance() {
        return new CompareRequest[]{NEW_COMPARE_REQUEST, NEW_COMPARE_REQUEST2};
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfCompareRequest((CompareRequest)((CompareRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableCompareRequest((CompareRequest)((CompareRequest)original));
    }

    @Test(dataProvider="compareRequests")
    public void testModifiableRequest(CompareRequest original) {
        String newValue = "uid=user.0";
        String attrDescription = "newattributedescription";
        CompareRequest copy = (CompareRequest)this.copyOf((Request)original);
        copy.setName("uid=user.0");
        copy.setAttributeDescription("newattributedescription");
        Assertions.assertThat((String)copy.getName().toString()).isEqualTo((Object)"uid=user.0");
        Assertions.assertThat((String)original.getName().toString()).isNotEqualTo((Object)"uid=user.0");
        Assertions.assertThat((String)copy.getAttributeDescription().toString()).isEqualTo((Object)"newattributedescription");
        Assertions.assertThat((Object)original.getAttributeDescription()).isNotEqualTo((Object)"newattributedescription");
    }

    @Test(dataProvider="compareRequests")
    public void testUnmodifiableRequest(CompareRequest original) {
        CompareRequest unmodifiable = (CompareRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((Object)unmodifiable.getAssertionValue()).isEqualTo((Object)original.getAssertionValue());
        Assertions.assertThat((Object)unmodifiable.getAttributeDescription()).isEqualTo((Object)original.getAttributeDescription());
        Assertions.assertThat((String)unmodifiable.getName().toString()).isEqualTo((Object)original.getName().toString());
    }

    @Test(dataProvider="compareRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetAssertionValue(CompareRequest original) {
        CompareRequest unmodifiable = (CompareRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setAssertionValue((Object)"newValue");
    }

    @Test(dataProvider="compareRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetAttributeDescription(CompareRequest original) {
        CompareRequest unmodifiable = (CompareRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setAttributeDescription(AttributeDescription.valueOf((String)"sn"));
    }

    @Test(dataProvider="compareRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetAttributeDescription2(CompareRequest original) {
        CompareRequest unmodifiable = (CompareRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setAttributeDescription("sn");
    }

    @Test(dataProvider="compareRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetName(CompareRequest original) {
        CompareRequest unmodifiable = (CompareRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setName("uid=user.0");
    }

    @Test(dataProvider="compareRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetName2(CompareRequest original) {
        CompareRequest unmodifiable = (CompareRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setName(DN.valueOf((String)"uid=user.0"));
    }
}

