/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.requests.CancelExtendedRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.RequestsTestCase;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class CancelExtendedRequestTestCase
extends RequestsTestCase {
    private static final CancelExtendedRequest NEW_CANCELEXTENDED_REQUEST = Requests.newCancelExtendedRequest((int)-1);
    private static final CancelExtendedRequest NEW_CANCELEXTENDED_REQUEST2 = Requests.newCancelExtendedRequest((int)0);
    private static final CancelExtendedRequest NEW_CANCELEXTENDED_REQUEST3 = Requests.newCancelExtendedRequest((int)1);

    @DataProvider(name="cancelExtendedRequests")
    private Object[][] getCancelExtendedRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected CancelExtendedRequest[] newInstance() {
        return new CancelExtendedRequest[]{NEW_CANCELEXTENDED_REQUEST, NEW_CANCELEXTENDED_REQUEST2, NEW_CANCELEXTENDED_REQUEST3};
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfCancelExtendedRequest((CancelExtendedRequest)((CancelExtendedRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableCancelExtendedRequest((CancelExtendedRequest)((CancelExtendedRequest)original));
    }

    @Test(dataProvider="cancelExtendedRequests")
    public void testModifiableRequest(CancelExtendedRequest original) {
        int newReqId = 9999;
        CancelExtendedRequest copy = (CancelExtendedRequest)this.copyOf((Request)original);
        copy.setRequestID(9999);
        Assertions.assertThat((int)copy.getRequestID()).isEqualTo(9999);
        Assertions.assertThat((String)copy.getOID()).isEqualTo((Object)original.getOID());
        Assertions.assertThat((int)original.getRequestID()).isNotEqualTo(9999);
    }

    @Test(dataProvider="cancelExtendedRequests")
    public void testUnmodifiableRequest(CancelExtendedRequest original) {
        CancelExtendedRequest unmodifiable = (CancelExtendedRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((int)unmodifiable.getRequestID()).isEqualTo(original.getRequestID());
        Assertions.assertThat((String)unmodifiable.getOID()).isEqualTo((Object)original.getOID());
        Assertions.assertThat((Object)unmodifiable.getResultDecoder()).isEqualTo((Object)original.getResultDecoder());
        Assertions.assertThat((Object)unmodifiable.getValue()).isEqualTo((Object)original.getValue());
    }

    @Test(dataProvider="cancelExtendedRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetRequestId(CancelExtendedRequest original) {
        CancelExtendedRequest unmodifiable = (CancelExtendedRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setRequestID(99);
    }

    @Test(dataProvider="cancelExtendedRequests")
    public void testModifiableRequestDecode(CancelExtendedRequest original) throws DecodeException {
        GenericControl control = GenericControl.newControl((String)"1.2.3".intern());
        CancelExtendedRequest copy = (CancelExtendedRequest)this.copyOf((Request)original);
        copy.setRequestID(99);
        copy.addControl((Control)control);
        Assertions.assertThat((boolean)original.getControls().contains(control)).isFalse();
        CancelExtendedRequest decoded = (CancelExtendedRequest)CancelExtendedRequest.DECODER.decodeExtendedRequest((ExtendedRequest)copy, new DecodeOptions());
        Assertions.assertThat((boolean)decoded.getControls().contains(control)).isTrue();
    }
}

