/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.StaticUtils;
import org.fest.assertions.Assertions;
import org.forgerock.opendj.ldap.requests.BindRequestTestCase;
import org.forgerock.opendj.ldap.requests.CRAMMD5SASLBindRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class CRAMMD5SASLBindRequestTestCase
extends BindRequestTestCase {
    private static final CRAMMD5SASLBindRequest NEW_CRAMMD5SASL_BIND_REQUEST = Requests.newCRAMMD5SASLBindRequest((String)"id1", (byte[])StaticUtils.EMPTY_BYTES);
    private static final CRAMMD5SASLBindRequest NEW_CRAMMD5SASL_BIND_REQUEST2 = Requests.newCRAMMD5SASLBindRequest((String)"id2", (byte[])StaticUtils.getBytes((CharSequence)"test"));

    @DataProvider(name="CRAMMD5SASLBindRequests")
    private Object[][] getCRAMMD5SASLBindRequests() throws Exception {
        return this.createModifiableInstance();
    }

    protected CRAMMD5SASLBindRequest[] newInstance() {
        return new CRAMMD5SASLBindRequest[]{NEW_CRAMMD5SASL_BIND_REQUEST, NEW_CRAMMD5SASL_BIND_REQUEST2};
    }

    @Override
    protected Request copyOf(Request original) {
        return Requests.copyOfCRAMMD5SASLBindRequest((CRAMMD5SASLBindRequest)((CRAMMD5SASLBindRequest)original));
    }

    @Override
    protected Request unmodifiableOf(Request original) {
        return Requests.unmodifiableCRAMMD5SASLBindRequest((CRAMMD5SASLBindRequest)((CRAMMD5SASLBindRequest)original));
    }

    @Test(dataProvider="CRAMMD5SASLBindRequests")
    public void testModifiableRequest(CRAMMD5SASLBindRequest original) {
        String authId = "newAuthId";
        String pwd = "pass";
        String pwd2 = "pass2";
        CRAMMD5SASLBindRequest copy = (CRAMMD5SASLBindRequest)this.copyOf((Request)original);
        copy.setAuthenticationID("newAuthId");
        Assertions.assertThat((String)copy.getAuthenticationID()).isEqualTo((Object)"newAuthId");
        Assertions.assertThat((String)original.getAuthenticationID()).isNotEqualTo((Object)"newAuthId");
        copy.setPassword("pass".toCharArray());
        Assertions.assertThat((byte[])copy.getPassword()).isEqualTo("pass".getBytes());
        Assertions.assertThat((byte[])original.getPassword()).isNotEqualTo("pass".getBytes());
        copy.setPassword("pass2".getBytes());
        Assertions.assertThat((byte[])copy.getPassword()).isEqualTo("pass2".getBytes());
        Assertions.assertThat((byte[])original.getPassword()).isNotEqualTo("pass2".getBytes());
    }

    @Test(dataProvider="CRAMMD5SASLBindRequests")
    public void testUnmodifiableRequest(CRAMMD5SASLBindRequest original) {
        CRAMMD5SASLBindRequest unmodifiable = (CRAMMD5SASLBindRequest)this.unmodifiableOf((Request)original);
        Assertions.assertThat((String)unmodifiable.getAuthenticationID()).isEqualTo((Object)original.getAuthenticationID());
        Assertions.assertThat((byte)unmodifiable.getAuthenticationType()).isEqualTo(original.getAuthenticationType());
        Assertions.assertThat((String)unmodifiable.getName()).isEqualTo((Object)original.getName());
        Assertions.assertThat((byte[])unmodifiable.getPassword()).isEqualTo(original.getPassword());
        Assertions.assertThat((String)unmodifiable.getSASLMechanism()).isEqualTo((Object)original.getSASLMechanism());
    }

    @Test(dataProvider="CRAMMD5SASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetAuthenticationId(CRAMMD5SASLBindRequest original) {
        CRAMMD5SASLBindRequest unmodifiable = (CRAMMD5SASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setAuthenticationID("dn: uid=scarter,ou=people,dc=example,dc=com");
    }

    @Test(dataProvider="CRAMMD5SASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetPassword(CRAMMD5SASLBindRequest original) {
        CRAMMD5SASLBindRequest unmodifiable = (CRAMMD5SASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setPassword("password".getBytes());
    }

    @Test(dataProvider="CRAMMD5SASLBindRequests", expectedExceptions={UnsupportedOperationException.class})
    public void testUnmodifiableSetPassword2(CRAMMD5SASLBindRequest original) {
        CRAMMD5SASLBindRequest unmodifiable = (CRAMMD5SASLBindRequest)this.unmodifiableOf((Request)original);
        unmodifiable.setPassword("password".toCharArray());
    }
}

